<?php
/**
 * @version $Id: default.php 389 2015-03-24 17:43:47Z michal $
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Michal Olczyk - michal.olczyk@design-joomla.eu
 *
 * DJ-Catalog2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-Catalog2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
 *
 */

defined('_JEXEC') or die('Restricted access');
$params = Djcatalog2Helper::getParams();
$show_tax 		= (int)$params->get('price_display_tax', 0);
$i = 1;
$row = 0;
?>
<div class="djc_cart_related_accessories">
    <h3><?php echo JText::_('COM_DJCATALOG2_RELATED_ACCESSORIES') ?></h3>
    <div class="djc_items mod_djc_items djc_clearfix">
			<?php foreach ($this->related_accessories as $item) : ?>


            <?php if($i % 4 == 1) : ?>
                    <div class="accessory-row cols-4 row-<?php echo $row; ?> row-fluid clearfix">
            <?php endif; ?>
				<?php $item->_link = $product_url = JRoute::_(DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug)); ?>
				<?php $prices = Djcatalog2HelperPrice::getPrices($item->final_price, $item->price, $item->tax_rule_id, false, $params); ?>
                <div class="span3">
                    <div class="djc_related_accessory">
						<?php
						$variant = 'img';
						$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
						$imageData = array('item' => &$item,
							'type' => 'item',
							'size' => array(
								'width' => (int)$params->get('imagewidth', '240'),
								'height' => (int)$params->get('imageheight', '240'),
								'keep_ratio' => !(bool)$params->get('imageprocess', true)
							),
							'variant' => $variant,
							'hover_img' => false,
							'context' => 'com_djcatalog2.items.module',
							'params' => &$params);
						echo $layout->render($imageData);
						?>
                        <div class="djc_title">
                            <h4><a href="<?php echo $product_url; ?>"><?php echo $item->name; ?></a></h4>
                        </div>
                        <div class="djc_introtext">
							<?php echo DJCatalog2HtmlHelper::trimText($item->intro_desc, $params->get('items_intro_length'));?>
                        </div>
                        <div class="djc_price">
							<?php
							if ($prices['display'] != $prices['old_display'] ) {
								if ($params->get('show_old_price', '1') == '1') {
									echo '<span class="djc_price_label">'.JText::_('COM_DJCATALOG2_PRICE').': </span>';
									?><span class="djc_price_old"><?php
									echo DJCatalog2HtmlHelper::formatPrice($prices['old_display'], $params);
									?></span>
                                    <span class="djc_price_new"><?php
									echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params);
									?></span><?php
								} else {
									echo JText::_('COM_DJCATALOG2_PRICE').': ';
									?><span class="djc_price_normal djc_price_new"><?php
									echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params);
									?></span><?php
								}
							} else {
								echo '<span class="djc_price_label">'.JText::_('COM_DJCATALOG2_PRICE').': </span>';
								?><span class="djc_price_normal djc_price_new"><?php
								echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params);
								?></span><?php }

							if ($prices['display2nd'] !== false && $show_tax) {
								echo '<span class="djc_price_without_tax">'.JText::sprintf('COM_DJCATALOG2_PRICE_WITHANDWITHOUT_TAX', DJCatalog2HtmlHelper::formatPrice($prices['display2nd'], $params, false), DJCatalog2HtmlHelper::formatPrice($prices['tax'], $params, false)).'</span>';
							} else if ($show_tax) {
								echo '<span class="djc_price_with_tax">'.JText::sprintf('COM_DJCATALOG2_PRICE_WITH_TAX', DJCatalog2HtmlHelper::formatPrice($prices['tax'], $params, false)).'</span>';
							}
							?>
                        </div>
						<?php
						$layout = new JLayoutFile('com_djcatalog2.addtocart', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
						echo $layout->render(array('item' => $item, 'context' => 'com_djcatalog2.mod_djc2items.addtocart', 'params' => $params));
						?>
                    </div>
                    <div style="clear:both;"></div>
                </div>

            <?php if($i % 4 == 0) : ?>
                </div>
                <?php $row++; ?>
            <?php endif; ?>

            <?php $i = ( ($i + 1) > 4 ) ? 1 : $i +1; ?>

			<?php endforeach; ?>
    </div>
</div>