<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.keepalive');

$user = JFactory::getUser();
?>

<?php if ($this->params->get('cart_enabled', '1') == '1') { ?>
    <div class="djc_checkout_progress djc_clearfix <?php echo (JFactory::getUser()->guest && !($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1')) ? 'steps-3' : 'steps-2' ?>">
        <div class="djc_checkout-step djc_checkout-step-1 active">
            <a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCartRoute()); ?>"><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART'); ?></a>
        </div>
		<?php if (!($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1')) { ?>
            <div class="djc_checkout-step djc_checkout-step-2">
                <span><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_LOGIN'); ?></span>
            </div>
		<?php } ?>
        <div class="djc_checkout-step djc_checkout-step-3">
            <span><?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_CHECKOUT'); ?></span>
        </div>
    </div>
<?php } ?>

<?php //if ($this->params->get( 'show_page_heading', 1)) { ?>
<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx') ?>">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>
<?php //} ?>

<div id="djcatalog"
     class="djc_cart<?php echo $this->params->get('pageclass_sfx') . ' djc_theme_' . $this->params->get('theme', 'default') ?>">

	<?php if (count($this->items) > 0) { ?>
        <div class="djc_cart djc_clearfix">
			<?php echo $this->loadTemplate('table2'); ?>
        </div>
	<?php } else { ?>
        <p class="djc_empty_cart"><?php echo JText::_('COM_DJCATALOG2_CART_IS_EMPTY'); ?></p>
	<?php } ?>

    <div class="djc_cart_actions">
		<?php if (count($this->items) > 0) { ?>
			<?php if ($this->params->get('cart_coupons', 0) && $this->params->get('cart_enabled', 1)) { ?>
				<?php echo $this->loadTemplate('coupon'); ?>
			<?php } ?>
			
			<?php if ($this->params->get('cart_continue_btn')) {?>
			<a 	class="btn djc_continue_shopping_btn" 
				href="<?php echo JRoute::_('index.php?Itemid=' . $this->params->get('cart_continue_btn')); ?>"><?php 
					echo JText::_('COM_DJCATALOG2_CONTINUE_SHOPPING'); 
			?></a>
			<?php } ?>

			<?php if ($this->params->get('cart_query_enabled', '1') == '1') { ?>
                <form action="<?php echo JRoute::_(DJCatalogHelperRoute::getQueryRoute()); ?>" method="post" class="form form-inline djc_cart_proceed djc_cart_proceed_query">
                    <input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_PROCEED_TO_CONTACT_FORM'); ?>"
                           class="btn button btn-success djc_query_btn"/>
                    <input type="hidden" name="option" value="com_djcatalog2"/>
                    <input type="hidden" name="task" value="cart.query"/>
					<?php echo JHtml::_('form.token'); ?>
                </form>
			<?php } ?>

			<?php if ($this->params->get('cart_enabled', '1') == '1') { ?>
                <form action="<?php echo JRoute::_(DJCatalogHelperRoute::getCheckoutRoute()); ?>" method="post"  class="form form-inline djc_cart_proceed djc_cart_proceed_checkout">
                    <input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_CONFIRM_CART'); ?>"
                           class="btn button btn-success djc_checkout_btn"/>
                    <input type="hidden" name="option" value="com_djcatalog2"/>
                    <input type="hidden" name="task" value="cart.checkout"/>
					<?php echo JHtml::_('form.token'); ?>
                </form>
			<?php } ?>
		<?php } ?>
    </div>
    
    <?php 
	$cart_modules = JModuleHelper::getModules('djc2_cart_bottom');
	$output = '';
	if (!empty($cart_modules)) {
		foreach ($cart_modules as $module){
			$output .= JModuleHelper::renderModule($module);
		}
	}
	if ($output) {
		echo '<div class="djc_cart_modules">'.$output.'</div>';
	}
	?>

    <?php if($this->params->get('cart_related_accessories') && !empty($this->related_accessories)) : ?>
		<?php echo $this->loadTemplate('related_accessories'); ?>
    <?php endif; ?>
</div>
