<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

$params = JComponentHelper::getParams('com_djcatalog2');
$show_item_desc = $params->get('wl_pdf_show_description', false, 'bool');

?>
<table width="100%">
    <tr>
        <th width="50%;" align="center"><h1><?php echo JText::_('COM_DJCATALOG2_WISHLIST_ITEM_NAME'); ?></h1></th>
        <th width="50%;" align="center"><h1><?php echo JText::_('COM_DJCATALOG2_WISHLIST_ITEM_IMAGE'); ?></h1></th>
    </tr>

    <?php foreach ($data as $item) : ?>
        <tr nobr="true">
            <td width="50%" align="center">
                <span><?php echo $item->name; ?></span>
            </td>
            <td width="50%" align="center">
                <?php if ((int)$params->get('image_link_item', 0) != -1) { ?>
                    <?php
                    $variant = 'img';
                    $imgLink = (int)$params->get('image_link_item', 0);
                    if ($imgLink == 0) {
                        $variant = 'link';
                    } else if ($imgLink == 1) {
                        $variant = 'popup';
                    } else if ($imgLink == 2) {
                        $variant = 'preview';
                    }
                    $layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
                    $imageData = array(	'item' => &$item,
                        'type' => 'item',
                        'size' => 'medium',
                        'variant' => $variant,
                        'hover_img' => $params->get('image_hover_item', 0) == 1,
                        'context' => 'com_djcatalog2.items.list',
                        'params' => &$params);
                    echo $layout->render($imageData);
                    ?>
                <?php } ?>
            </td>
        </tr>
        <?php if($show_item_desc) : ?>
            <tr>
                <td colspan="2">
                    <?php echo $item->intro_desc; ?>
                </td>
            </tr>
        <?php endif; ?>
    <?php endforeach; ?>
</table>
