<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();
$language = JFactory::getLanguage();
?>
<table width="100%" cellpadding="0" cellspacing="0" class="djc_items_table">
<thead>
	<tr>
		<th>
			<?php echo JText::_('COM_DJCATALOG2_SUBSCRIPTION_NAME'); ?>
		</th>
		<th>
			<?php echo JText::_('COM_DJCATALOG2_START_DATE'); ?>
		</th>
		<th>
			<?php echo JText::_('COM_DJCATALOG2_EXPIRE_DATE'); ?>
		</th>
	</tr>
</thead>
<tbody>
	<?php foreach ($data['subscriptions'] as $sub) { ?>
		<tr>
			<td>
				<?php echo $sub->item_name; ?>
			</td>
			<td>
				<?php echo JHtml::_('date', $sub->start_date, $params->get('date_format_date', 'd/m/Y')); ?>
			</td>
			<td>
				<?php echo JHtml::_('date', $sub->expire_date, $params->get('date_format_date', 'd/m/Y')); ?>
			</td>
		</tr>
	<?php } ?>
	</tbody>
</table>