<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();

$user = JFactory::getUser();
$price_auth = ($params->get('price_restrict', '0') == '1' && $user->guest) ? false : true;
$show_prices = (bool)($price_auth && (int)$params->get('cart_show_prices', 0) == 1);

$language = JFactory::getLanguage();

?>

<table width="100%" cellpadding="0" cellspacing="0" class="djc_items_table">
	<thead>
		<tr>
			<th width="30%"><?php echo JText::_('COM_DJCATALOG2_CART_NAME'); ?>
			</th>
			<th align="center"><?php echo JText::_('COM_DJCATALOG2_QUANTITY'); ?>
			</th>
			<?php if ($show_prices) {?>
			<th align="center"><?php echo JText::_('COM_DJCATALOG2_PRICE'); ?>
			</th>
			<?php } ?>
		</tr>
	</thead>
	<tbody>
		<?php
		$total = 0;
		foreach($data['items'] as $item){
			$total += $item['total'];
		?>
		<tr>
			<td><?php 
			echo ($params->get('cart_display_sku', 1) && $item['sku']) ? '('.$item['sku'].') '.$item['item_name'] : $item['item_name'];
			?>
			</td>
			<td align="center"><?php echo DJCatalog2HelperQuantity::formatAmount($item['quantity'], $params).(isset($item['unit']) ? ' '.$item['unit'] : ''); ?>
			</td>
			<?php if ($show_prices) {?>
			<td align="center"><?php echo $item['total'] > 0.0 ? $item['total'] : '-'; ?></td>
			<?php } ?>
		</tr>
		
		<?php if (!empty(($item['additional_info'])) && trim($item['additional_info']) != '') { ?>
				<?php $additional_info = json_decode($item['additional_info']); ?>
					<?php if ($additional_info) {?>
					<tr>
						<td colspan="<?php echo $show_prices ? 3:2; ?>">
							<?php 
							if ($item['item_type'] == 'item') {
								$attrs = array();
								foreach($additional_info as $label => $value) {
									$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
								} 
								echo implode(' | ', $attrs);
							} else if ($item['item_type'] == 'customisation') {
								$attrs = array();
								foreach ($additional_info as $customisation_info) {
									 $info = '<strong>' . $customisation_info->name.'</strong>: ';
									 if (empty($customisation_info->value)) {
									 	$info .= '---';
									 } else {
									 	if ($customisation_info->type == 'text' || $customisation_info->type == 'textarea' || $customisation_info->type == 'checkbox' || $customisation_info->type == 'radio') {
									 		$info .= nl2br($customisation_info->value);
									 	} else if ($customisation_info->type == 'file') {
									 		$info .= $customisation_info->value->caption;
									 	}
									 }
									 $attrs[] = $info;
								}
								echo implode(' | ', $attrs);
							}
							?>
						</td>
					</tr>
				<?php } ?>
			<?php } ?>
		
		<?php if (trim($item['features_info']) != '' && $item['item_type'] == 'item') { ?>
			<?php $additional_info = json_decode($item['features_info']); ?>
				<?php if ($additional_info) {?>
				<tr>
					<td colspan="<?php echo $show_prices ? 3:2; ?>">
						<?php 
						$attrs = array();
						foreach($additional_info as $label => $value) {
							$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
						} 
						echo implode(' | ', $attrs);
						?>
					</td>
				</tr>
			<?php } ?>
		<?php } ?>
		
		<?php } ?>
		<?php if ($show_prices) {?>
		<tr>
			<td colspan="2" align="right"><?php echo JText::_('COM_DJCATALOG2_TOTAL_VALUE'); ?></td>
			<td align="center"><?php echo $total; ?></td>
		</tr>
		<?php } ?>
	</tbody>
</table>