<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();

$user = JFactory::getUser();
$price_auth = ($params->get('price_restrict', '0') == '1' && $user->guest) ? false : true;
$show_prices = (bool)($price_auth && (int)$params->get('cart_show_prices', 0) == 1);

$language = JFactory::getLanguage();

?>

<table width="100%" cellpadding="0" cellspacing="0" class="djc_details_table">
	<tr>
		<td width="50%"><?php echo JText::_('COM_DJCATALOG2_DATE'); ?>
		</td>
		<td><?php echo JHtml::_('date', $data['created_date'], $params->get('date_format_date', 'd/m/Y')); ?>
		</td>
	</tr>
	<tr>
		<td><?php echo JText::_('COM_DJCATALOG2_USER_PROFILE'); ?>
		</td>
		<td><?php 
		if ($data['company']) { ?><strong><?php echo $data['company']?>
		</strong><br /><?php } ?>
		<?php if (!empty($data['firstname']) || !empty($data['lastname'])) {?>
		<strong><?php echo @$data['firstname'].' '.@$data['lastname']; ?></strong><br /><?php } ?>
		<a href="mailto:<?php echo $data['email']; ?>"><?php echo $data['email']; ?></a><br />
		<?php 
			$addr = array();
			if (!empty($data['address'])) {
				$addr['address'] = $data['address'];
			}
			if (!empty($data['postcode'])) {
				$addr['postcode'] = $data['postcode'];
			}
			if (!empty($data['city'])) {
				$addr['city'] = $data['city'];
			}
			if (!empty($data['country'])) {
				$addr['country'] = $data['country'];
			}
			if (!empty($data['state'])) {
				$addr['state'] = $data['state'];
			}
			if (count($addr) > 0) {
				echo implode(', ', $addr).'<br />';
			}
		?>
		<?php if (!empty($data['phone'])) { echo JText::_('COM_DJCATALOG2_UP_PHONE').': '.$data['phone'].'<br />'; } ?>
		<?php if (!empty($data['fax'])) { echo JText::_('COM_DJCATALOG2_UP_FAX').': '.$data['fax'].'<br />'; } ?>
		<?php if (!empty($data['vat_id'])) { echo JText::_('COM_DJCATALOG2_UP_VATID').': '.$data['vat_id'].'<br />'; } ?>
		
		<?php if (!empty($data['gdpr_policy'])) { 
			$policy_info = JText::sprintf('COM_DJCATALOG2_GDPR_POLICY_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_policy_info')) != '') {
				$policy_info = $params->get('cart_gdpr_policy_info');
				if ($language->hasKey($policy_info)) {
					$policy_info = JText::_($policy_info);
				}
				
			}
			echo '<br />'.$policy_info;
		} ?>
		
		<?php if (!empty($data['gdpr_agreement'])) { 
			$agreement_info = JText::sprintf('COM_DJCATALOG2_GDPR_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_agreement_info')) != '') {
				$agreement_info = $params->get('cart_gdpr_agreement_info');
				if ($language->hasKey($agreement_info)) {
					$agreement_info = JText::_($agreement_info);
				}
			}
			echo '<br />'.$agreement_info;
		} ?>
		</td>
	</tr>
	<?php if ($data['customer_note']) {?>
		<tr>
			<td colspan="2"><?php echo JText::_('COM_DJCATALOG2_MESSAGE'); ?>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo nl2br($data['customer_note']); ?>
			</td>
		</tr>
	<?php } ?>
</table>