<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();
$language = JFactory::getLanguage();

$currency = Djcatalog2HelperPrice::getCurrencyByCode($data['currency']);
if ($currency) {
	$params->set('price_unit', $currency->symbol);
} else {
	$params->set('price_unit', $data['currency']);
}

?>

<table width="100%" cellpadding="0" cellspacing="0" class="djc_items_table">
	<thead>
		<tr>
			<th width="30%"><?php echo JText::_('COM_DJCATALOG2_CART_NAME'); ?>
			</th>
			<th align="center"><?php echo JText::_('COM_DJCATALOG2_QUANTITY'); ?>
			</th>
			<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_NET_VALUE'); ?>
			</th>
			<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_TAX'); ?>
			</th>
			<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_TOTAL_VALUE'); ?>
			</th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="2" align="right"><?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_TOTAL'); ?>
			</td>
			<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['total'], $params)?>
			</td>
			<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['tax'], $params)?>
			</td>
			<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['grand_total'], $params)?>
			</td>
		</tr>
	</tfoot>
	<tbody>
		<?php
		foreach($data['items'] as $item){
		?>
			<tr>
				<td><?php 
				echo ($params->get('cart_display_sku', 1) && $item['sku']) ? '('.$item['sku'].') '.$item['item_name'] : $item['item_name'];
				?>
				</td>
				<td align="center"><?php echo DJCatalog2HelperQuantity::formatAmount($item['quantity'], $params).(isset($item['unit']) ? ' '.$item['unit'] : ''); ?>
				</td>
				<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['cost'], $params, false)?>
				</td>
				<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['tax'], $params, false)?>
				</td>
				<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['total'], $params, false)?>
				</td>
			</tr>
		
			<?php if (!empty(($item['additional_info'])) && trim($item['additional_info']) != '') { ?>
				<?php $additional_info = json_decode($item['additional_info']); ?>
					<?php if ($additional_info) {?>
					<tr>
						<td colspan="5">
							<?php 
							if ($item['item_type'] == 'item') {
								$attrs = array();
								foreach($additional_info as $label => $value) {
									$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
								} 
								echo implode(' | ', $attrs);
							} else if ($item['item_type'] == 'customisation') {
								$attrs = array();
								foreach ($additional_info as $customisation_info) {
									 $info = '<strong>' . $customisation_info->name.'</strong>: ';
									 if (empty($customisation_info->value)) {
									 	$info .= '---';
									 } else {
									 	if ($customisation_info->type == 'text' || $customisation_info->type == 'textarea' || $customisation_info->type == 'checkbox' || $customisation_info->type == 'radio') {
									 		$info .= nl2br($customisation_info->value);
									 	} else if ($customisation_info->type == 'file') {
									 		$info .= $customisation_info->value->caption;
									 	}else {
											$dispatcher = JEventDispatcher::getInstance();
											$results =         $dispatcher->trigger('onProductOrderEmailPrepare', [$item, $customisation_info]);
											$html = '';
											foreach($results as $result) {
												if (trim($result) == '' || empty($result)) continue;
												$html .= $result;
											}
											echo $html;
										}
									 }
									 $attrs[] = $info;
								}
								echo implode(' | ', $attrs);
							}
							?>
						</td>
					</tr>
				<?php } ?>
			<?php } ?>
			
			<?php if (!empty(($item['features_info'])) && trim($item['features_info']) != '' && $item['item_type'] == 'item') { ?>
				<?php $additional_info = json_decode($item['features_info']); ?>
					<?php if ($additional_info) {?>
					<tr>
						<td colspan="5">
							<?php 
								$attrs = array();
								foreach($additional_info as $label => $value) {
									$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
								} 
								echo implode(' | ', $attrs);
							?>
						</td>
					</tr>
				<?php } ?>
			<?php } ?>
		<?php } ?>
		
		<?php if (!empty($data['delivery_method'])) { ?>
			<tr><td colspan="5" class="djc_row_separator"> </td></tr>
            <tr>
                <td><?php 
                echo JText::_('COM_DJCATALOG2_DELIVERY_METHOD').': '.$data['delivery_method'];
                ?>
                </td>
                <td align="center"><?php echo 1; ?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_price'], $params, false)?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_tax'], $params, false)?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_total'], $params, false)?>
                </td>
            </tr>
            <?php if (!empty($data['onEmailAfterDeliveryDisplay'])) { ?>
            	<tr><td colspan="6"><?php echo $data['onEmailAfterDeliveryDisplay']; ?></td></tr>
            <?php } ?>
        <?php } ?>
        
         <?php if (!empty($data['payment_method'])) { ?>
         	<tr><td colspan="5" class="djc_row_separator"> </td></tr>
            <tr>
                <td><?php 
                echo JText::_('COM_DJCATALOG2_PAYMENT_METHOD').': '.$data['payment_method'];
                ?>
                </td>
                <td align="center"><?php echo 1; ?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_price'], $params, false)?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_tax'], $params, false)?>
                </td>
                <td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_total'], $params, false)?>
                </td>
            </tr>
            <?php if (!empty($data['onEmailAfterPaymentDisplay'])) { ?>
            	<tr><td colspan="6"><?php echo $data['onEmailAfterPaymentDisplay']; ?></td></tr>
            <?php } ?>
        <?php } ?>
	</tbody>
</table>