<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();
$language = JFactory::getLanguage();

?>

<table width="100%" cellpadding="0" cellspacing="0" class="djc_details_table">
	<tr>
		<td width="50%"><?php echo JText::_('COM_DJCATALOG2_ORDER_DATE'); ?>
		</td>
		<td><?php echo JHtml::_('date', $data['created_date'], $params->get('date_format_date', 'd/m/Y')); ?>
		</td>
	</tr>
	<tr>
		<td><?php echo JText::_('COM_DJCATALOG2_ORDER_STATUS'); ?>
		</td>
		<td>
		<p><strong><?php echo DJCatalog2HtmlHelper::getOrderStatusName($data['status']); ?></strong></p>
		<?php echo DJCatalog2HtmlHelper::getOrderStatusInfo($data['status'], true); ?>
		</td>
	</tr>
	<tr>
		<td><?php echo JText::_('COM_DJCATALOG2_ORDER_FINAL_PRICE'); ?>
		</td>
		<td><?php echo DJCatalog2HtmlHelper::formatPrice($data['grand_total'], $params); ?>
		</td>
	</tr>
	<tr>
		<td><?php echo JText::_('COM_DJCATALOG2_ORDER_BUYER'); ?>
		</td>
		<td><?php 
		if ($data['company']) { ?><strong><?php echo $data['company']?>
		</strong><br /><?php } ?>
		<strong><?php echo $data['firstname'].' '.$data['lastname']; ?></strong><br />
		<a href="mailto:<?php echo $data['email']; ?>"><?php echo $data['email']; ?></a><br />
		<?php 
			$addr = array();
			if (!empty($data['address'])) {
				$addr['address'] = $data['address'];
			}
			if (!empty($data['postcode'])) {
				$addr['postcode'] = $data['postcode'];
			}
			if (!empty($data['city'])) {
				$addr['city'] = $data['city'];
			}
			if (!empty($data['country'])) {
				$addr['country'] = $data['country'];
			}
			if (!empty($data['state'])) {
				$addr['state'] = $data['state'];
			}
			if (count($addr) > 0) {
				echo implode(', ', $addr).'<br />';
			}
		?>
		<?php if (!empty($data['phone'])) { echo JText::_('COM_DJCATALOG2_UP_PHONE').': '.$data['phone'].'<br />'; } ?>
		<?php if (!empty($data['fax'])) { echo JText::_('COM_DJCATALOG2_UP_FAX').': '.$data['fax'].'<br />'; } ?>
		<?php if (!empty($data['vat_id'])) { echo JText::_('COM_DJCATALOG2_UP_VATID').': '.$data['vat_id'].'<br />'; } ?>
		
		<?php if (!empty($data['gdpr_policy'])) { 
			$policy_info = JText::sprintf('COM_DJCATALOG2_GDPR_POLICY_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_policy_info')) != '') {
				$policy_info = $params->get('cart_gdpr_policy_info');
				if ($language->hasKey($policy_info)) {
					$policy_info = JText::_($policy_info);
				}
			}
			echo '<br />'.$policy_info;
		} ?>
		
		<?php if (!empty($data['gdpr_agreement'])) { 
			$agreement_info = JText::sprintf('COM_DJCATALOG2_GDPR_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_agreement_info')) != '') {
				$agreement_info = $params->get('cart_gdpr_agreement_info');
				if ($language->hasKey($agreement_info)) {
					$agreement_info = JText::_($agreement_info);
				}
			}
			echo '<br />'.$agreement_info;
		} ?>
		
		<?php if (isset($data['want_invoice'])) { 
			echo '<br />'.JText::_('COM_DJCATALOG2_UP_WANT_INVOICE').': ' 
			. (( (int)$data['want_invoice'] > 0) ? JText::_('JYES') : JText::_('JNO'));
		} ?>
		
		
		<?php if (isset($data['additional_user_data']) && $data['additional_user_data'] != '') {
			$additional = json_decode($data['additional_user_data'], true);
			$info = [];
			if (count($additional)) {
				foreach($additional as $section) {
					foreach($section as $field) {
						$info[] = $field['field'].': <strong>' . ($field['value_text'] ? $field['value_text'] : '-') . '</strong>';
					}
				}
			}
			if (count($info)) {
				echo '<br />'.implode('<br />', $info);
			}
		}?>
		
		</td>
	</tr>
	
	<?php //if (!empty($data['delivery_method'])) { ?>
	<?php if (isset($data['delivery_to_billing']) && $data['delivery_to_billing'] == 0) { ?>
			<tr><td colspan="2" class="djc_row_separator"> </td></tr>
			
	        <tr>
	            <td><?php echo JText::_('COM_DJCATALOG2_DELIVERY_DETAILS'); ?></td>
	            <td><?php 
			if ($data['delivery_company']) { ?><strong><?php echo $data['delivery_company']?>
			</strong><br /><?php } ?>
			<strong><?php echo $data['delivery_firstname'].' '.$data['delivery_lastname']; ?></strong><br />
			<a href="mailto:<?php echo $data['email']; ?>"><?php echo $data['email']; ?></a><br />
			<?php 
				$addr = array();
				if (!empty($data['delivery_address'])) {
					$addr['delivery_address'] = $data['delivery_address'];
				}
				if (!empty($data['delivery_postcode'])) {
					$addr['delivery_postcode'] = $data['delivery_postcode'];
				}
				if (!empty($data['delivery_city'])) {
					$addr['delivery_city'] = $data['delivery_city'];
				}
				if (!empty($data['delivery_country'])) {
					$addr['delivery_country'] = $data['delivery_country'];
				}
				if (!empty($data['delivery_state'])) {
					$addr['delivery_state'] = $data['delivery_state'];
				}
				if (count($addr) > 0) {
					echo implode(', ', $addr).'<br />';
				}
			?>
			<?php if (!empty($data['delivery_phone'])) { echo JText::_('COM_DJCATALOG2_UP_PHONE').': '.$data['delivery_phone'].'<br />'; } ?>
			</td>
		</tr>
	
	<?php } ?>
	
	<?php if ($data['customer_note']) {?>
		<tr><td colspan="2" class="djc_row_separator"> </td></tr>
		
		<tr>
			<td colspan="2"><?php echo JText::_('COM_DJCATALOG2_MESSAGE'); ?>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo nl2br($data['customer_note']); ?>
			</td>
		</tr>
	<?php } ?>
	</table>