<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();
$language = JFactory::getLanguage();

?>
<table width="100%" cellpadding="0" cellspacing="0" class="djc_items_table">
	<thead>
		<tr>
			<th width="50%"><?php echo JText::_('COM_DJCATALOG2_NAME'); ?>
			</th>
			<th align="center"><?php echo JText::_('COM_DJCATALOG2_QUANTITY'); ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		foreach($data['items'] as $item){
			$link = JRoute::_(DJCatalog2HelperRoute::getItemRoute($item->id.':'.$item->alias, $item->cat_id.':'.$item->category_alias), true, (JUri::getInstance()->isSsl() ? 1 :-1));
		?>
			<tr>
				<td>
				<a href="<?php echo $link; ?>"><?php echo $item->name; ?></a>
				</td>
				<td><?php echo (isset($data['quantities'][$item->id])) ? $data['quantities'][$item->id] : '---'; ?></td>
			</tr>
		
		<?php } ?>

	</tbody>
</table>