<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

$params = JComponentHelper::getParams('com_djcatalog2');
$app = JFactory::getApplication();

$language = JFactory::getLanguage();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8">
	</head>
	<body>
		<div class="djc_mail_wrap">
		<?php if (($logo = $params->get('cart_company_logo', '')) != '') { ?>
			<div class="djc_company_logo">
				<img alt="logo" src="<?php echo JUri::root(false).$logo; ?>" />
			</div>
		<?php } ?>
		<?php if (($header = $params->get('cart_email_header', '')) != '') {?>
			<div class="djc_header"><?php echo $header; ?></div>
		<?php } ?>
		
		<h1 class="djc_heading">
			<?php echo JText::_('COM_DJCATALOG2_ORDER_NUMBER').' '.str_pad($data['order_number'], 5, '0', STR_PAD_LEFT); ?>
		</h1>
		
		<p class="djc_intro_text">
		<?php echo JText::_('COM_DJCATALOG2_EMAIL_ORDER_ADMIN_HEADER'); ?>
		</p>
		
		<br />
		<table width="100%" cellpadding="0" cellspacing="0" class="djc_details_table">
			<tr>
				<td width="50%"><?php echo JText::_('COM_DJCATALOG2_ORDER_DATE'); ?>
				</td>
				<td><?php echo JHtml::_('date', $data['created_date'], $params->get('date_format_date', 'd/m/Y')); ?>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_DJCATALOG2_ORDER_STATUS'); ?>
				</td>
				<td><p><strong><?php echo DJCatalog2HtmlHelper::getOrderStatusName($data['status']); ?></strong></p></td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_DJCATALOG2_ORDER_FINAL_PRICE'); ?>
				</td>
				<td><?php echo DJCatalog2HtmlHelper::formatPrice($data['grand_total'], $params); ?>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_DJCATALOG2_ORDER_BUYER'); ?>
				</td>
				<td><?php 
				if ($data['company']) { ?><strong><?php echo $data['company']?>
				</strong><br /><?php } ?>
				<strong><?php echo $data['firstname'].' '.$data['lastname']; ?></strong><br />
				<a href="mailto:<?php echo $data['email']; ?>"><?php echo $data['email']; ?></a><br />
				<?php 
					$addr = array();
					if (!empty($data['address'])) {
						$addr['address'] = $data['address'];
					}
					if (!empty($data['postcode'])) {
						$addr['postcode'] = $data['postcode'];
					}
					if (!empty($data['city'])) {
						$addr['city'] = $data['city'];
					}
					if (!empty($data['country'])) {
						$addr['country'] = $data['country'];
					}
					if (!empty($data['state'])) {
						$addr['state'] = $data['state'];
					}
					if (count($addr) > 0) {
						echo implode(', ', $addr).'<br />';
					}
				?>
				<?php if (!empty($data['phone'])) { echo JText::_('COM_DJCATALOG2_UP_PHONE').': '.$data['phone'].'<br />'; } ?>
				<?php if (!empty($data['fax'])) { echo JText::_('COM_DJCATALOG2_UP_FAX').': '.$data['fax'].'<br />'; } ?>
				<?php if (!empty($data['vat_id'])) { echo JText::_('COM_DJCATALOG2_UP_VATID').': '.$data['vat_id'].'<br />'; } ?>
				
				<?php if (!empty($data['gdpr_policy'])) { 
					$policy_info = JText::sprintf('COM_DJCATALOG2_GDPR_POLICY_AGREE', $app->get('sitename'));
					if (trim($params->get('cart_gdpr_policy_info')) != '') {
						$policy_info = $params->get('cart_gdpr_policy_info');
						if ($language->hasKey($policy_info)) {
							$policy_info = JText::_($policy_info);
						}
					}
					echo '<br />'.$policy_info;
				} ?>
				
				<?php if (!empty($data['gdpr_agreement'])) { 
					$agreement_info = JText::sprintf('COM_DJCATALOG2_GDPR_AGREE', $app->get('sitename'));
					if (trim($params->get('cart_gdpr_agreement_info')) != '') {
						$agreement_info = $params->get('cart_gdpr_agreement_info');
						if ($language->hasKey($agreement_info)) {
							$agreement_info = JText::_($agreement_info);
						}
					}
					echo '<br />'.$agreement_info;
				} ?>
				
				<?php if (isset($data['additional_user_data']) && $data['additional_user_data'] != '') {
					$additional = json_decode($data['additional_user_data'], true);
					$info = [];
					if (count($additional)) {
						foreach($additional as $section) {
							foreach($section as $field) {
								$info[] = $field['field'].': <strong>' . ($field['value_text'] ? $field['value_text'] : '-') . '</strong>';
							}
						}
					}
					if (count($info)) {
						echo '<br />'.implode('<br />', $info);
					}
				}?>
				</td>
			</tr>
			
			<?php //if (!empty($data['delivery_method'])) { ?>
			<?php if (isset($data['delivery_to_billing']) && $data['delivery_to_billing'] == 0) { ?>
				<tr><td colspan="2" class="djc_row_separator"> </td></tr>
				
				<tr>
					<td><?php echo JText::_('COM_DJCATALOG2_DELIVERY_DETAILS'); ?></td>
					<td><?php 
					if ($data['delivery_company']) { ?><strong><?php echo $data['delivery_company']?>
					</strong><br /><?php } ?>
					<strong><?php echo $data['delivery_firstname'].' '.$data['delivery_lastname']; ?></strong><br />
					<a href="mailto:<?php echo $data['email']; ?>"><?php echo $data['email']; ?></a><br />
					<?php 
						$addr = array();
						if (!empty($data['delivery_address'])) {
							$addr['delivery_address'] = $data['delivery_address'];
						}
						if (!empty($data['delivery_postcode'])) {
							$addr['delivery_postcode'] = $data['delivery_postcode'];
						}
						if (!empty($data['delivery_city'])) {
							$addr['delivery_city'] = $data['delivery_city'];
						}
						if (!empty($data['delivery_country'])) {
							$addr['delivery_country'] = $data['delivery_country'];
						}
						if (!empty($data['delivery_state'])) {
							$addr['delivery_state'] = $data['delivery_state'];
						}
						if (count($addr) > 0) {
							echo implode(', ', $addr).'<br />';
						}
					?>
					<?php if (!empty($data['delivery_phone'])) { echo JText::_('COM_DJCATALOG2_UP_PHONE').': '.$data['delivery_phone'].'<br />'; } ?>
					</td>
				</tr>
		
			<?php } ?>
			
			<?php if ($data['customer_note']) {?>
				<tr><td colspan="2" class="djc_row_separator"> </td></tr>
				
				<tr>
					<td colspan="2"><?php echo JText::_('COM_DJCATALOG2_MESSAGE'); ?>
					</td>
				</tr>
				<tr>
					<td colspan="2"><?php echo nl2br($data['customer_note']); ?>
					</td>
				</tr>
			<?php } ?>
		</table>
		<br /><br />
		<table width="100%" cellpadding="0" cellspacing="0" class="djc_items_table">
			<thead>
				<tr>
					<th width="30%"><?php echo JText::_('COM_DJCATALOG2_CART_NAME'); ?>
					</th>
					<th align="center"><?php echo JText::_('COM_DJCATALOG2_QUANTITY'); ?>
					</th>
					<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_NET_VALUE'); ?>
					</th>
					<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_TAX'); ?>
					</th>
					<th width="15%" align="center"><?php echo JText::_('COM_DJCATALOG2_TOTAL_VALUE'); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="2" align="right"><?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_TOTAL'); ?>
					</td>
					<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['total'], $params)?>
					</td>
					<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['tax'], $params)?>
					</td>
					<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['grand_total'], $params)?>
					</td>
				</tr>
			</tfoot>
			<tbody>
				<?php
				foreach($data['items'] as $item){
				?>
					<tr>
						<td><?php 
						echo ($params->get('cart_display_sku', 1) && $item['sku']) ? '('.$item['sku'].') '.$item['item_name'] : $item['item_name'];
						?>
						</td>
						<td align="center"><?php echo DJCatalog2HelperQuantity::formatAmount($item['quantity'], $params).(isset($item['unit']) ? ' '.$item['unit'] : ''); ?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['cost'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['tax'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($item['total'], $params, false)?>
						</td>
					</tr>
					<?php if (!empty(($item['additional_info'])) && trim($item['additional_info']) != '') { ?>
						<?php $additional_info = json_decode($item['additional_info']); ?>
							<?php if ($additional_info) {?>
							<tr>
								<td colspan="5">
									<?php 
									if ($item['item_type'] == 'item') {
										$attrs = array();
										foreach($additional_info as $label => $value) {
											$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
										} 
										echo implode(' | ', $attrs);
									} else if ($item['item_type'] == 'customisation') {
										$attrs = array();
										foreach ($additional_info as $customisation_info) {
											 $info = '<strong>' . $customisation_info->name.'</strong>';
											 if (empty($customisation_info->value)) {
											 	$info .= '---';
											 } else {
											 	if ($customisation_info->type == 'text' || $customisation_info->type == 'textarea' || $customisation_info->type == 'checkbox' || $customisation_info->type == 'radio') {
											 		$info .= nl2br($customisation_info->value);
											 	} else if ($customisation_info->type == 'file') {
											 		$info .= $customisation_info->value->caption;
											 	}
											 }
											 $attrs[] = $info;
										}
										echo implode(' | ', $attrs);
									}
									?>
								</td>
							</tr>
						<?php } ?>
					<?php } ?>
					<?php if (!empty(($item['features_info'])) && trim($item['features_info']) != '' && $item['item_type'] == 'item') { ?>
						<?php $additional_info = json_decode($item['features_info']); ?>
							<?php if ($additional_info) {?>
							<tr>
								<td colspan="5">
									<?php 
										$attrs = array();
										foreach($additional_info as $label => $value) {
											$attrs[] = '<strong>'.$label.'</strong>: <span>'.($value ? $value : '---').'</span>';
										} 
										echo implode(' | ', $attrs);
									?>
								</td>
							</tr>
						<?php } ?>
					<?php } ?>
				<?php } ?>
				
				<?php if (!empty($data['delivery_method'])) { ?>
					<tr><td colspan="5" class="djc_row_separator"> </td></tr>
					<tr>
						<td><?php 
						echo JText::_('COM_DJCATALOG2_DELIVERY_METHOD').': '.$data['delivery_method'];
						?>
						</td>
						<td align="center"><?php echo 1; ?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_price'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_tax'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['delivery_total'], $params, false)?>
						</td>
					</tr>
					<?php if (!empty($data['onEmailAfterDeliveryDisplay'])) { ?>
						<tr><td colspan="6"><?php echo $data['onEmailAfterDeliveryDisplay']; ?></td></tr>
					<?php } ?>
				<?php } ?>
				
				 <?php if (!empty($data['payment_method'])) { ?>
				 	<tr><td colspan="5" class="djc_row_separator"> </td></tr>
					<tr>
						<td><?php 
						echo JText::_('COM_DJCATALOG2_PAYMENT_METHOD').': '.$data['payment_method'];
						?>
						</td>
						<td align="center"><?php echo 1; ?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_price'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_tax'], $params, false)?>
						</td>
						<td align="center"><?php echo DJCatalog2HtmlHelper::formatPrice($data['payment_total'], $params, false)?>
						</td>
					</tr>
					<?php if (!empty($data['onEmailAfterPaymentDisplay'])) { ?>
						<tr><td colspan="6"><?php echo $data['onEmailAfterPaymentDisplay']; ?></td></tr>
					<?php } ?>
				<?php } ?>
			</tbody>
		</table>
		<br />

		<p>
		<?php echo JText::_('COM_DJCATALOG2_EMAIL_ORDER_ADMIN_FOOTER'); ?>
		<a href="<?php echo JURI::base().'administrator/index.php?option=com_djcatalog2&amp;view=orders&amp;filter_search='.urlencode('id:'.$data['id']); ?>">
		<?php echo JText::_('COM_DJCATALOG2_EMAIL_ORDER_ADMIN_LINK');?></a>
		</p>
		<?php if (($footer = $params->get('cart_email_footer', '')) != '') { ?>
			<div class="djc_footer"><?php echo $footer; ?></div>
		<?php } ?>
		</div>
	</body>
</html>