<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

//Joomla\CMS\HTML\HTMLHelper::_('behavior.framework');

$app = JFactory::getApplication();
$user = JFactory::getUser();
$params = DJCatalog2Helper::getParams();

?>

<?php if($user->guest) : ?>
	<div class="djc_wishlist__message"><?php echo JText::_('COM_DJCATALOG2_WISHILST_VIEW_NOT_LOGGED'); ?></div>
<?php endif; ?>

<?php if ($this->params->get('show_page_heading', 1)) { ?>
	<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx') ?>">
		<?php echo $this->escape($this->params->get('page_heading')); ?>
	</h1>
<?php } ?>

<div id="djcatalog" class="djc_wishlist<?php echo $this->params->get('pageclass_sfx').' djc_theme_'.$this->params->get('theme', 'default') ?>">

	<?php if (!count($this->items)) { ?>
		<p class="djc_wishlist--empty"><?php echo JText::_('COM_DJCATALOG2_WISHLIST_EMPTY') ?></p>
	<?php } else { ?>
		<div class="djc_toolbar">
			<div class="djc_toolbar_set">
				<?php if($params->get('wishlist_print_button')) : ?>
					<a href="javascript:window.print()"  class="btn btn-primary_toolbar">
						<img src="components/com_djcatalog2/themes/catalog2k21/images/print.svg">
					</a>
				<?php endif; ?>

				<?php if($params->get('wishlist_pdf_button') ) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=wish.pdf'); ?>"  class="btn btn-primary_toolbar">
						<img src="components/com_djcatalog2/themes/catalog2k21/images/pdf.svg">
					</a>
				<?php endif; ?>
			</div>
		</div>

		<div class="djc_wishlist__grid">
			<?php foreach ($this->items as $i => $item) { ?>
				<?php $item->_link = DJCatalogHelperRoute::getItemRoute($item->slug, $item->cat_slug) ; ?>
				<div class="djc_wishlist__item">
					<a href="<?php echo $item->_link; ?>">
						<?php if ((int)$params->get('image_link_item', 0) != -1) { ?>
							<?php
							$variant = 'img';
							$imgLink = (int)$this->params->get('image_link_item', 0);
							if ($imgLink == 0) {
								$variant = 'link';
							} else if ($imgLink == 1) {
								$variant = 'popup';
							} else if ($imgLink == 2) {
								$variant = 'preview';
							}
							$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
							$imageData = array(	'item' => &$item,
								'type' => 'item',
								'size' => 'small',
								'variant' => $variant,
								'hover_img' => $params->get('image_hover_item', 0) == 1,
								'context' => 'com_djcatalog2.items.list',
								'params' => &$params);
							echo $layout->render($imageData);
							?>
						<?php } ?>
					</a>
					<div class="djc_wishlist__title">
						<h3>
							<a href="<?php echo JRoute::_($item->_link); ?>"><?php echo $this->escape($item->name); ?></a>
						</h3>
					</div>

					<?php /* ?>
					<div class="djc_wishlist__category">
					</div>

					<div class="djc_wishlist__price">
					</div>
					<?php */ ?>
				</div>
			<?php } ?>
	<?php } ?>
</div>
