<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$app = JFactory::getApplication();
$filter_modules = JModuleHelper::getModules('djc2_producerfilters');

$this->filter_modules = '';

if (!empty($filter_modules)) {
	foreach ($filter_modules as $module){
		$this->filter_modules .= JModuleHelper::renderModule($module);
	}
}

?>
<?php if ($this->params->get( 'show_page_heading', 1) && $this->params->get('page_heading')) : ?>
<h1 class="componentheading<?php echo $this->params->get( 'pageclass_sfx' ) ?>"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
<?php endif; ?>

<div id="djcatalog" class="djc_producers_list djc_list<?php echo $this->params->get( 'pageclass_sfx' ).' djc_theme_'.$this->params->get('theme','default') ?>">


<?php /* WARNING - do not remove nor duplicate .djc_subcategories_set container */ ?>
<div class="djc_subcategories_set">
<?php if ($this->params->get('producers_showsubcategories', true) && $this->subcategories && JFactory::getApplication()->input->get('filtering', false) === false) { ?>
<div class="djc_subcategories">
	<?php if ($this->params->get('producers_showsubcategories_label')) { ?>
		<h2 class="djc_title"><?php echo JText::_('COM_DJCATALOG2_PRODUCER_SUBCATEGORIES'); ?></h2>
	<?php } ?>
	<div class="djc_subcategories__grid djc_subcategories__grid--producers">
		<?php echo $this->loadTemplate('subcategories'); ?>
	</div>
</div>
<?php } ?>
</div>

<?php /* WARNING - do not remove nor duplicate .djc_filters_set container */ ?>
<div class="djc_filters_set">
<?php
$toggleAdvFilters = false;
?>
<?php if ( (count($this->items) > 0 || JFactory::getApplication()->input->get('filtering', false))
	&& ($this->params->get('producers_show_category_filter') > 0
		|| $this->params->get('producers_show_search') > 0) ) { ?>
	<div class="djc_filters" id="tlb">
		<?php echo $this->loadTemplate('filters'); ?>
		<?php $toggleAdvFilters = true; ?>
	</div>
<?php } ?>

<?php
if (!empty($this->filter_modules)) {?>
	<div id="djc_additional_filters" class="djc_additional_filters djc_clearfix">
		<div class="djc_additional_filters_in thumbnail">
		<?php echo $this->filter_modules; ?>
		<?php if ($toggleAdvFilters) {?>
		<p class="djc_adv_search_wrap">
			<span class="djc_adv_search_toggle"><?php echo JText::_('COM_DJCATALOG2_ADVANCED_SEARCH_CLOSE'); ?> <span class="icon-uparrow"></span></span>
		</p>
		<?php } ?>
		</div>
	</div>
<?php } ?>
</div>

<?php /* WARNING - do not remove nor duplicate .djc_order_set container */ ?>
<div class="djc_toolbar">
	<div class="djc_order_set">
	<?php
	if ((count($this->items) > 0 || JFactory::getApplication()->input->get('filtering', false) )&& (
			$this->params->get('producers_show_category_orderby') > 0
			|| $this->params->get('producers_show_name_orderby') > 0
			|| count($this->sortables) > 0)) { ?>
	<?php echo $this->loadTemplate('order'); ?>
	<?php } ?>
</div>
</div>

<?php
$onDJC2BeforeItemsList = Joomla\CMS\Factory::getApplication()->triggerEvent('onDJC2BeforeItemsList', array (&$this->items, &$this->params));
if ($onDJC2BeforeItemsList) { ?>
<div class="djc_clearfix djc_pre_list">
	<?php echo trim(implode("\n", $onDJC2BeforeItemsList)); ?>
</div>
<?php } ?>

<?php /* WARNING - do not remove nor duplicate .djc_result_set container */ ?>
<div class="djc_result_set">
	<?php if (count($this->items) > 0){ ?>
		<div class="djc_producers__grid djc_items">
			<?php echo $this->loadTemplate('items'); ?>
		</div>
	<?php } ?>
</div>

<?php
$onDJC2AfterItemsList = Joomla\CMS\Factory::getApplication()->triggerEvent('onDJC2AfterItemsList', array (&$this->items, &$this->params));
if ($onDJC2AfterItemsList) { ?>
<div class="djc_clearfix djc_post_list">
	<?php echo trim(implode("\n", $onDJC2AfterItemsList)); ?>
</div>
<?php } ?>

<?php /* WARNING - do not remove nor duplicate .djc_pagination_set container */ ?>
<div class="djc_pagination_set">
	<?php if ($this->pagination->total > 0 && $this->pagination->total > $this->pagination->limit) { ?>
	<div class="djc_pagination pagination djc_clearfix">
	<?php
		echo $this->pagination->getPagesLinks();
	?>
	</div>
	<?php } ?>
</div>

<?php if ( in_array('producers', $this->params->get('social_code_views',array())) && $this->params->get('social_code_position','top') == 'bottom' && $this->params->get('social_code', '') != '') { ?>
	<div class="djc_clearfix djc_social_b">
		<?php echo $this->params->get('social_code'); ?>
	</div>
<?php } ?>

<?php
	if ($this->params->get('show_footer')) echo DJCATFOOTER;
?>
</div>
