<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();

$statuses = [
	'A' => 'pending',
	'N' => 'pending',
	'R' => 'error',
	'W' => 'error',
	'F' => 'success',
	'C' => 'success',
	'P' => 'success'
];

?>
<table width="100%" cellpadding="0" cellspacing="0" class="djc_orders_table" id="djc_orders_table">
	<thead>
		<tr class="djc_orders_table__tr">
			<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2') && (isset($this->showCheckAll) && $this->showCheckAll)) : ?>
				<th class="djc_orders_table__th djc_orders_table__th--phone"width="1%" class="hidden-phone">
					<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
				</th>
			<?php endif; ?>

			<th class="djc_orders_table__th djc_orders_table__th--order_number">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_NUMBER'); ?>
			</th>
			<th class="djc_orders_table__th djc_orders_table__th--order_date">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_DATE'); ?>
			</th>
			<th class="djc_orders_table__th djc_orders_table__th--order_status">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_STATUS'); ?>
			</th>
			<th class="djc_orders_table__th djc_orders_table__th--total_price">
				<?php echo JText::_('COM_DJCATALOG2_ORDER_FINAL_PRICE'); ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		$k = 1;
		foreach($this->items as $item) {
			$k = 1 - $k;
			$order_url = JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id));
		?>
			<tr class="djc_orders_table__tr djc_orders_table--<?php echo $k;?>">
				<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2') && (isset($this->showCheckAll) && $this->showCheckAll)) : ?>
					<td class="djc_orders_table__td">
						<?php echo Joomla\CMS\HTML\HTMLHelper::_('grid.id',$k, $item->id); ?>
					</td>
				<?php endif; ?>
				<td class="djc_orders_table__td">
					<span class="djc_orders_table__order_number">
						<a href="<?php echo $order_url;?>"><?php echo str_pad($item->order_number, 5, '0', STR_PAD_LEFT); ?></a>
					</span>
					<?php
					$invoice = false;
					if (!empty($item->invoice_number) && $this->params->get('cart_invoices', false)) {
						$invoice = true;
					}
					if ($invoice) {?>
						<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id).'&task=getInvoice'); ?>" class="btn btn--mini"><?php echo JText::_('COM_DJCATALOG2_GET_INVOICE'); ?></a>
					<?php } ?>
					<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getOrderRoute($item->id).'&task=cart.reorder'); ?>" class="btn btn--mini"><?php echo JText::_('COM_DJCATALOG2_REORDER'); ?></a>
				</td>
				<td class="djc_orders_table__td djc_orders_table__order_date">
					<a href="<?php echo $order_url;?>"><?php echo Joomla\CMS\HTML\HTMLHelper::_('date', $item->created_date, $this->params->get('date_format_date', JText::_('DATE_FORMAT_LC3'))); ?></a>
				</td>
				
				<?php $statusClass = (isset($statuses[$item->status])) ? $statuses[$item->status] : 'none'; ?>
				<td class="djc_orders_table__td djc_orders_table__order_status">
					<span class="djc_status djc_status--success"><?php 
						echo DJCatalog2HtmlHelper::getOrderStatusName($item->status);
					?></span>
				</td>
				<td class="djc_orders_table__td djc_orders_table__total_price">
					<?php echo DJCatalog2HtmlHelper::formatPrice($item->grand_total, $this->params); ?>
				</td>
			</tr>
		<?php } ?>
	</tbody>
</table>
