<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
?>

<h1 class="djc_page_heading componentheading <?php echo $this->params->get('pageclass_sfx') ?>">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>

<div id="djcatalog" class="djc_list<?php echo $this->params->get('pageclass_sfx') . ' djc_theme_' . $this->params->get('theme', 'default') ?>">

	<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2')) : ?>
        <form action="<?php echo JRoute::_('index.php?option=com_djcatalog2');?>" method="post" name="adminForm" id="adminForm">
		    <?php echo $this->getToolbar(['export' => ['icon' => 'chevron-right']]); ?>
    <?php endif; ?>

	<?php if (count($this->items) > 0) { ?>
        <?php echo $this->loadTemplate('table'); ?>
	<?php } else { ?>
        <p class="djc_empty_orders"><?php echo JText::_('COM_DJCATALOG2_ORDER_LIST_IS_EMPTY'); ?></p>
	<?php } ?>

	<?php if ($this->pagination->total > 0) { ?>
        <div class="djc_pagination pagination djc_clearfix">
			<?php echo $this->pagination->getPagesLinks(); ?>
        </div>
	<?php } ?>

	<?php if (in_array('producers', $this->params->get('social_code_views', array())) && $this->params->get('social_code_position', 'top') == 'bottom' && $this->params->get('social_code', '') != '') { ?>
        <div class="djc_clearfix djc_social_b">
			<?php echo $this->params->get('social_code'); ?>
        </div>
	<?php } ?>

	<?php if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2')) : ?>
			<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
            <input type="hidden" name="task" value=""/>
            <input type="hidden" name="boxchecked" value="0"/>
        </form>
	<?php endif; ?>

	<?php if ($this->params->get('show_footer')) echo DJCATFOOTER; ?>
</div>
