<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

foreach($this->subcategories as $item) {
	$subcategory = $this->categories->get($item->id);

	$subcategory->_link = DJCatalogHelperRoute::getCategoryRoute($subcategory->id.':'.$subcategory->alias);
?>

	<div class="djc_subcategories__item">
	    <?php if ((int)$this->params->get('image_link_subcategory', 0) != -1) { ?>
	        <?php
	        $variant = 'img';
	        $imgLink = (int)$this->params->get('image_link_subcategory', 0);
	        if ($imgLink == 0) {
	            $variant = 'link';
	        } else if ($imgLink == 1) {
	            $variant = 'popup';
	        }
	        $layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
	        $imageData = array(	'item' => &$subcategory,
	                            'type' => 'category',
	                            'size' => 'medium',
	                            'variant' => $variant,
	                            'hover_img' => false,
	                            'context' => 'com_djcatalog2.subcategories.list',
	                            'params' => &$this->params);
	        echo $layout->render($imageData);
	        ?>
	    <?php } ?>

	    <h3 class="djc_subcategories__item__title">
	        <a href="<?php echo JRoute::_($subcategory->_link);?>">
	            <?php echo $subcategory->name; ?>
	        </a>
	    </h3>

	    <?php if ($this->params->get('category_show_intro') && \Joomla\String\StringHelper::strlen(trim($subcategory->description)) > 0) {?>
	    <div class="djc_subcategories__item__description">
	        <?php if ($this->params->get('category_intro_length') > 0 && $this->params->get('category_intro_trunc') == '1') {
	                ?><?php echo DJCatalog2HtmlHelper::trimText($subcategory->description, $this->params->get('category_intro_length'));?><?php
	            }
	            else {
	                echo $subcategory->description;
	            }
	        ?>
	    </div>
	    <?php } ?>

	    <?php if ((int)$this->params->get('subcategory_showchildren', 0) == 1) { ?>
	        <?php
	            $sub_category_obj = $this->categories->get($item->id);
	                if (!empty($sub_category_obj)) {
	                    $children = $sub_category_obj->getChildren();
	                    $children_count = count($children);
	                    if ($children_count > 0) { ?>
	                        <ul class="djc_subcategories__children">
	                            <?php foreach ($children as $child) { ?>
	                                <li class="djc_subcategories__children__item">
	                                    <a href="<?php echo JRoute::_(DJCatalogHelperRoute::getCategoryRoute($child->id.':'.$child->alias)); ?>">
	                                        <?php echo $child->name; ?>
	                                        <?php echo (isset($child->item_count)) ? '('.(int)$child->item_count.')' : ''; ?>
	                                    </a>
	                                </li>
	                            <?php } ?>
	                        </ul>
	            <?php } ?>
	        <?php } ?>
	    <?php } ?>
	    <?php if ($this->params->get('showreadmore_subcategory')) { ?>
	    <a class="btn btn-secondary btn--full_width" href="<?php echo JRoute::_(DJCatalogHelperRoute::getCategoryRoute($subcategory->id.':'.$subcategory->alias)); ?>"><?php echo JText::_('COM_DJCATALOG2_BROWSE'); ?></a>
	    <?php } ?>
	</div>

<?php } ?>
