<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
?>
<?php

JURI::reset();

//

$app = JFactory::getApplication();
$menu = $app->getMenu();

$active = $app->input->get('ind','', 'string');

$juri = JURI::getInstance();
$uri = JURI::getInstance($juri->toString());
$query = $uri->getQuery(true);

$query['option'] = 'com_djcatalog2';
$query['view'] = 'items';
$query['Itemid'] = $menu->getActive() ? $menu->getActive()->id : null;
$cid = $app->input->get('cid', false, 'string');
$pid = $app->input->get('pid', false, 'string');

if ($cid) {
	$query['cid'] = $cid;
}
if ($pid) {
	$query['pid'] = $pid;
}

unset($query['order']);
unset($query['dir']);

$uri->setQuery($query);
$orderUrl = 'index.php?'.$uri->getQuery(false);

JURI::reset();

$user		= JFactory::getUser();
$price_auth = ($this->params->get('price_restrict', '0') == '1' && $user->guest) ? false : true;

$options = [
	['text' => JText::_('COM_DJCATALOG2_SORT_DEFAULT'), 'value' => '', 'param' => false],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_NAME_ASC'), 'value' => '&order=i.name&dir=asc', 'param' => 'show_name_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_NAME_DESC'), 'value' => '&order=i.name&dir=desc', 'param' => 'show_name_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_CATEGORY_ASC'), 'value' => '&order=category&dir=asc', 'param' => 'show_category_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_CATEGORY_DESC'), 'value' => '&order=category&dir=desc', 'param' => 'show_category_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_PRODUCER_ASC'), 'value' => '&order=producer&dir=asc', 'param' => 'show_producer_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_PRODUCER_DESC'), 'value' => '&order=producer&dir=desc', 'param' => 'show_producer_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_PRICE_ASC'), 'value' => '&order=i.price&dir=asc', 'param' => 'show_price_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_PRICE_DESC'), 'value' => '&order=i.price&dir=desc', 'param' => 'show_price_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_DATE_ASC'), 'value' => '&order=i.created&dir=asc', 'param' => 'show_date_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_DATE_DESC'), 'value' => '&order=i.created&dir=desc', 'param' => 'show_date_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_MOD_DATE_ASC'), 'value' => '&order=i.modified&dir=asc', 'param' => 'show_modify_date_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_MOD_DATE_DESC'), 'value' => '&order=i.modified&dir=desc', 'param' => 'show_modify_date_orderby'],
	
	['text' => JText::_('COM_DJCATALOG2_SORT_HITS_ASC'), 'value' => '&order=i.hits&dir=asc', 'param' => 'show_hits_orderby'],
	['text' => JText::_('COM_DJCATALOG2_SORT_HITS_DESC'), 'value' => '&order=i.hits&dir=desc', 'param' => 'show_hits_orderby'],
];

if (count($this->sortables) > 0) {
	foreach ($this->sortables as $sortable) {
		$options[] = ['text' => $sortable->name.' '. JText::_('COM_DJCATALOG2_SORT_ASC'), 'value' => '&order=f_'.$sortable->alias.'&dir=asc', 'param' => false];
		$options[] = ['text' => $sortable->name.' '. JText::_('COM_DJCATALOG2_SORT_DESC'), 'value' => '&order=f_'.$sortable->alias.'&dir=desc', 'param' => false];
	}
}

?>

<?php $currentOption = '&order=' . $app->input->getCmd('order').'&dir='.$app->input->getCmd('dir');?>
<label for="djc_order_by"><?php echo JText::_('COM_DJCATALOG2_ORDERBY'); ?></label>
<select name="" id="djc_order_by" class="djc_order_by" onchange="window.location.href = this.options[this.selectedIndex].getAttribute('data-url'); ">
	<?php foreach($options as $option) {?>
		<?php if ($option['param'] && $this->params->get($option['param']) == false) continue; ?>
		<?php $selected = ($currentOption == $option['value']) ? 'selected="selected"' : ''; ?>
		<option <?php echo $selected; ?> data-url="<?php echo JRoute::_($orderUrl . $option['value']); ?>" value="<?php echo $this->escape($option['value'])?>"><?php echo $option['text']; ?></option>
	<?php } ?>
</select>

