<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user		= JFactory::getUser();
$price_auth = ($this->params->get('price_restrict', '0') == '1' && $user->guest) ? false : true;
?>

<?php
$nullDate = JFactory::getDbo()->getNullDate();

$producer_modals = array();
$multi_form = false;

foreach ($this->items as $item) {
	$itemLink = DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug);
	if ($this->params->get('seo_advanced', 0) == 0 && (int)($this->item->catslug)) {
		$itemLink = DJCatalogHelperRoute::getItemRoute($item->slug, $this->item->catslug);
	}

	$popupLink = DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug, null, 'preview').'&tmpl=component';
	if ($this->params->get('seo_advanced', 0) == 0 && (int)($this->item->catslug)) {
		$popupLink = DJCatalogHelperRoute::getItemRoute($item->slug, $this->item->catslug, null, 'preview').'&tmpl=component';
	}

	$contactLink = DJCatalogHelperRoute::getItemRoute($item->slug, $item->catslug, null, 'contact').'&tmpl=component';
	if ($this->params->get('seo_advanced', 0) == 0 && (int)($this->item->catslug)) {
		$contactLink = DJCatalogHelperRoute::getItemRoute($item->slug, $this->item->catslug, null, 'contact').'&tmpl=component';
	}

	$price_auth = ($user->guest) ? ( ($this->params->get('price_restrict', '0') == '1' || $item->price_restrict) ? false : true ): true;

	$item->_link = $itemLink;
	$item->_popuplink = $popupLink;
	$item->_contactlink = $contactLink;

	$item->_images = ($this->params->get('image_hover_item', 0) == 1) ? DJCatalog2ImageHelper::getImages('item', $item->id, true) : array();

	$this->item_cursor = $item;


	?>
		<div class="djc_products__item <?php if ($item->featured == 1) echo ' featured_item'; ?>">

		<?php
		$lblData = array('item' => $item, 'params' => $this->params, 'context' => 'com_djcatalog2.items.list', 'wrapper_class_sfx' => '_items');
		$layout = new JLayoutFile('com_djcatalog2.autolabels', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
		echo $layout->render($lblData);
		?>

		<?php if ((int)$this->params->get('image_link_item', 0) != -1) { ?>
			<?php
			$variant = 'img';
			$imgLink = (int)$this->params->get('image_link_item', 0);
			if ($imgLink == 0) {
				$variant = 'link';
			} else if ($imgLink == 1) {
				$variant = 'popup';
			} else if ($imgLink == 2) {
				$variant = 'preview';
			}
			$layout = new JLayoutFile('com_djcatalog2.listimage', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
			$imageData = array(	'item' => &$item,
								'type' => 'item',
								'size' => 'medium',
								'variant' => $variant,
								'hover_img' => $this->params->get('image_hover_item', 0) == 1,
								'context' => 'com_djcatalog2.items.list',
								'params' => &$this->params);
			echo $layout->render($imageData);
			?>
		<?php } ?>

		<?php if ((int)$this->params->get('show_item_name','1') > 0 ) {?>
			<div class="djc_products__item__title">
				<h3>
				<?php
				if ((int)$this->params->get('show_item_name','1') == 2 ) {
					echo $item->name;
				} else if ((int)$this->params->get('show_item_name','1') == 3) { ?>
					<a class="djc_item_preview_link" href="<?php echo JRoute::_($item->_popuplink); ?>"><?php echo $this->escape($item->name); ?></a>
				<?php } else { ?>
					<a href="<?php echo JRoute::_($item->_link); ?>"><?php echo $this->escape($item->name); ?></a>
				<?php } ?>
				</h3>
			</div>

			<?php if(!empty($item->event->afterDJCatalog2DisplayTitle)) { ?>
				<div class="djc_products__item__post_title">
					<?php echo $item->event->afterDJCatalog2DisplayTitle; ?>
				</div>
			<?php } ?>

		<?php } ?>

		<?php if ($this->params->get('product_rating', false) && $this->params->get('show_rating', true)) { ?>
			<div class="djc_products__item__rating djc_item_rating">
			<?php
			$voteData = array('item' => $item, 'params' => $this->params, 'context' => 'com_djcatalog2.items.list');
			$layout = new JLayoutFile('com_djcatalog2.item.rating', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
			echo $layout->render($voteData);

			if ($user->authorise('djcatalog2.vote', 'com_djcatalog2')) {
				$layout = new JLayoutFile('com_djcatalog2.item.vote', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
				echo $layout->render($voteData);
			}
			?>
			</div>
		<?php } ?>

		<?php if ($this->params->get('items_show_labels', 0) == '1' || $this->params->get('items_show_labels', 0) == '3') {
			echo $this->loadTemplate('items_labels');
		}?>

		<div class="djc_products__item__description">
			<div class="djc_products__item_info">
				<?php if (($this->params->get('show_category_name') > 0 && $item->publish_category) || ($this->params->get('show_producer_name') > 0 && $item->producer && $item->publish_producer) || ((int)$this->params->get('show_sku', 1) == 1 && $item->sku != '')) { ?>
					<div>
						<?php if ($this->params->get('show_category_name') > 0 && $item->publish_category) { ?>
							<div class="djc_products__category_info">
								<?php
								if ($this->params->get('show_category_name') == 2) {
									echo JText::_('COM_DJCATALOG2_CATEGORY').': '?>
									<span><?php echo $item->category; ?></span>
								<?php }
								else {
									echo JText::_('COM_DJCATALOG2_CATEGORY').': ';?>
									<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getCategoryRoute($item->catslug/*, $item->prodslud, $item->country, $item->state*/));?>">
										<span><?php echo $item->category; ?></span>
									</a>
								<?php } ?>
							</div>
						<?php } ?>

						<?php if ($this->params->get('show_producer_name') > 0 && $item->producer && $item->publish_producer) { ?>
							<div class="djc_products__producer_info">
								<?php if ($this->params->get('show_producer_name') == 2) { ?>
									<?php echo JText::_('COM_DJCATALOG2_PRODUCER').': '; ?>
									<span><?php echo $item->producer;?></span>
								<?php } else if(($this->params->get('show_producer_name') == 3)) { ?>
									<?php echo JText::_('COM_DJCATALOG2_PRODUCER').': ';?>
									<a data-toggle="modal" data-bs-toggle="modal" data-target="#djc_producer_modal-<?php echo $item->producer_id; ?>" href="#djc_producer_modal-<?php echo $item->producer_id; ?>" data-href="<?php echo JRoute::_(DJCatalogHelperRoute::getProducerRoute($item->prodslug).'&tmpl=component'); ?>" data-modaltitle="<?php echo $this->escape($item->producer); ?>">
										<span><?php echo $item->producer; ?></span>
									</a>
									<?php $producer_modals[$item->producer_id] = array('bodyHeight'  => '70', 'modalWidth'  => '80', 'title'=> $item->producer, 'url' => JRoute::_(DJCatalogHelperRoute::getProducerRoute($item->prodslug).'&tmpl=component')); ?>
								<?php } else { ?>
									<?php echo JText::_('COM_DJCATALOG2_PRODUCER').': ';?>
									<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getProducerRoute($item->prodslug)); ?>">
										<span><?php echo $item->producer; ?></span>
									</a>
								<?php } ?>
								<?php if ($this->params->get('show_producers_items', 1)) { ?>
									<a class="btn btn--mini" href="<?php echo JRoute::_(DJCatalogHelperRoute::getCategoryRoute(0).'&cm=0&pid='.$item->prodslug); ?>"><span><?php echo JText::_('COM_DJCATALOG2_SHOW_PRODUCERS_ITEMS'); ?></span></a>
								<?php } ?>
							</div>
						<?php } ?>

						<?php if ((int)$this->params->get('show_sku', 1) == 1 && $item->sku != '') { ?>
							<div class="djc_products__sku">
								<?php echo JText::_('COM_DJCATALOG2_SKU').': '; ?>
								<span><?php echo trim($item->sku); ?></span>
							</div>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if ($this->params->get('show_price') > 0) {?>
					<?php
					$priceOpts = array(
						'when_not_null' => $this->params->get('show_price') == 1,
						'display_always' => $this->params->get('show_price') == 2,
						'restricted_note' => $this->params->get('restricted_price_info', 1),
						'show_old' => $this->params->get('show_old_price', 1),
						'structured_data' => false
					);

					$priceData = array('item' => $item, 'params' => $this->params, 'options' => $priceOpts);
					$layout = new JLayoutFile('com_djcatalog2.price', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
					echo $layout->render($priceData);
				} ?>

				<?php if ($this->params->get('show_wishlist') || $this->params->get('show_preview_item') || $this->params->get('item_compare')) { ?>
					<div class="djc_products__item__toolbar">
		                <?php if ($this->params->get('show_wishlist')) {
		                    $layout = new JLayoutFile('com_djcatalog2.addtowishlist', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
		                    echo $layout->render(array('item' => $item));
		                } ?>

	                    <?php if ($this->params->get('show_preview_item')) { ?>
	                        <a class="btn_icon djc_item_preview" href="<?php echo JRoute::_($item->_popuplink); ?>">
	                            <?php //echo JText::_('COM_DJCATALOG2_READMORE_PREVIEW'); ?>
	                            <img src="components/com_djcatalog2/themes/catalog2k21/images/quick_view.svg">
	                        </a>
	                    <?php } ?>

                        <?php if ($this->params->get('compare_limit', 4) > 1 && $this->params->get('item_compare', false)) {?>
                            <?php
                            $enabled = (true) ? false : true;
                            $checked = $enabled ? 'checked="checked"' : '';
                            ?>
                            <form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=items');?>" method="post" class="btn_icon djc_form_compare" style="display: none">
                                <input id="<?php echo 'djc_compare-'.$item->id; ?>" class="btn_icon djc_item_compare djc_compare_checkbox" type="checkbox" name="item_id_chk" value="<?php echo $item->id; ?>" <?php echo $checked; ?>/>
                                <label for="<?php echo 'djc_compare-'.$item->id; ?>"></label>

                                <input type="hidden" name="item_id" value="<?php echo $item->id; ?>" />
                                <input type="hidden" name="task" value="<?php echo $enabled ? 'item.removeFromCompare' : 'item.addToCompare'; ?>" />
                                <noscript><button type="submit" class="btn btn-primary"><?php echo JText::_('COM_DJCATALOG2_BTN_CONFIRM'); ?></button></noscript>
                            </form>
                        <?php } ?>
					</div>
				<?php } ?>

				<?php
				$stockInfo = $this->params->get('show_outstock_info', 0);
				if ((int)$stockInfo > 0) {
					$stockData = array('item' => $item, 'type' => $stockInfo, 'params' => $this->params);
					$layout = new JLayoutFile('com_djcatalog2.stockinfo', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
					?>
					<p class="djc_stock_info"><?php echo $layout->render($stockData); ?></p>
				<?php } ?>

				<?php if ((int)$this->params->get('show_author', 0) || ((int)$this->params->get('show_date', 0) == 1 && $item->created != $nullDate) || ((int)$this->params->get('show_publishdate', 0) == 1 && $item->publish_up != $nullDate) || ((int)$this->params->get('show_hits', 0) == 1)) { ?>
					<div>
						<?php if ((int)$this->params->get('show_author', 0) > 0 && $item->author) { ?>
							<div class="djc_products__author">
								<?php echo JText::_('COM_DJCATALOG2_CREATED_BY').': '; ?>
								<?php if ((int)$this->params->get('show_author_item') == 1 && $item->created_by) {?>
									<a href="<?php echo JRoute::_(DJCatalogHelperRoute::getCategoryRoute(0).'&aid='.$item->created_by.':'.JApplicationHelper::stringURLSafe($item->author));?>"><span><?php echo $item->author; ?></span></a>
								<?php } else {?>
									<span><?php echo $item->author; ?></span>
								<?php } ?>
							</div>
						<?php } ?>

						<?php if ((int)$this->params->get('show_date', 0) == 1 && $item->created != $nullDate) { ?>
							<div class="djc_products__date djc_products__created_date">
								<?php echo JText::_('COM_DJCATALOG2_CREATED_ON').': '; ?>
								<span><?php echo Joomla\CMS\HTML\HTMLHelper::_('date', $item->created, $this->params->get('date_format_date', JText::_('DATE_FORMAT_LC3'))); ?></span>
							</div>
						<?php } ?>

						<?php if ((int)$this->params->get('show_publishdate', 0) == 1 && $item->publish_up != $nullDate) { ?>
							<div class="djc_products__date djc_products__publish_date">
								<?php echo JText::_('COM_DJCATALOG2_PUBLISHED_ON').': '; ?>
								<span><?php echo Joomla\CMS\HTML\HTMLHelper::_('date', $item->publish_up, $this->params->get('date_format_date', JText::_('DATE_FORMAT_LC3'))); ?></span>
							</div>
						<?php } ?>

						<?php if ((int)$this->params->get('show_hits', 0) == 1) { ?>
							<div class="djc_products__hits">
								<?php echo JText::_('COM_DJCATALOG2_HITS').': '; ?>
								<span><?php echo $item->hits; ?></span>
							</div>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if( (int)$this->params->get('show_location_details', true) > 0) { ?>
					<div class="djc_products__location">
						<?php
						$address = array();

						if (($this->params->get('location_address', 1) == '1' || $this->params->get('location_address', 1) == '3') && $item->address) {
							$address[] = $item->address;
						}
						if (($this->params->get('location_postcode', 1) == '1' || $this->params->get('location_postcode', 1) == '3') && $item->postcode) {
							$address[] = $item->postcode;
						}
						if (($this->params->get('location_city', 1) == '1' || $this->params->get('location_city', 1) == '3') && $item->city) {
							$address[] = $item->city;
						}
						if (($this->params->get('location_country', 1) == '1' || $this->params->get('location_country', 1) == '3') && $item->country_name) {
							$address[] = $item->country_name;
						}

						if (count($address)) { ?>
						<p class="djc_location__address"><?php echo implode(', ', $address); ?></p>
						<?php }

						$contact = array();

						if (($this->params->get('location_phone', 1) == '1' || $this->params->get('location_phone', 1) == '3') && $item->phone) {
							$contact[] = JText::_('COM_DJCATALOG2_UP_PHONE').': <span>'.$item->phone.'</span>';
						}
						if (($this->params->get('location_mobile', 1) == '1' || $this->params->get('location_mobile', 1) == '3') && $item->mobile) {
							$contact[] = JText::_('COM_DJCATALOG2_UP_MOBILE').': <span>'.$item->mobile.'</span>';
						}
						if (($this->params->get('location_fax', 1) == '1' || $this->params->get('location_fax', 1) == '3') && $item->fax) {
							$contact[] = JText::_('COM_DJCATALOG2_UP_FAX').': <span>'.$item->fax.'</span>';
						}
						if (($this->params->get('location_website', 1) == '1' || $this->params->get('location_website', 1) == '3') && $item->website) {
							$item->website = (strpos($item->website, 'http') === 0) ? $item->website : 'http://'.$item->website;
							$item->website = preg_replace('#([\w]+://)([^\s()<>]+)#iS', '<a target="_blank" rel="noopener noreferrer" href="$1$2">$2</a>', htmlspecialchars($item->website));
							$contact[] = JText::_('COM_DJCATALOG2_UP_WEBSITE').': <span>'.$item->website.'</span>';
						}
						if (($this->params->get('location_email', 1) == '1' || $this->params->get('location_email', 1) == '3') && $item->email) {
							$item->email = preg_replace('#([\w.-]+(\+[\w.-]+)*@[\w.-]+)#i', '<a target="_blank" rel="noopener noreferrer" href="mailto:$1">$1</a>', htmlspecialchars($item->email));
							$contact[] = JText::_('COM_DJCATALOG2_UP_EMAIL').': <span>'.$item->email.'</span>';
						}

						if (count($contact)) { ?>
						<p class="djc_location__contact"><?php echo implode('<br />', $contact);?></p>
						<?php } ?>
					</div>
				<?php } ?>

			</div>

			<?php if ($this->params->get('items_show_intro')) { ?>
				<div class="djc_products__item__introtext">
					<?php if ($this->params->get('items_intro_length') > 0  && $this->params->get('items_intro_trunc') == '1') { ?>
					<?php echo DJCatalog2HtmlHelper::trimText($item->intro_desc, $this->params->get('items_intro_length'));?>
					<?php } else { echo Joomla\CMS\HTML\HTMLHelper::_('content.prepare', $item->intro_desc, $this->params, 'com_djcatalog2.items.intro_desc'); } ?>
				</div>
			<?php } ?>

			<?php
			if ($this->params->get('items_show_attributes', '1')) {
				$layout = new JLayoutFile('com_djcatalog2.attributestable', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
				echo $layout->render(array('item' => $item, 'attributes' => $this->attributes, 'context' => 'com_djcatalog2.items.extra_fields', 'params' => $this->params));
			}
			?>
		</div>
		<?php if ((int)$item->available == 1 && (int)$this->params->get('items_show_cart_button', '1') > 0) {
			$multi_form = $multi_form || (bool)($this->params->get('items_show_cart_button') == 2);
			$layout = new JLayoutFile('com_djcatalog2.addtocart', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
			echo $layout->render(array('item' => $item, 'context' => 'com_djcatalog2.items.addtocart', 'params' => $this->params, 'multi_form' => (bool)($this->params->get('items_show_cart_button') == 2)));
		}?>

		<?php if ($this->params->get('showreadmore_item')) { ?>
			<div class="djc_products__item__more">
				<a class="btn btn-secondary btn--full_width" href="<?php echo JRoute::_($item->_link); ?>"><?php echo JText::_('COM_DJCATALOG2_READMORE'); ?></a>
			</div>
		<?php } ?>
	</div>
<?php } ?>

<?php if ($multi_form) {?>
	<form action="<?php echo JRoute::_(DJCatalogHelperRoute::getCartRoute());?>" method="post" class="djc_addtocart_submitter">
		<input type="submit" class="btn btn-primary" value="<?php echo JText::_('COM_DJCATALOG2_ADD_TO_CART'); ?>" disabled="disabled" />
		<input type="hidden" name="task" value="cart.update_batch"/>
		<input type="hidden" name="append" value="1"/>
		<input type="hidden" name="option" value="com_djcatalog2" />
		<?php echo Joomla\CMS\HTML\HTMLHelper::_( 'form.token' ); ?>
	</form>
<?php } ?>

<?php if (count($producer_modals) > 0) {?>
	<?php foreach($producer_modals as $pid => $producer) {?>
		<?php echo JHtmlBootstrap::renderModal('djc_producer_modal-'.$pid, array('height' => '600px', 'url' => $producer['url'], 'title'=> $producer['title'])); ?>
	<?php } ?>
<?php } ?>


