<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
?>


<div class="djc_checkout_form">
	<form id="djc_checkout_form" class="form-validate form" action="<?php echo JRoute::_(DJCatalogHelperRoute::getCheckoutRoute());?>" method="post">
		<fieldset>
			<?php $deliveryFields = $this->form->getFieldset('delivery'); ?>

				<div class="djc_billing_details">
					<h2><?php echo JText::_('COM_DJCATALOG2_USER_BILLING_HEADING'); ?></h2>
						<?php
						$fields = $this->form->getFieldset('basicprofile');
						foreach ($fields as $field) { ?>
							<?php echo $field->renderField(); ?>
					<?php } ?>
				</div>

				<?php if (!empty($deliveryFields)) { ?>
					<div class="djc_delivery_form">
						<h2><?php echo JText::_('COM_DJCATALOG2_DELIVERY_DETAILS_HEADING'); ?></h2>
						<?php $deliveryToggle = $this->form->getField('delivery_to_billing', 'djcatalog2delivery');?>

						<div class="control-group">
							<div class="control-label">
								<?php echo $deliveryToggle->label; ?>
							</div>
							<div class="controls">
								<?php echo $deliveryToggle->input; ?>
							</div>
						</div>

						<div id="djc_delivery_fields">
							<?php if ($this->params->get('cart_addressbook', true)) { ?>
								<div class="djc_address_book">
									<h4><?php echo JText::_('COM_DJCATALOG2_ADDRESS_BOOK_CHOOSE'); ?></h4>
									<?php $cleanAddress = array('id'=>0, 'name'=>'', 'name'=>'', 'firstname'=>'', 'lastname'=>'', 'company'=>'', 'address'=>'', 'country_id'=>'0', 'state_id'=>'0', 'city_id'=>'0', 'postcode'=>'', 'phone'=>''); ?>
									<select class="djc_address_book_list">
										<option value="" data-address='<?php echo json_encode($cleanAddress) ?>'><?php echo JText::_('COM_DJCATALOG2_CHOOSE_ADDRESS') ?></option>
										<?php foreach($this->addresses as $address) { ?>
											<option value="<?php echo $address->id ?>" data-address='<?php echo json_encode($address)?>'><?php echo $address->name ?></option>
										<?php } ?>
									</select>
								</div>
								<script type="text/javascript">
									jQuery(document).ready(function(){
										jQuery('.djc_address_book_list option').data();
										jQuery('.djc_address_book_list').on('change', function(e){
											var address = jQuery(this).find(':selected').data('address');
											jQuery.each(address, function(field, value) {
												jQuery("#jform_djcatalog2delivery_" + field).val(value);
											});
										});
									});
								</script>
							<?php } ?>

						<?php foreach ($deliveryFields as $field) { ?>
							<?php if ($field->fieldname == 'delivery_to_billing') continue; ?>
							<?php if ($field->fieldname == 'save') {
								if($user->guest) continue;
							?>
							<div class="control-group form-inline save-address-book">
								<?php echo $field->input; ?> <?php echo $field->label; ?>
							</div>
							<?php } else {
								echo $field->renderField();
							} ?>
						<?php } ?>
						</div>
					</div>
				<?php } ?>

			<?php $deliveryPaymentFields = $this->form->getFieldset('delivery_payment'); ?>
			<?php if (!empty($deliveryPaymentFields)) { ?>
				<div class="djc_orderdetails">
					<div class="djc_order_delivery_options">
						<?php if ($this->form->getField('delivery_method_id', 'djcatalog2orderdetails')) {?>
							<h2><?php echo JText::_('COM_DJCATALOG2_DELIVERY_OPTIONS_HEADING'); ?></h2>
							<?php echo $this->form->renderField('delivery_method_id', 'djcatalog2orderdetails');?>
						<?php } ?>

						<?php if ($this->form->getField('payment_method_id', 'djcatalog2orderdetails')) { ?>
							<h2><?php echo JText::_('COM_DJCATALOG2_PAYMENT_OPTIONS_HEADING'); ?></h2>
							<?php echo $this->form->renderField('payment_method_id', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('recurring', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('repeat', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('repeat_interval', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('repeat_until', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('weekday', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('weekly_weekdays', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('monthday', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('weekno', 'djcatalog2orderdetails');?>
							<?php echo $this->form->renderField('monthly_weekdays', 'djcatalog2orderdetails');?>
						<?php } ?>
					</div>

					<?php if (!empty($this->delivery_info) || !empty($this->payment_info)) { ?>
						<div class="djc_order_payment_options">
							<div class="djc_delivery_extra_data">
								<?php if (!empty($this->delivery_info)) {
									foreach ($this->delivery_info as $deliveryId => $deliveryPlg) {
										if (!empty($deliveryPlg)) { ?>
											<div id="djc_delivery_details-<?php echo $deliveryId; ?>" data-id="<?php echo $deliveryId; ?>" class="djc_delivery_details" style="display: none">
												<?php echo implode('', $deliveryPlg); ?>
											</div>
										<?php }
									}
								} ?>
							</div>

							<div class="djc_payment_extra_data">
								<?php if (!empty($this->payment_info)) {
									foreach ($this->payment_info as $paymentId => $paymentPlg) {
										if (!empty($paymentPlg)) { ?>
											<div id="djc_payment_details-<?php echo $paymentId; ?>" data-id="<?php echo $paymentId; ?>" class="djc_payment_details" style="display: none">
												<?php echo implode('', $paymentPlg); ?>
											</div>
										<?php }
									}
								} ?>
							</div>

						</div>
					<?php } ?>
				</div>
			<?php } ?>
			
			<?php /* Do not remove this container, it's used by shipping/payment plugins */ ?>
			<div class="row row-fluid">
				<div class="col-md-12">
					<div id="djcDeliveryForm"></div>
				</div>
			</div>
			
			<?php if ($this->params->get('cart_shipping_days_info', false) && count($this->shipping_days) > 0) : ?>
			<div class="djc_delivery_split">
				<p class="center text-center shipping-days-msg shipping-days-msg-1"><strong><?php echo JText::sprintf('COM_DJCATALOG2_EST_DELIVERY_DAYS', array_key_last($this->shipping_days)); ?></strong></p>
			</div>
			<?php endif; ?>

			<?php if ($this->params->get('cart_shipping_days_split', false) && count($this->shipping_days) > 1) : ?>
				<div class="djc_delivery_split">
					<h3 class="shipping-days-msg"><?php echo JText::sprintf('COM_DJCATALOG2_DELIVERY_SHIPPINGS_COUNT', count($this->shipping_days)); ?></h3>
					<div class="control-group">
						<div class="control-label">
							<label id="shipping-days-lbl" for="shipping-days"><?php echo JText::_('COM_DJCATALOG2_DELIVERY_PREFERD_SHIPPING_DAYS') ?></label>
						</div>
						<div class="controls">
							<select required="true" id="shipping-days" name="jform[djcatalog2delivery][shipping_days]" class="input form-control input-large" aria-invalid="false">
								<?php for($i = 1; $i <= count($this->shipping_days); $i++) : ?>
									<option value="<?php echo $i;?>"><?php echo $i;?></option>
								<?php endfor; ?>
							</select>
						</div>
					</div>
					<table class="shipping-days-details">
						<?php $deilvery = 1; ?>
						<?php foreach ($this->shipping_days as $days => $shipping_day) : ?>
							<tr>
								<th><?php echo JText::sprintf('COM_DJCATALOG2_DELIVERY_SHIPPINGS_DAYS_DEILVERY_NUMBER', $deilvery, $days); ?></th>
							</tr>
							<?php $item_number = 1; ?>
							<?php foreach ($shipping_day as $item) : ?>
								<tr>
									<td><?php echo $item_number . '. ' . $item->name . (($item->_quantity > 1) ? ' x ' . $item->_quantity : ''); ?></td>
								</tr>
								<?php $item_number++; ?>
							<?php endforeach; ?>
							<?php $deilvery++; ?>
						<?php endforeach; ?>
					</table>
				</div>
			<?php endif; ?>

			<div class="djc_order_additional_notes">
				<?php foreach ($this->form->getFieldsets() as $fieldset) { ?>
					<?php if ($fieldset->name != 'basicprofile' && $fieldset->name != 'delivery' && $fieldset->name != 'delivery_payment') { ?>
						<?php $fields = $this->form->getFieldset($fieldset->name);?>
						<?php if (count($fields)>0) { ?>
							<div class="djc_order_additional form-horizontal">
								<?php if ($fieldset->label) { ?>
									<h2><?php echo JText::_($fieldset->label); ?></h2>
								<?php } ?>
								<?php foreach($fields as $field) { ?>
									<?php if ($field->hidden) { ?>
											<?php echo $field->input;?>
									<?php } else { ?>
										<?php if ($field->type == 'Checkbox') { ?>
											<div class="control-group checkbox">
												<?php echo $field->input;?> <?php echo $field->label;?>
											</div>
										<?php } else { ?>
											<?php echo $field->renderField(); ?>
										<?php } ?>
									<?php }?>
								<?php } ?>
							</div>
						<?php } ?>
					<?php } ?>
				<?php } ?>
			</div>
		</fieldset>
		
		<input type="hidden" name="option" value="com_djcatalog2"/>
		<input type="hidden" name="task" value="cart.confirm" />
		<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	</form>
</div>

<script>
	function DJCatalog2OneStepSubmit(btn) {
		if (jQuery(btn).attr('quasi-disabled') == 'disabled') {
			return false;
		}
		if (document.formvalidator.isValid(document.getElementById('djc_checkout_form'))) {
			jQuery(btn).attr('quasi-disabled', 'disabled');
			return true;
		} else {
			alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
			jQuery('html, body').animate({
				scrollTop: jQuery('#system-message-container').offset().top
			}, 200);
		}
	}
</script>

<?php if (!empty($this->delivery_methods)) {?>
	<?php JText::script('COM_DJCATALOG2_FREE_DELIVERY_MODAL_MSG'); ?>
	<script>
	jQuery(document).ready(function(){
		var delivery = jQuery('input[name="jform[djcatalog2orderdetails][delivery_method_id]"]');
		var timer;
		var currentTotal = parseFloat(<?php echo floatval($this->product_total['gross']);?>);
		var deliveries = <?php echo json_encode($this->delivery_methods); ?>;
		var modalMsg = jQuery('#djc_free_delivery_modal');
		if (modalMsg.length == 0) return;
	
		modalMsg.detach().appendTo(jQuery(document.body));
	
		delivery.change(function(){
			if (timer) clearTimeout(timer);
			timer = setTimeout(function(){
				var field = jQuery('input[name="jform[djcatalog2orderdetails][delivery_method_id]"]:checked');
				if (!field.length) return;
	
				var idx = field.val();
				if (typeof deliveries[idx] == 'undefined') return;
	
				if (parseFloat(deliveries[idx].price) == 0.0) return;
	
				var free_amount = parseFloat(deliveries[idx].free_amount);
				if (isNaN(free_amount)) return;
	
				var left_price = (free_amount - currentTotal).toFixed(2);
				var msg = Joomla.JText._('COM_DJCATALOG2_FREE_DELIVERY_MODAL_MSG');
				msg = msg.replace('%s', left_price);
				if (free_amount > currentTotal ) {
					modalMsg.find('.djc_free_delivery_modal--msg').html('').text(msg);
					modalMsg.modal();
				}
			}, 1200);
		});
	});
	</script>
	
	<?php echo JHtmlBootstrap::renderModal('djc_free_delivery_modal', array('height'=> '500px', 'title' => JText::_('COM_DJCATALOG2_FREE_DELIVERY_MODAL_HEADING'), 'footer' => ' ',), '<div class="djc_free_delivery_modal--msg"></div>' ); ?>
<?php } ?>