<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

Joomla\CMS\HTML\HTMLHelper::_('behavior.keepalive');
Joomla\CMS\Factory::getDocument()->getWebAssetManager()->useScript('form.validate');
//Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip');

$app = JFactory::getApplication();
$user = JFactory::getUser();

$areas = array();
if ($this->params->get('cart_query_enabled', '1') == '1') {
	$areas['query'] = true;
}
if ($this->params->get('cart_enabled', '1') == '1') {
	$areas['checkout'] = true;
}

$displayTabs = count($areas) > 1;
$subLayout = $this->subLayout;

$price_auth = ($this->params->get('price_restrict', '0') == '1' && $user->guest) ? false : true;
$price_components = $this->basket->getPriceComponents();
$show_prices = (bool)($price_auth && ((int)$this->params->get('cart_show_prices', 0) == 1 || $this->params->get('cart_enabled', '1') == '1'));
$show_vat = $this->params->get('cart_show_vat', 1) && $show_prices;


?>

<?php { ?>
	<h1 class="componentheading<?php echo $this->params->get( 'pageclass_sfx' ) ?>">
		<?php echo $this->escape($this->params->get('page_heading')); ?>
	</h1>
<?php } ?>

<div id="djcatalog" class="djc_cart<?php echo $this->params->get( 'pageclass_sfx' ).' djc_theme_'.$this->params->get('theme','default') ?>">
	<?php if (count($this->items) < 1) { ?>
		<p class="djc_empty_cart"><?php echo JText::_('COM_DJCATALOG2_CART_IS_EMPTY'); ?></p>
	<?php } else { ?>

		<div class="djc_cart_grid">
			<div class="djc_cart_grid__main">
				<div class="djc_cart">
					<?php echo $this->loadTemplate('table2'); ?>
				</div>

				<?php if (count($areas) > 0) {?>
					<div class="djc_onestep_checkout">
						<?php if ($this->params->get('cart_coupons', 0) && $this->params->get('cart_enabled', 1)) {?>
							<?php echo $this->loadTemplate('coupon'); ?>
						<?php } ?>

						<?php if($this->params->get('cart_related_accessories') && !empty($this->related_accessories)) : ?>
							<?php echo $this->loadTemplate('related_accessories'); ?>
						<?php endif; ?>

						<?php if ($displayTabs) {?>
							<ul class="djc_tabs">
								<li <?php echo $subLayout == 'checkout' ? 'class="djc_tabs__item djc_tabs__item--active"' : 'class="djc_tabs__item"'?>><a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCheckoutRoute());?>#tabcheckout"><?php echo JText::_('COM_DJCATALOG2_ONESTEP_TAB_CHECKOUT');?></a></li>
								<li <?php echo $subLayout == 'query' ? 'class="djc_tabs__item djc_tabs__item--active"' : 'class="djc_tabs__item"'?>><a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getQueryRoute());?>#tabquery"><?php echo JText::_('COM_DJCATALOG2_ONESTEP_TAB_QUERY');?></a></li>
							</ul>
						<?php } ?>

						<?php if ($displayTabs) {?>
							<div class="djc_tabs__content"><div class="djc_tabs__content--active">
						<?php } ?>
						<?php if ( $user->guest
							&& ( ($subLayout == 'checkout' && $this->params->get('cart_registered', 1))
							|| ($subLayout == 'query' && $this->params->get('cart_query_registered', 1)) ) ) {?>
							<?php echo $this->loadTemplate('loginform'); ?>
						<?php } else {?>
							<?php echo $this->loadTemplate($subLayout); ?>
						<?php } ?>

						<?php if ($displayTabs) {?>
							</div></div>
						<?php } ?>
					</div>
				<?php } ?>
			</div>

			<div class="djc_cart_grid__sidebar">
				<div class="djc_cart_grid__sticky_container">
					<div class="djc_order_summary">
						<h3 class="djc_order_summary__heading"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUMMARY'); ?></h3>
						<?php if ($show_prices) {?>
							<div class="djc_order_summary__details">
								<?php if ($subLayout == 'checkout') {?>
								<p class="djc_order_summary__row">
									<?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_PRODUCTS'); ?>
									<span class="djc_order_summary__row--price" id="djc_summary_gross">
										<?php echo DJCatalog2HtmlHelper::formatPrice($this->basket->product_total['gross'], $this->params, false); ?>
									</span>
								</p>
								
								<p class="djc_order_summary__row">
									<?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_DELIVERY'); ?>
									<span class="djc_order_summary__row--price" id="djc_summary_delivery">
										<?php
											if ($this->basket->delivery) {
												echo DJCatalog2HtmlHelper::formatPrice($this->basket->delivery->_prices['total']['gross'], $this->params, false);
											} else {
												echo DJCatalog2HtmlHelper::formatPrice(0, $this->params, false);
										} ?>
									</span>
								</p>
								<p class="djc_order_summary__row">
									<?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_PAYMENT'); ?>
									<span class="djc_order_summary__row--price" id="djc_summary_payment">
										<?php
											if ($this->basket->payment) {
												echo DJCatalog2HtmlHelper::formatPrice($this->basket->payment->_prices['total']['gross'], $this->params, false);
											} else {
												echo DJCatalog2HtmlHelper::formatPrice(0, $this->params, false);
											}
										?>
									</span>
								</p>
								<?php if (!empty($price_components)) {
									$component_names = array();
									$component_value = 0.0;
									foreach($price_components as $component) {
										if ($component->type == 'coupon' || ($component->type == 'rule' && $component->rule->calc_type != 'grand_total')) {
											continue;
										}
										$component_names[] = $component->name;
										$component_value += $component->value['gross'];
									} ?>
									<?php if (count($component_names)) {?>
										<p class="djc_order_summary__row"><?php echo implode('<br />', $component_names); ?><span class="djc_order_summary__row--price"><?php echo DJCatalog2HtmlHelper::formatPrice($component_value, $this->params, false); ?></span></p>
									<?php } ?>
								<?php } ?>
									
								<?php if ($this->basket->coupon) { ?>
									<p class="djc_order_summary__row">
								    	<?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_COUPON_DISCOUNT'); ?>
				                   		<span class="djc_order_summary__row--price"><?php 
									    if($this->basket->coupon->type == 'percent') {
					                        echo ' ('. (float)$this->basket->coupon->value . '%)';
					                    } else {
					                        echo ' ('. DJCatalog2HtmlHelper::formatPrice($this->basket->coupon->value, $this->params) .')';
					                    } ?></span>
					                </p>
					                <?php } ?>
								<?php } ?>
								<p class="djc_order_summary__total">
									<?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_TOTAL'); ?>
									<span class="djc_order_summary__total--price" id="djc_summary_total">
										<?php echo DJCatalog2HtmlHelper::formatPrice($this->basket->total['gross'], $this->params, false); ?>
									</span>
								</p>
							</div>
						<?php } ?>
						<div class="djc_order_summary__buttons">

							<?php if (count($this->items) > 0) { ?>
								<?php if ($this->params->get('cart_enabled', '1') == '1' && $subLayout == 'checkout') { ?>
									<button form="djc_checkout_form" type="submit" class="btn btn-primary  btn--full_width djc_checkout_btn"  onclick="DJCatalog2OneStepSubmit(this);"><?php echo JText::_('COM_DJCATALOG2_CONFIRM_CHECKOUT');?></button>
								<?php } else if ($this->params->get('cart_query_enabled', '1') == '1' && $subLayout == 'query') { ?>
									<button form="djc_query_form" type="submit" class="btn btn-primary btn-success button validate" onclick="return DJCatalog2OneStepQuery(this);"><?php echo JText::_('COM_DJCATALOG2_CONFIRM_QUERY');?></button>
								<?php } ?>
							<?php } ?>
						</div>
					</div>
					
					<?php if ($this->params->get('cart_continue_btn')) {?>
						<div class="djc_cart__buttons">
							<a 	class="btn btn-primary djc_continue_shopping_btn" 
								href="<?php echo JRoute::_('index.php?Itemid=' . $this->params->get('cart_continue_btn')); ?>"><?php 
									echo JText::_('COM_DJCATALOG2_CONTINUE_SHOPPING'); 
							?></a>
						</div>
					<?php } ?>
				</div>
			</div>
			
		</div>

	<?php } ?>

	<?php if ($this->params->get('show_footer')) echo DJCATFOOTER; ?>
</div>
