<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

Joomla\CMS\HTML\HTMLHelper::_('behavior.keepalive');

$user = JFactory::getUser();
$return_url = base64_encode(JUri::getInstance()->__toString());

$price_components = $this->basket->getPriceComponents();
?>

<?php if (count($this->items) > 0) { ?>

	<?php if ($this->params->get('cart_enabled', '1') == '1') { ?>
		<ul class="djc_checkout_steps">
			<li class="djc_checkout_steps__step djc_checkout_steps__step--active">
				<span class="djc_checkout_steps__title">
					<a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getCartRoute()); ?>">
						<?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART'); ?>
					</a>
				</span>
			</li>
			<?php if (!($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1')) { ?>
				<li class="djc_checkout_steps__step<?php echo (JFactory::getUser()->guest && !($this->params->get('cart_registered', '1') == '0' && $this->params->get('cart_skip_login', '0') == '1')) ? null : '--skip' ?>">
					<span class="djc_checkout_steps__title">
						<?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_LOGIN'); ?>
					</span>
				</li>
			<?php } ?>
			<li class="djc_checkout_steps__step">
				<span class="djc_checkout_steps__title">
					<?php echo JText::_('COM_DJCATALOG2_CHECKOUT_STEP_CART_CHECKOUT'); ?>
				</span>
			</li>
		</ul>
	<?php } ?>

	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx') ?>">
			<?php echo $this->escape($this->params->get('page_heading')); ?>
		</h1>
	<?php } ?>

	<div id="djcatalog" class="djc_cart<?php echo $this->params->get('pageclass_sfx') . ' djc_theme_' . $this->params->get('theme', 'default') ?>">

		<div class="djc_cart_grid">
			<div class="djc_cart_grid__main">
				<div class="djc_cart_table">
					<?php echo $this->loadTemplate('table2'); ?>
				</div>
				<div class="djc_coupon">
					<?php if (count($this->items) > 0) { ?>
						<?php if ($this->params->get('cart_coupons', 0) && $this->params->get('cart_enabled', 1)) { ?>
							<?php echo $this->loadTemplate('coupon'); ?>
						<?php } ?>
					<?php } ?>
				</div>

				<?php if($this->params->get('cart_related_accessories') && !empty($this->related_accessories)) : ?>
					<?php echo $this->loadTemplate('related_accessories'); ?>
				<?php endif; ?>
			</div>
			<div class="djc_cart_grid__sidebar">
				<div class="djc_cart_grid__sticky_container">
					<div class="djc_order_summary">
						<h3 class="djc_order_summary__heading"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUMMARY'); ?></h3>
						<div class="djc_order_summary__details">
							<p class="djc_order_summary__row"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_PRODUCTS'); ?><span class="djc_order_summary__row--price"><?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['net'], $this->params)?></span></p>
							
							<?php if (!empty($price_components)) {
								$component_names = array();
								$component_value = 0.0;
								foreach($price_components as $component) {
									if ($component->type == 'coupon' || ($component->type == 'rule' && $component->rule->calc_type != 'grand_total')) {
										continue;
									}
									$component_names[] = $component->name;
									$component_value += $component->value['gross'];
								} ?>
								<?php if (count($component_names)) {?>
								<p class="djc_order_summary__row"><?php echo implode('<br />', $component_names); ?><span class="djc_order_summary__row--price"><?php echo DJCatalog2HtmlHelper::formatPrice($component_value, $this->params, false); ?></span></p>
								<?php } ?>
							<?php } ?>
							
							<?php if ($this->basket->coupon) { ?>
								<p class="djc_order_summary__row">
							    <?php echo JText::_('COM_DJCATALOG2_CART_FOOTER_COUPON_DISCOUNT'); ?>
			                   	<span class="djc_order_summary__row--price"><?php 
							    if($this->basket->coupon->type == 'percent') {
			                        echo ' ('. (float)$this->basket->coupon->value . '%)';
			                    } else {
			                        echo ' ('. DJCatalog2HtmlHelper::formatPrice($this->basket->coupon->value, $this->params) .')';
			                    } ?></span>
			                    </p>
							<?php }?>
							
							<p class="djc_order_summary__row"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_TAX'); ?><span class="djc_order_summary__row--price"><?php echo DJCatalog2HtmlHelper::formatPrice($this->product_old_total['tax'], $this->params)?></span></p>
							<p class="djc_order_summary__total"><?php echo JText::_('COM_DJCATALOG2_ORDER_SUM_TOTAL'); ?><span class="djc_order_summary__total--price"><?php echo DJCatalog2HtmlHelper::formatPrice($this->total['gross'], $this->params); ?></span></p>
						</div>

						<div class="djc_order_summary__buttons">
							<?php if (count($this->items) > 0) { ?>
								<?php if ($this->params->get('cart_query_enabled', '1') == '1') { ?>
									<form class="djc_order_summary__form" action="<?php echo JRoute::_(DJCatalogHelperRoute::getQueryRoute()); ?>" method="post">
										<input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_PROCEED_TO_CONTACT_FORM'); ?>" class="btn btn-primary btn-secondary btn--full_width djc_query_btn"/>
										<input type="hidden" name="option" value="com_djcatalog2"/>
										<input type="hidden" name="task" value="cart.query"/>
										<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
									</form>
								<?php } ?>

								<?php if ($this->params->get('cart_enabled', '1') == '1') { ?>
									<form class="djc_order_summary__form" action="<?php echo JRoute::_(DJCatalogHelperRoute::getCheckoutRoute()); ?>" method="post">
										<input type="submit" value="<?php echo JText::_('COM_DJCATALOG2_CONFIRM_CART'); ?>" class="btn btn-primary  btn--full_width djc_checkout_btn"/>
										<input type="hidden" name="option" value="com_djcatalog2"/>
										<input type="hidden" name="task" value="cart.checkout"/>
										<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
									</form>
								<?php } ?>
							<?php } ?>
						</div>
					</div>

					<div class="djc_cart__buttons">
						<input type="hidden" name="return" value="<?php echo $return_url; ?>" />
						<a class="btn btn-primary_link btn_link--icon_remove" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=cart.clear&'.JSession::getFormToken().'=1');?>">
							<?php echo JText::_('COM_DJCATALOG2_CART_CLEAR_BUTTON'); ?>
						</a>
						<?php echo Joomla\CMS\HTML\HTMLHelper::_( 'form.token' ); ?>
					</div>
				</div>
			</div>
		</div>

		<?php if ($this->params->get('show_footer')) echo DJCATFOOTER;?>
	</div>

<?php } else { ?>
	<p class="djc_cart--empty"><?php echo JText::_('COM_DJCATALOG2_CART_IS_EMPTY'); ?></p>
<?php } ?>
