<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');
$user = JFactory::getUser();
JHtmlBehavior::core();
?>

<?php if ($this->params->get('show_page_heading', 1)) { ?>
	<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx') ?>">
		<?php echo $this->escape($this->params->get('page_heading')); ?>
	</h1>
<?php } ?>

<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		Joomla.submitform(task, document.getElementById('submit-address-form'));
	}
</script>

<div id="djcatalog" class="djc_addresses<?php echo $this->params->get('pageclass_sfx').' djc_theme_'.$this->params->get('theme', 'default') ?>">

	<div class="djc_addresses__toolbar">
		<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&view=address'); ?>" method="post" name="submit-address-form" id="submit-address-form">
			<button type="button" onclick="Joomla.submitbutton('address.add')" class="btn btn-primary ">
				<?php echo JText::_('COM_DJCATALOG2_ADDRESS_ADD') ?>
			</button>
			<input type="hidden" name="task" value="" />
		</form>
	</div>

	<?php if ($this->items && count($this->items) > 0) { ?>
		<div class="djc_addresses__grid">
			<?php foreach ($this->items as $key => $item) { ?>
				<div class="djc_addresses__item">
					<div class="djc_addresses__item__toolbar">
						<h3 class="djc_addresses__name"><?php echo $item->name ?></h3>
						<div class="djc_addresses__buttons">
							<a class="btn_icon" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=address.edit&id='.(int)$item->id); ?>">
								<img src="components/com_djcatalog2/themes/catalog2k21/images/edit.svg">
							</a>
							<a class="btn_icon" href="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=addresses.delete&id='.(int)$item->id.'&'.JSession::getFormToken().'=1'); ?>">
								<img src="components/com_djcatalog2/themes/catalog2k21/images/delete.svg">
							</a>
						</div>
					</div>
					<?php if ($item->company) { ?>
						<p class="djc_addresses__company"><?php echo $item->company?></p>
					<?php } ?>
					<p class="djc_addresses__fl_name"><?php echo $item->firstname.' '.$item->lastname; ?></p>
					<p class="djc_addresses__postcode"><?php echo $item->postcode.', '.$item->city; ?></p>
					<p class="djc_addresses__address"><?php echo $item->address; ?></p>
					<p class="djc_addresses__country_state">
						<?php echo $item->country; ?>
						<?php echo(!empty($item->state) ? ', ':''). $item->state; ?>
					</p>
				</div>
			<?php } ?>
		</div>
	<?php } ?>

	<?php if ($this->pagination->total > 0) { ?>
		<div class="djc_pagination pagination djc_clearfix">
			<?php
				echo $this->pagination->getPagesLinks();
			?>
		</div>
	<?php } ?>

	<?php
		if ($this->params->get('show_footer')) {
			echo DJCATFOOTER;
		}
	?>

</div>
