<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$item = $displayData['item'];
$params = $displayData['params'];
$user = JFactory::getUser();

$options = $displayData['options'];

$price_auth = ($user->guest) ? (($params->get('price_restrict', '0') == '1' || $item->price_restrict) ? false : true) : true;

$availableForOtherGroups = false;
$avGroups = array();
if ((float)$item->price == 0.0 && !empty($item->_available_in_groups)) {
	foreach ($item->_available_in_groups as $avGroup) {
		if ((float)$avGroup->price > 0.0) {
			$availableForOtherGroups = true;
			$avGroups[] = $avGroup->name;
		}
	}
}

$tax_already_incl = (bool)($params->get('price_including_tax', 1) == 1);

?>

<?php if (!$price_auth || count($avGroups) > 0) {?>
	<div class="djc_subcategories__item__price djc_price" data-itemid="<?php echo $item->id; ?>" style="display: none" aria-live="polite">
	</div>
	<?php if ($options['restricted_note']) {?>
		<?php if (count($avGroups) > 0) {?>
			<span class="djc_price_info djc_available_in_groups"><?php echo JText::sprintf('COM_DJCATALOG2_PRODUCT_PRICE_AVAILABLE_FOR_GROUPS',  implode(', ', $avGroups));?></span>
		<?php } else {?>
			<span class="djc_price_info djc_available_in_groups"><?php echo JText::_('COM_DJCATALOG2_PRICE_RESTRICTED_FOR_GUESTS'); ?></span>
		<?php } ?>
	<?php } ?>
<?php } else if ($options['display_always'] || ($options['when_not_null'] && $item->price > 0.0)) { ?>
	<div class="djc_subcategories__item__price" itemprop="offers" itemscope itemtype="http://schema.org/Offer" data-itemid="<?php echo $item->id; ?>" aria-live="polite">
		<?php
		$show_tax = (int)$params->get('price_display_tax', 0);
		$prices = Djcatalog2HelperPrice::getPrices($item->final_price, $item->price, $item->tax_rule_id, false, $params);

		if ($prices['display'] != $prices['old_display'] ) {
			if ($options['show_old']) { ?>
				<span class="djc_subcategories__item__price--old"><?php echo DJCatalog2HtmlHelper::formatPrice($prices['old_display'], $params); ?></span>
				<span class="djc_subcategories__item__price--new"><?php echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params); ?></span>
			<?php } else { ?>
				<span class="djc_subcategories__item__price--new"><?php echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params);?></span>
			<?php } ?>
		<?php } else { ?>
			<span class="djc_subcategories__item__price"><?php echo DJCatalog2HtmlHelper::formatPrice($prices['display'], $params);?></span>
		<?php } ?>
		<?php if ($prices['display2nd'] !== false && $show_tax) { ?>
			<span class="djc_price_without_tax"><?php echo JText::sprintf('COM_DJCATALOG2_PRICE_WITHANDWITHOUT_TAX', DJCatalog2HtmlHelper::formatPrice($prices['display2nd'], $params, false), DJCatalog2HtmlHelper::formatPrice($prices['tax'], $params, false)); ?></span>
		<?php } else if ($show_tax) { ?>
			<span class="djc_price_with_tax"><?php echo JText::sprintf('COM_DJCATALOG2_PRICE_WITH_TAX', DJCatalog2HtmlHelper::formatPrice($prices['tax'], $params, false)); ?></span>
		<?php } else if ($prices['display2nd'] !== false ) {?>
			<?php if ($tax_already_incl) {?>
				<span class="djc_price_second"><?php echo JText::sprintf('COM_DJCATALOG2_PRICE_SECOND_GROSS_PRICE', DJCatalog2HtmlHelper::formatPrice($prices['display2nd'], $params, false)); ?></span>
			<?php } else {?>
				<span class="djc_price_second"><?php echo JText::sprintf('COM_DJCATALOG2_PRICE_SECOND_NET_PRICE', DJCatalog2HtmlHelper::formatPrice($prices['display2nd'], $params, false)); ?></span>
			<?php } ?>
		<?php } ?>

		<?php if (!empty($options['structured_data'])) {?>
		<meta itemprop="price" content="<?php echo $prices['display']; ?>" />
		<meta itemprop="priceCurrency" content="<?php echo $params->get('cart_currency', ''); ?>" />
		<?php } ?>
	</div>
<?php } else {?>
	<div class="djc_price" data-itemid="<?php echo $item->id; ?>" style="display: none" aria-live="polite"></div>
<?php }

