<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');
$variants = $displayData['variants'];
$item = $displayData['item'];
$params = $displayData['params'];


$onStock = (bool)(($item->onstock == 1 && $item->stock > 0) || $item->onstock >= 2);
$canCheckout = (bool)($params->get('cart_enabled', false) && (($onStock && $item->final_price > 0.0) || !empty($item->cart_variant_fields)));
$canQuery = (bool)($params->get('cart_query_enabled', 1));
$stockHandling = $params->get('show_outstock_info', 0);
if ($stockHandling > 0 && $item->product_type != 'tangible' && $item->onstock < 3) {
	$stockHandling = 1;
} else if ($item->onstock == 3) {
	$stockHandling = 0;
}

$stockHandling = $params->get('show_outstock_info', 0);
if ($stockHandling > 0 && $item->product_type != 'tangible' && $item->onstock < 3) {
	$stockHandling = 1;
} else if ($item->onstock == 3) {
	$stockHandling = 0;
}


?>

<?php if (($canCheckout || $canQuery) && $item->available) :
	$return_url = base64_encode(JUri::getInstance()->__toString());
	$button_value = $canCheckout ? JText::_('COM_DJCATALOG2_ADD_TO_CART') : JText::_('COM_DJCATALOG2_ADD_TO_QUOTE_CART');
	$button_class = $canCheckout ? 'djc_addtocart_btn' : 'djc_addtoquote_btn';
	$button_disabled = '';
	?>

	<form action="<?php ?>" data-stock="<?php echo $stockHandling; ?>" selected-variants='' data-availvariants='<?php echo (!empty($item->_combinations)) ? json_encode($item->_combinations) : ''; ?>' method="post" class="djc_form_addtocart btn--full_width djc_form_variants" data-itemid="<?php echo $item->id; ?>">
		<?php if (!empty($displayData['customData'])) {
			echo $displayData['customData'];
		} ?>

		<div class="djc_cart_variants ">

			<?php foreach ($variants as $variant) : ?>
				<?php
				$layout = new JLayoutFile('com_djcatalog2.item.variantfield', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
				echo $layout->render(array('field' => $variant, 'params' => $params, 'itemid' => $item->id));
				?>
			<?php endforeach; ?>
		</div>
		<div class="djc_addtocart">
			<?php

			$unit = DJCatalog2HelperQuantity::getUnit($item->unit_id);
			echo DJCatalog2HelperQuantity::renderInput($unit, $item, array('cart_button' => array('type' => 'input', 'value' => $button_value, 'class' => 'btn btn-primary btn--full_width ' . $button_class, 'attributes' => $button_disabled)));
			?>
		</div>

		<input type="hidden" name="option" value="com_djcatalog2"/>
		<input type="hidden" name="task" value="cart.add"/>
		<input type="hidden" name="return" value="<?php echo $return_url; ?>"/>
		<input type="hidden" name="item_id" value="<?php echo (int)$item->id; ?>"/>
		<input type="hidden" name="combination_id" value=""/>

		<?php echo Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	</form>
<?php endif; ?>
