<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');


$item = $displayData['item'];
$params = $displayData['params'];
$cfg = isset($displayData['config']) ? (array)$displayData['config'] : false;

// context can be used to distinguish the way labels are displayed
$context = $displayData['context'];

$wrapperClass = !empty($displayData['wrapper_class_sfx']) ? 'djc_autolabels djc_autolabels'.$displayData['wrapper_class_sfx'] : 'djc_autolabels';

$nullDate = JFactory::getDbo()->getNullDate();
$latestDays = $params->get('autolabel_latest_days', 0);

$autoLabels = array();

if ($cfg === false || in_array('price', $cfg)) {
	$priceLabels = Djcatalog2HelperPrice::getItemPriceRuleLabels($item->id);
	$autoLabels = array_merge($autoLabels, $priceLabels);
}

if ($item->featured && ($cfg === false || in_array('featured', $cfg))) {
	$autoLabels[] = ['label' => 'featured', 'id'=>'featured'];
}
if ($item->created && $item->created != $nullDate && $latestDays > 0 && ($cfg === false || in_array('latest', $cfg))) {
	$minDate = JFactory::getDate('-'.$latestDays.' days');
	$itemDate = JFactory::getDate($item->created);
	if ($itemDate->toUnix() >= $minDate->toUnix()) {
		$autoLabels[] = ['label'=>'latest','id'=>'latest'];
	}
}

if (count($autoLabels) < 1) return;
$lang = JFactory::getLanguage();

?>

<ul class="<?php echo $wrapperClass; ?>">
	<?php foreach($autoLabels as $label) {?>
		<?php $text = ($lang->hasKey('COM_DJCATALOG2_AUTOLABEL_' . $label['label'])) ? JText::_('COM_DJCATALOG2_AUTOLABEL_' . $label['label']) : $label['label'];?>
		<?php $lblClass= 'djc_autolabels__item djc_autolabels__item--'.JFilterOutput::stringURLSafe($label['id']).' djc_autolabels_label djc_autolabels_label-'  .JFilterOutput::stringURLSafe($label['id']); ?>
		<li class="<?php echo $lblClass; ?>"><?php echo $text; ?></li>
	<?php } ?>
</ul>
