<?php

/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;

jimport('joomla.application.component.modellist');


class DJCatalog2ModelWishes extends JModelList
{
    function __construct($config = array())
    {
        parent::__construct($config);
    }

    protected function populateState($ordering = null, $direction = null)
    {
        $app = JFactory::getApplication();
        $params = Djcatalog2Helper::getParams();
        $this->setState('params', $params);

        $globalSearch = urldecode($app->input->get('search', '', 'string'));
        $this->setState('filter.search', $globalSearch);
    }

    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');

        return md5($this->context . ':' . $id);
    }

    protected function _getList($query, $limitstart = 0, $limit = 0)
    {
        $this->_db->setQuery($query, $limitstart, $limit);
        $result = $this->_db->loadObjectList('id');

        return $result;
    }

    public function getItems()
    {
        // Get a storage key.
        $store = $this->getStoreId();

        // Try to load the data from internal storage.
        if (isset($this->cache[$store])) {
            return $this->cache[$store];
        }
        // Load the list items.
        $query = $this->_getListQuery();
        $items = $this->_getList($query, $this->getStart(), $this->getState('list.limit'));


        // Check for a database error.
        if ($this->_db->getErrorNum()) {
            $this->setError($this->_db->getErrorMsg());
            return false;
        }

        // Add the items to the internal cache.
        $this->cache[$store] = $items;

        $this->bindAttributes($store);

        return $this->cache[$store];
    }


    protected function _getListQuery()
    {
        // Create a new query object.
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $user = JFactory::getUser();


        $query->select(array(
            $db->quoteName('i.id', 'id'),
            $db->quoteName('i.alias', 'alias'),
            $db->quoteName('i.cat_id', 'product_cat'),
            $db->quoteName('i.name'),
            $db->quoteName('i.intro_desc'),

        ));



        if (!$user->guest) {
            $query->select($db->quoteName('c.alias', 'cat_alias'));
            $query
                ->from($db->quoteName('#__djc2_wishes', 'w'))
                ->join('INNER', $db->quoteName('#__djc2_items', 'i') . ' ON (' . $db->quoteName('i.id') . ' = ' . $db->quoteName('w.item_id') . ')')
                ->join('INNER', $db->quoteName('#__djc2_categories', 'c') . ' ON (' . $db->quoteName('i.cat_id') . ' = ' . $db->quoteName('c.id') . ')')
                ->where($db->quoteName('w.user_id') . ' = ' . $user->id);
        } else {
            $app = JFactory::getApplication();
            $items = $app->getUserState('com_djcatalog2.wishlist', array());

            $query
                ->from($db->quoteName('#__djc2_items', 'i'))
                ->where($db->quoteName('i.id') . ' IN (' . (!empty($items) ? implode(",", $items) : 0) . ')');

            if(!empty($items)) {
                $query->select($db->quoteName('c.alias', 'cat_alias'));
                $query->join('INNER', $db->quoteName('#__djc2_categories', 'c') . ' ON (' . $db->quoteName('i.cat_id') . ' = ' . $db->quoteName('c.id') . ')');
            }
        }


        return $query;
    }

    function bindAttributes($store)
    {
        if (!empty($this->cache[$store])) {
            $ids = array_keys($this->cache[$store]);

            if (empty($ids)) {
                return;
            }
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);

            $query->select('i.id, img.fullname as item_image, img.caption AS image_caption, img.path AS image_path, img.fullpath AS image_fullpath');
            $query->from('#__djc2_items as i');
            $query->join('inner', '#__djc2_images as img on img.id=(select id from #__djc2_images where type=\'item\' and item_id=i.id order by ordering asc limit 1)');
            $query->where('i.id IN ('.implode(',', $ids).')');

            $db->setQuery($query);
            $image_list = $db->loadObjectList('id');

            foreach($this->cache[$store] as &$row) {
                $row->slug = $row->id . ':' . $row->alias;
                $row->cat_slug = $row->product_cat . ':' . $row->cat_alias;

                $row->item_image = isset($image_list[$row->id]) ? $image_list[$row->id]->item_image : null;
                $row->image_caption = isset($image_list[$row->id]) ? $image_list[$row->id]->image_caption : null;
                $row->image_path = isset($image_list[$row->id]) ? $image_list[$row->id]->image_path : null;
                $row->image_fullpath = isset($image_list[$row->id]) ? $image_list[$row->id]->image_fullpath : null;
            }
        }
    }

    public function remove($ids) {
        if(!empty($ids)) {
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $user = JFactory::getUser();

            $query->delete($db->quoteName('#__djc2_wishes'))
            ->where($db->quoteName('item_id') . ' IN (' . implode(",", $ids) . ') AND ' . $db->quoteName('user_id') . ' = ' . (int) $user->id);

            $db->setQuery($query);

            return $db->execute();
        }
    }

    public function addToUserWishlist($user_id, $item_id)
    {
        $wish_item = new stdClass();
        $wish_item->user_id = $user_id;
        $wish_item->item_id = $item_id;

        return JFactory::getDbo()->insertObject('#__djc2_wishes', $wish_item);
    }

    function getParams()
    {
        return Djcatalog2Helper::getParams();
    }
}

