<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modelform');


class DJCatalog2ModelStocknotify extends JModelForm {
	
	public function getForm($data = array(), $loadData = true)
	{
		$control = !empty($data['item_id']) ? 'jform_'.$data['item_id'] : 'jform';
		
		$form = $this->loadForm('com_djcatalog2.stocknotify.' . $data['item_id'], 'stocknotify', array('control' => $control, 'load_data' => true), true);
		if (empty($form)) {
			return false;
		}
		
		$user = JFactory::getUser();
		if ($user->id > 0) {
			if ($form->getValue('email') == '') {
				$form->setFieldAttribute('email', 'default', $user->email);
			}
		}
		
		return $form;
	}
	
	protected function loadFormData()
	{
		return array();
	}
	
	public function validate($form, $data, $group = null)
	{
		$valid = parent::validate($form, $data, $group);
		if (!$valid) {
			return false;
		}
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('count(*)');
		$query->from('#__djc2_stocknotify');
		$query->where('email = ' . $db->quote($data['email']));
		$query->where('item_type = ' . $db->quote($data['item_type']));
		$query->where('item_id =' . $data['item_id']);
		$db->setQuery($query);
		$result = $db->loadResult();
		
		if ($result) {
			$this->setError(JText::_('COM_DJCATALOG2_STOCK_NOTIFY_ERROR_ALREADY_EXISTS'));
			return false;
		}
		
		$valid['id'] = null;
		return $valid;
	}
	
	public function save($data)
	{
		$db = JFactory::getDbo();
		try {
			$object = JArrayHelper::toObject($data);
			$result = $db->insertObject('#__djc2_stocknotify', $object, 'id');
		} catch (Exception $e) {
			$this->setError($e->getMessage());
			return false ;
		}
		
		if (!$result) {
			$this->setError(JText::_('COM_DJCATALOG2_STOCK_NOTIFY_ERROR_CANNOT_SAVE'));
			return false;
		}
		return true;
	}
}