<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class Djcatalog2ModelProducers extends JModelList
{
	static $_attributes = array();
	static $_attributeOptions = array();
	
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'a.name',
				'alias', 'a.alias',
				'ordering', 'a.ordering',
				'checked_out', 'a.checked_out',
				'checked_out_time', 'a.checked_out_time',
				'published', 'a.published',
				'access', 'a.access', 'access_level',
				'created', 'a.created',
				'created_by', 'a.created_by',
				'language', 'a.language'
			);
		}

		parent::__construct($config);
	}
	protected function populateState($ordering = null, $direction = null)
	{
		// List state information.
		parent::populateState('a.name', 'asc');
		
		// Initialise variables.
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		
		$params = Djcatalog2Helper::getParams();
		$this->setState('params', $params);

		$filters			= $app->input->get('djcf',array(),'array');
		$request = $app->input->getArray($_REQUEST);
		foreach($request as $param=>$value) {
			if (!array_key_exists('djcf', $request)) {
				$request['djcf'] = array();
			}
			if (strstr($param, 'f_')) {
				$qkey = substr($param, 2);
				$qval = null;
				if (is_array($value)) {
					$qval = $value;
				} else {
					$qval = (strstr($value,',') !== false) ? explode(',',$value) : $value;
				}
				//$qval = (strstr($value,',') !== false) ? explode(',',$value) : $value;
				unset($request[$param]);
				$request['djcf'][$qkey] = $qval;
			}
		}
		$filters = $request['djcf'];
		
		$this->setState('filter.customattribute', $filters);
		
		$searches		   = $app->input->get('djcs',array(), 'array');
		$this->setState('filter.customsearch', $searches);
		
		$globalSearch	   = urldecode($app->input->get( 'search','', 'string' ));
		$this->setState('filter.search', $globalSearch);

		//$published = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '');
		//$this->setState('filter.published', $published);
		
		$filter_catid	   = (int) $app->input->get( 'pcid', '0', 'int');
		$this->setState('filter.category', $filter_catid);
		
		$this->setState('filter.category_state', '1');
		
		$order		= $app->input->get( 'order', $params->get('producers_default_order','a.ordering'), 'cmd' );
		$this->setState('list.ordering', $order);
		
		$order_dir	= $app->input->get( 'dir',	$params->get('producers_default_order_dir','asc'), 'word' );
		$this->setState('list.direction', $order_dir);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$this->setState('params', $params);
	}

	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search');
		//$id	.= ':'.$this->getState('filter.published');
		
		$id .= ':'.serialize($this->getState('filter.customattribute'));
		$id .= ':'.serialize($this->getState('filter.customsearch'));
		
		$id	.= ':'.serialize($this->getState('filter.category'));
		$id	.= ':'.$this->getState('list.ordering');
		$id	.= ':'.$this->getState('list.direction');
		$id .= ':'.$this->getState('list.fields_visibility');

		return parent::getStoreId($id);
	}
	
	protected function _getList($query, $limitstart = 0, $limit = 0)
	{
		$this->_db->setQuery($query, $limitstart, $limit);
		$result = $this->_db->loadObjectList('id');
		
		return $result;
	}
	
	public function buildQuery() {
		return $this->getListQuery();
	}

	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$user = JFactory::getUser();
		$userGroups = implode(',', $user->getAuthorisedViewLevels());
		$params = $this->getState('params',  Djcatalog2Helper::getParams());

		// Select the required fields from the table.
		$select_default='a.*, c.name as category_name, c.alias as category_alias, img.fullname AS item_image, img.caption AS image_caption, img.path as image_path, img.fullpath as image_fullpath, uc.name AS editor';
		
		$query->select($this->getState('list.select', $select_default));
		
		$query->from('#__djc2_producers AS a');
		
		$query->join('LEFT', '#__djc2_producer_categories AS c ON c.id=a.cat_id');
		
		// Join over the users for the checked out user.
		$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		
		$query->join('left', '#__djc2_images as img on img.id = (select id from #__djc2_images where item_id = a.id and type=\'producer\' order by ordering asc limit 1)');
		
		
		$filter_access	   = $this->getState('filter.access', '1');
		$filter_catalogue = true;
		$filter_catid	   = $this->getState('filter.category');
		$filter_category_state	   = $this->getState('filter.category_state');
		
		$filters = $this->getState('filter.customattribute');
		$searches = $this->getState('filter.customsearch');
		$globalSearch = $this->getState('filter.search');
		$textSearch = array();
		$attributes = $this->getAttributes(true);

		if ((int)$filter_catid > 0) {
			$catOpts = array();
			if ($filter_access) {
				$catOpts['access'] = $userGroups;
			}
			if ($filter_category_state) {
				$catOpts['state'] = 1;
			}
			$categories = Djc2ProducerCategories::getInstance($catOpts);
			if ($parent = $categories->get((int)$filter_catid) ) {
				$childrenList = array($parent->id);
				$parent->makeChildrenList($childrenList);
				if ($childrenList) {
					$cids = implode(',', $childrenList);
					$query->where('c.id IN ('.$cids.')');
				} else if ($filter_catid != 0){
					JError::raiseError( 404, JText::_("COM_DJCATALOG2_PAGE_NOT_FOUND") );
				}
			}
		}
		
		// Filter by published state
		$published = $this->getState('filter.published', 1);
		if (is_numeric($published)) {
			$query->where('a.published = ' . (int) $published);
		}
		else if ($published === '') {
			$query->where('(a.published = 0 OR a.published = 1)');
		}

		$globalSearch = trim(JString::strtolower( $globalSearch ));
		if (JString::substr($globalSearch,0,1) == '"' && JString::substr($globalSearch, -1) == '"') {
			$globalSearch = JString::substr($globalSearch,1,-1);
		}
		if (JString::strlen($globalSearch) > 0 && (JString::strlen($globalSearch)) < 1 || JString::strlen($globalSearch) > 40) {
			$globalSearch = null;
		}
		
		if ($globalSearch) {
			
			$includeFalang = (bool)(Djcatalog2Helper::isFalang() && Djcatalog2Helper::isDefaultLanguage() === false);
			if ($includeFalang) {
				$langId = Djcatalog2Helper::getLangId();
				$query->join('LEFT', '#__falang_content AS falc ON falc.reference_table="djc2_producers" AND falc.language_id='.(int)$langId.' AND falc.reference_id = a.id');
			}
			
			$words = explode(' ', $globalSearch);
			$wheres = array();
			
			// all, any, exact
			$phrase = $params->get('search_method', 'all');
			if ($phrase == 'exact') {
				$words = array($globalSearch);
			}
			
			$fields = (array)$params->get('producers_search_fields', array('name', 'category_name', 'description'));
			
			foreach ($words as $word) {
				//$word_sku   = $db->quote($db->escape($word, true).'%', false);
				$word_sku   = $db->quote('%'.$db->escape($word, true).'%', false);
				$word	   = $db->quote('%'.$db->escape($word, true).'%', false);
				$wheres2	= array();
				
				foreach ($fields as $field) {
					if ($field == 'name') {
						$wheres2[]  = 'a.name LIKE '.$word;
					} else if ($field == 'description') {
						$wheres2[]  = 'a.description LIKE '.$word;
					} else if ($field == 'category_name') {
						$wheres2[]  = 'c.name LIKE '.$word;
					} else if ($field == 'meta') {
						$wheres2[]  = '(a.metakey LIKE '.$word.' OR a.metadesc LIKE '.$word.')';
					}
				}
				$wheres[]   = implode(' OR ', $wheres2);
			}
			
			$textSearch[]   = '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';
			
			$optionsSearch =
			' select i.id '
			.' from #__djc2_producers as i '
			.' inner join #__djc2_producers_extra_fields_values_int as efv on efv.item_id = i.id'
			.' inner join #__djc2_producers_extra_fields as ef on ef.id = efv.field_id and ef.searchable = 1 '
			.' inner join #__djc2_producers_extra_fields_options as efo on efo.id = efv.value and lower(efo.value) like '.$db->quote( '%'.$db->escape( $globalSearch, true ).'%', false )
			.' union '
			. 'select i.id '
			.' from #__djc2_producers as i '
			.' inner join #__djc2_producers_extra_fields_values_text as efv on efv.item_id = i.id'
			.' inner join #__djc2_producers_extra_fields as ef on ef.id = efv.field_id and ef.searchable = 1 and lower(efv.value) like '.$db->quote( '%'.$db->escape( $globalSearch, true ).'%', false )
			;
											
			$query->join('LEFT', '('.$optionsSearch.') AS customattribute_search ON customattribute_search.id = a.id');
			$textSearch[] = 'a.id = customattribute_search.id';
		}
		
		if (count($textSearch)) {
			$query->where(' ( '.implode( ' OR ', $textSearch ).' ) ');
		}
		
		$filter_unions = array();
		foreach ($attributes as $key=>$attribute) {
			$attributes[$key]->alias = str_replace('-', '_', $attribute->alias);
			
			if (!empty($filters[$attribute->alias])) {
				$filter = $filters[$attribute->alias];
				if ($attribute->filterable == 1) {
					
					if (is_scalar($filter) && strpos($filter, ',') !== false) {
						$filter = explode(',', $filter);
					} else if (is_scalar($filter) && strpos($filter, '-') !== false) {
						$filter = explode('-', $filter);
					}
					if (is_array($filter)) {
						if ($attribute->type == 'text') {
							$attribute->filter_type = 'minmax_text';
						}
						
						if ($attribute->filter_type == 'minmax' || $attribute->filter_type == 'minmax_text') {
							$min = false;
							$max = false;
							if (count($filter) == 2) {
								$min = (strlen($filter[0]) > 0) ? $filter[0] : false;
								$max = (strlen($filter[1]) > 0) ? $filter[1] : false;
								
								if ($min === false && $max === false) {
									continue;
								}
								if ($min === false) {
									if ($attribute->type == 'text') {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_text as v '
												.' where v.field_id='.$attribute->id.' and CAST(v.value AS DECIMAL(10,4)) <= '.$db->quote(floatval($max)).' group by v.item_id)';
									} else {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_int as v '
												.' left join #__djc2_producers_extra_fields_options as o on o.field_id=v.field_id and o.id = v.value '
													.' where v.field_id='.$attribute->id.' and CAST(o.value AS DECIMAL(10,4)) <= '.$db->quote(floatval($max)).' group by v.item_id)';
									}
									
								} else if ($max === false) {
									if ($attribute->type == 'text') {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_text as v '
												.' where v.field_id='.$attribute->id.' and CAST(v.value AS DECIMAL(10,4)) >= '.$db->quote(floatval($min)).' group by v.item_id)';
									} else {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_int as v '
												.' left join #__djc2_producers_extra_fields_options as o on o.field_id=v.field_id and o.id = v.value '
													.' where v.field_id='.$attribute->id.' and CAST(o.value AS DECIMAL(10,4)) >= '.$db->quote(floatval($min)).' group by v.item_id)';
									}
								} else {
									if ($attribute->type == 'text') {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_text as v '
												.' where v.field_id='.$attribute->id.' and CAST(v.value AS DECIMAL(10,4)) <= '.$db->quote(floatval($max)).' and CAST(v.value AS DECIMAL(10,4)) >= '.$db->quote(floatval($min)).' group by v.item_id)';
									} else {
										$filter_unions[] = '(select v.* '
											.' from #__djc2_producers_extra_fields_values_int as v '
												.' left join #__djc2_producers_extra_fields_options as o on o.field_id=v.field_id and o.id = v.value '
													.' where v.field_id='.$attribute->id.' and CAST(o.value AS DECIMAL(10,4)) <= '.$db->quote(floatval($max)).' and CAST(o.value AS DECIMAL(10,4)) >= '.$db->quote(floatval($min)).' group by v.item_id)';
									}
								}
							}
						} else {
							if ($attribute->type == 'checkbox' && $attribute->filter_type != 'checkbox_or') {
								foreach($filter as $key=>$opt) {
									if (is_scalar($opt)) {
										$filter_unions[] = '(select * from #__djc2_producers_extra_fields_values_int where field_id='.$attribute->id.' and value='.(int)$opt.')';
									}
								}
							} else {
								$terms = array();
								foreach($filter as $key=>$opt) {
									if (is_scalar($opt)) {
										$terms[] = 'value = '.(int)$opt;
									}
								}
								if (count($terms) > 0) {
									$condition = implode(' OR ', $terms);
									if ($attribute->type == 'checkbox' && $attribute->filter_type == 'checkbox_or') {
										$filter_unions[] = '(select * from #__djc2_producers_extra_fields_values_int where field_id='.$attribute->id.' and ('.$condition.') group by item_id)';
									} else {
										$filter_unions[] = '(select * from #__djc2_producers_extra_fields_values_int where field_id='.$attribute->id.' and ('.$condition.'))';
									}
								}
							}
						}
					} else {
						$filter_unions[] = '(select * from #__djc2_producers_extra_fields_values_int where field_id='.$attribute->id.' and value='.(int)$filter.')';
					}
				}
			}
			
			// Custom search
			if (!empty($searches[$attribute->alias]) && is_string($searches[$attribute->alias])) {
				$filter = $searches[$attribute->alias];
				if ($attribute->searchable == 1) {
					$tblAls = 'djcs'.$attribute->id;
					if ($attribute->type == 'checkbox' || $attribute->type == 'select' || $attribute->type == 'radio') {
						$subQuerySearch =
						' select i.id '
							.' from #__djc2_producers as i '
								.' inner join #__djc2_producers_extra_fields_values_int as efv on efv.item_id = i.id'
									.' inner join #__djc2_producers_extra_fields as ef on ef.id = efv.field_id and ef.searchable = 1 '
										.' inner join #__djc2_producers_extra_fields_options as efo on efo.id = efv.value and lower(efo.value) like '.$db->quote( '%'.$db->escape( $searches[$attribute->alias], true ).'%', false )
										;
										
										$query->join('INNER', '('.$subQuerySearch.') AS '.$tblAls.' ON '.$tblAls.'.id = a.id');
										
					} else if ($attribute->type == 'calendar') {
						$subQuerySearch =
						'select i.id '
							.' from #__djc2_producers as i '
								.' inner join #__djc2_producers_extra_fields_values_date as efv on efv.item_id = i.id'
									.' inner join #__djc2_producers_extra_fields as ef on ef.id = efv.field_id and ef.searchable = 1 and lower(efv.value) like '.$db->quote( '%'.$db->escape( $searches[$attribute->alias], true ).'%', false )
									;
									
									$query->join('INNER', '('.$subQuerySearch.') AS '.$tblAls.' ON '.$tblAls.'.id = a.id');
									
					} else {
						$subQuerySearch =
						'select i.id '
							.' from #__djc2_producers as i '
								.' inner join #__djc2_producers_extra_fields_values_text as efv on efv.item_id = i.id'
									.' inner join #__djc2_producers_extra_fields as ef on ef.id = efv.field_id and ef.searchable = 1 and lower(efv.value) like '.$db->quote( '%'.$db->escape( $searches[$attribute->alias], true ).'%', false )
									;
									
									$query->join('INNER', '('.$subQuerySearch.') AS '.$tblAls.' ON '.$tblAls.'.id = a.id');
					}
				}
			}
			
		}
		if (count($filter_unions) > 0) {
			$unionQuery = 'select * from (select count(*) as c, item_id from ('.implode(' union ', $filter_unions).') as f group by f.item_id) as filter_counter where filter_counter.c='.count($filter_unions);
			$query->join('inner', '('.$unionQuery.') as filters on filters.item_id = a.id');
		}
		
		$query->where('(a.language = ' . $db->quote(JFactory::getLanguage()->getTag()) . ' OR a.language = ' . $db->quote('*') . ')');

		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering', 'a.ordering');
		$orderDirn	= $this->state->get('list.direction', 'asc');
		
		$order_fields = array('a.name', 'a.id', 'a.ordering', 'name', 'category');
		if (!in_array($orderCol, $order_fields)){
			$filter_alias = false;
			if (strpos($orderCol, 'f_') !== false) {
				$alias = preg_replace('#^(f_)([a-zA-Z0-9_\-]+)#', '$2', $orderCol);
				if ($alias) {
					$db->setQuery('select * from #__djc2_producers_extra_fields where alias='.$db->quote($db->escape($alias)).' and published = 1 and sortable = 1 and (type = \'text\' || type = \'radio\' || type = \'select\' || type = \'calendar\')');
					$field = $db->loadObject();
					if (!empty($field)) {
						
						$orderCol = 'customattribute_order.value';
						$filter_alias = true;
						
						if ($field->type == 'calendar') {
							$query->join('LEFT', '#__djc2_producers_extra_fields_values_date AS customattribute_order ON customattribute_order.item_id = a.id AND customattribute_order.field_id='.(int)$field->id);
						} else if ($field->type == 'text') {
							$orderCol = 'ABS(customattribute_order.value) '.$orderDirn.', customattribute_order.value ';
							$query->join('LEFT', '#__djc2_producers_extra_fields_values_text AS customattribute_order ON customattribute_order.item_id = a.id AND customattribute_order.field_id='.(int)$field->id);
						} else {
							$orderCol = 'customattribute_order.ordering';
							$query->join('LEFT', '#__djc2_producers_extra_fields_values_int AS customattribute_order_ref ON customattribute_order_ref.item_id = a.id AND customattribute_order_ref.field_id='.(int)$field->id);
							$query->join('LEFT', '#__djc2_producers_extra_fields_options AS customattribute_order ON customattribute_order_ref.value = customattribute_order.id');
						}
					}
				}
			}
			
			if (!$filter_alias) {
				$orderCol = 'a.ordering';
			}
		}
		
		
		if ($orderCol == 'name') {
			$orderCol = 'a.name';
		} else if ($orderCol == 'category') {
			$orderCol = 'c.name';
		}
		
		if ($orderDirn != 'asc' && $orderDirn != 'desc') {
			$orderDirn = 'asc';
		}
	
		$query->order($db->escape($orderCol.' '.$orderDirn));

		return $query;
	}
	
	function getAttributes($all = false) {
		$idx = $all ? 0 : 1;
		if (!isset(self::$_attributes[$idx])) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			//$query->select('f.*, group_concat(fo.id order by fo.ordering asc separator \'|\') as options');
			$query->select('f.*');
			$query->from('#__djc2_producers_extra_fields as f');
			
			if ($all) {
				$query->where('f.published = 1');
			} else {
				$query->where('(f.visibility = 2 or f.visibility = 3) and f.published = 1');
			}
			$query->order('f.ordering asc');
			$db->setQuery($query);
			self::$_attributes[$idx] = $db->loadObjectList('id');
			
			//TODO: is it necessary?
			if (empty(self::$_attributeOptions)) {
				$optQuery = $db->getQuery(true);
				$optQuery->select('o.id, o.field_id');
				$optQuery->from('#__djc2_producers_extra_fields_options AS o');
				$optQuery->order('o.field_id asc, o.ordering asc');
				
				$db->setQuery($optQuery);
				$options = $db->loadObjectList();
				
				foreach($options as $k=>$v) {
					if (!isset(self::$_attributeOptions[$v->field_id])) {
						self::$_attributeOptions[$v->field_id] = array();
					}
					self::$_attributeOptions[$v->field_id][] = $v->id;
				}
			}
			
			foreach (self::$_attributes[$idx] as $k=>$v) {
				if (isset(self::$_attributeOptions[$k])) {
					self::$_attributes[$idx][$k]->options = implode('|', self::$_attributeOptions[$k]);
				} else {
					self::$_attributes[$idx][$k]->options = '';
				}
			}
		}
		return self::$_attributes[$idx];
	}
	
	public function getItems()
	{
		// Get a storage key.
		$store = $this->getStoreId();

		// Try to load the data from internal storage.
		if (isset($this->cache[$store]))
		{
			return $this->cache[$store];
		}
		// Load the list items.
		$query = $this->_getListQuery();
		//echo str_replace('#_', 'jos',(string)$query);die();
		$items = $this->_getList($query, $this->getStart(), $this->getState('list.limit'));
		
		// Check for a database error.
		if ($this->_db->getErrorNum())
		{
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		
		// Add the items to the internal cache.
		$this->cache[$store] = $items;
		
		$this->bindAttributes($store);

		return $this->cache[$store];
	}
	
	function bindAttributes($store) {
		if (!empty($this->cache[$store])) {
			$ids = array_keys($this->cache[$store]);
			if (empty($ids)) {
				return;
			}
			$db = JFactory::getDbo();
			
			$query_int = $db->getQuery(true);
			$query_text = $db->getQuery(true);
			$query_date = $db->getQuery(true);
			
			$visibility = $this->getState('list.fields_visibility');
			$where_visibility = ' AND (fields.visibility = 2 OR fields.visibility = 3) ';
			
			if ($visibility == '*') {
				$where_visibility = '';
			} else if (is_numeric($visibility) && (int)$visibility >= 0) {
				$where_visibility = ' AND fields.visibility='.(int)$visibility;
			} 
			
			$query_int->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, fieldoptions.id as option_id, fieldoptions.value, fieldoptions.params as option_params');
			$query_int->from('#__djc2_producers_extra_fields_values_int as fieldvalues');
			$query_int->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_int->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_int->join('left','#__djc2_producers_extra_fields_options as fieldoptions ON fieldoptions.id = fieldvalues.value AND fieldoptions.field_id = fields.id');
			$query_int->where('fieldvalues.item_id IN ('.implode(',',$ids).') '.$where_visibility.' AND fields.published = 1');
			//$query_int->order('fieldvalues.field_id asc, fieldvalues.field_id asc');
			$query_int->order('fieldvalues.field_id asc, fields.ordering asc, fieldoptions.ordering asc');
			
			$query_text->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, 0 as option_id, fieldvalues.value');
			$query_text->from('#__djc2_producers_extra_fields_values_text as fieldvalues');
			$query_text->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_text->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_text->where('fieldvalues.item_id IN ('.implode(',',$ids).') '.$where_visibility.' AND fields.published = 1');
			$query_text->order('fieldvalues.field_id asc, fields.ordering asc');
			
			$query_date->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, 0 as option_id, fieldvalues.value');
			$query_date->from('#__djc2_producers_extra_fields_values_date as fieldvalues');
			$query_date->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_date->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_date->where('fieldvalues.item_id IN ('.implode(',',$ids).') '.$where_visibility.' AND fields.published = 1');
			//$query_date->order('fieldvalues.field_id asc, fieldvalues.field_id asc');
			$query_date->order('fieldvalues.field_id asc, fields.ordering asc');
			
			$query_labels = $db->getQuery(true);
			$query_labels->select('l.*, li.item_id')->from('#__djc2_labels as l')->join('inner', '#__djc2_labels_items AS li ON li.label_id=l.id');
			$query_labels->where('li.item_id IN ('.implode(',',$ids).')');
			$query_labels->order('l.ordering');
			
			//$query = 'SELECT * FROM (('.(string)$query_int.') UNION DISTINCT ('.(string)$query_text.')) as list ORDER BY list.field_id asc, list.item_id asc';
			//echo str_replace('#_','jos',$query);die();
			
			// I decided not to use UNION because of FaLang translation issues
			
			$db->setQuery($query_int);
			$int_attributes = $db->loadObjectList();
			
			$db->setQuery($query_text);
			$text_attributes = $db->loadObjectList();
			
			$db->setQuery($query_date);
			$date_attributes = $db->loadObjectList();
			
			foreach ($text_attributes as $attribute) {
				$field = '_ef_'.$attribute->alias;
				$this->cache[$store][$attribute->item_id]->$field = $attribute->value;
				//$this->cache[$store][$attribute->item_id]->$field = $attribute->optionvalues ? $attribute->optionvalues : $attribute->value;
			}
			foreach ($date_attributes as $attribute) {
				$field = '_ef_'.$attribute->alias;
				$this->cache[$store][$attribute->item_id]->$field = $attribute->value;
			}
			foreach ($int_attributes as $attribute) {
				$field = '_ef_'.$attribute->alias;
				$param_field = '_efp_'.$attribute->alias;
				
				if (!isset($this->cache[$store][$attribute->item_id]->$field) || !is_array($this->cache[$store][$attribute->item_id]->$field)) {
					$this->cache[$store][$attribute->item_id]->$field = array();
				}
				$tmp_arr = $this->cache[$store][$attribute->item_id]->$field;
				$tmp_arr[$attribute->option_id] = $attribute->value;
				$this->cache[$store][$attribute->item_id]->$field = $tmp_arr;
				
				if (!isset($this->cache[$store][$attribute->item_id]->$param_field) || !is_array($this->cache[$store][$attribute->item_id]->$param_field)) {
					$this->cache[$store][$attribute->item_id]->$param_field = array();
				}
				$tmp_arr = $this->cache[$store][$attribute->item_id]->$param_field;
				$option_param = $attribute->option_params;
				if (!empty($option_param)) {
					$option_param = new Registry($option_param);
				}
				$tmp_arr[$attribute->option_id] = $option_param;
				$this->cache[$store][$attribute->item_id]->$param_field = $tmp_arr;
			}
			
			$query = $db->getQuery(true);
			$query->select('i.id, img.fullname as item_image, img.caption AS image_caption, img.path AS image_path, img.fullpath AS image_fullpath');
			$query->from('#__djc2_producers as i');
			
			//$query->join('inner', '(select im1.fullname, im1.caption, im1.type, im1.item_id, im1.path, im1.fullpath from #__djc2_images as im1, (select item_id, type, min(ordering) as lowest_order from #__djc2_images group by item_id, type) as im2 where im1.item_id = im2.item_id and im1.type=im2.type and im1.ordering = im2.lowest_order group by im1.type, im1.item_id, im1.path, im1.fullpath) AS img ON img.item_id = i.id AND img.type=\'item\'');
			$query->join('inner', '#__djc2_images as img on img.id=(select id from #__djc2_images where type=\'producer\' and item_id=i.id order by ordering asc limit 1)');
			$query->where('i.id IN ('.implode(',', $ids).')');
			$db->setQuery($query);
			$image_list = $db->loadObjectList('id');
			
			foreach($this->cache[$store] as &$row) {
				$row->slug = empty($row->alias) ? $row->id : $row->id.':'.$row->alias;
				$row->catslug = empty($row->category_alias) ? $row->cat_id : $row->cat_id.':'.$row->category_alias;
				
				$row->item_image = isset($image_list[$row->id]) ? $image_list[$row->id]->item_image : null;
				$row->image_caption = isset($image_list[$row->id]) ? $image_list[$row->id]->image_caption : null;
				$row->image_path = isset($image_list[$row->id]) ? $image_list[$row->id]->image_path : null;
				$row->image_fullpath = isset($image_list[$row->id]) ? $image_list[$row->id]->image_fullpath : null;
			}
			unset($row);
		}
	}
	
	public function getSortables($model = null) {
		$params = Djcatalog2Helper::getParams();
		$db = JFactory::getDBO();
		
		if (!$model) {
			$model = JModelLegacy::getInstance('Producers', 'Djcatalog2Model');
		}
		
		/*$model = JModelLegacy::getInstance('Producers', 'Djcatalog2Model');
		$state = $model->getState();
		
		$model->setState('params', $params);
		$model->setState('list.start', 0);
		$model->setState('list.limit', 0);
		$model->setState('list.select', 'a.id');
		$model->setState('filter.search', null);
		
		$model->setState('list.ordering', 'a.id');
		$model->setState('list.direction', 'asc');
		
		$items_query = $model->buildQuery();
		*/
		
		$query = $db->getQuery(true);
		$query->select('f.*');
		$query->from('#__djc2_producers_extra_fields as f');
		$query->where('f.published = 1 and f.sortable = 1 and (f.type = \'text\' OR f.type = \'radio\' OR f.type = \'select\' OR f.type = \'calendar\')');
		$query->group('f.name, f.alias, f.id');
		$query->order('f.ordering asc');
		$db->setQuery($query);
		
		$sortables = $db->loadObjectList();
		
		return $sortables;
	}
}