<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

use Joomla\Registry\Registry;

defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class DJCatalog2ModelProducer extends JModelLegacy {	
	protected $view_item = 'producer';
	protected $_item = null;
	protected $_context = 'com_djcatalog2.producer';
	protected $_attributes = array();
	
	protected function populateState()
	{
		$app = JFactory::getApplication('site');
		
		// Load state from the request.
		$pk = $app->input->getInt('pid');
		$this->setState('item.id', $pk);
		
		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);
		
	}
	
	public function &getItem($pk = null)
	{
		// Initialise variables.
		$pk = (!empty($pk)) ? $pk : (int) $this->getState('item.id');
		
		if ($this->_item === null) {
			$this->_item = array();
		}
		
		$bound = true;
		if (!isset($this->_item[$pk])) {
			try
			{
				$db = JFactory::getDbo();
				$query = $db -> getQuery(true);
				
				//$attributes = $this -> getAttributes();
				
				$query -> select('i.*');
				$query -> from('#__djc2_producers as i');
				
				$query -> select('c.id as _category_id, c.name as category, c.published as publish_category, c.alias as category_alias');
				$query -> join('left', '#__djc2_producer_categories AS c ON c.id = i.cat_id');
				
				$query -> select('ua.name AS author, ua.email AS author_email');
				$query -> join('left', '#__users AS ua ON ua.id = i.created_by');
				
				$nullDate = $db->quote($db->getNullDate());
				$date = JFactory::getDate();
				$nowDate = $db->quote($date->toSql());
				
				$query->where('i.id ='.(int)$pk);
				
				$query -> group('i.id');
				//echo str_replace('#_','jos',$query).'<br/>';die();
				$db -> setQuery($query);
				$item = $db -> loadObject();
				
				if (!empty($item)) {
					$item->slug = $item->prodslug = (empty($item->alias)) ? $item->id : $item->id.':'.$item->alias;
					$item->catslug = (empty($item->category_alias)) ? $item->cat_id : $item->cat_id.':'.$item->category_alias;
				}
				
				$this->_item[$pk] = $item;
				$bound = false;
			}
			catch (JException $e)
			{
				$this->setError($e);
				$this->_item[$pk] = false;
			}
			
		}
		if ($this->_item[$pk] && !$bound)
		{
			$this->bindAttributes($pk);
		}
		
		return $this->_item[$pk];
		
	}
	
	function getAttributes() {
		if (empty($this->_attributes)) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('f.*, group_concat(fo.id separator \'|\') as options');
			$query->from('#__djc2_producers_extra_fields as f');
			$query->join('LEFT', '#__djc2_producers_extra_fields_options as fo ON fo.field_id=f.id');
			
			$query->where('(f.visibility = 1 or f.visibility = 3) and f.published = 1');
			$query->group('f.id');
			$query->order('f.ordering asc');
			$db->setQuery($query);
			
			$this->_attributes = $db->loadObjectList();
		}
		
		return $this->_attributes;
	}
	
	function bindAttributes($id) {
		if (!empty($this->_item[$id])) {
			$db = JFactory::getDbo();
			
			$query_int = $db->getQuery(true);
			$query_text = $db->getQuery(true);
			$query_date = $db->getQuery(true);
			
			$query_int->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, fieldoptions.id as option_id, fieldoptions.value, fieldoptions.params as option_params');
			$query_int->from('#__djc2_producers_extra_fields_values_int as fieldvalues');
			$query_int->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_int->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_int->join('left','#__djc2_producers_extra_fields_options as fieldoptions ON fieldoptions.id = fieldvalues.value AND fieldoptions.field_id = fields.id');
			$query_int->where('fieldvalues.item_id='.$id.' AND (fields.visibility = 1 OR fields.visibility = 3) AND fields.published = 1');
			$query_int->order('fields.ordering asc, fieldoptions.ordering asc');
			
			$query_text->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, 0 as option_id, fieldvalues.value');
			$query_text->from('#__djc2_producers_extra_fields_values_text as fieldvalues');
			$query_text->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_text->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_text->where('fieldvalues.item_id='.$id.' AND (fields.visibility = 1 OR fields.visibility = 3) AND fields.published = 1');
			
			$query_date->select('fields.alias, fields.type, fields.ordering, fieldvalues.item_id, fieldvalues.field_id, fieldvalues.id as value_id, 0 as option_id, fieldvalues.value');
			$query_date->from('#__djc2_producers_extra_fields_values_date as fieldvalues');
			$query_date->join('inner', '#__djc2_producers as items on items.id=fieldvalues.item_id' );
			$query_date->join('inner','#__djc2_producers_extra_fields as fields ON fields.id = fieldvalues.field_id');
			$query_date->where('fieldvalues.item_id='.$id.' AND (fields.visibility = 1 OR fields.visibility = 3) AND fields.published = 1');
			$query_date->order('fields.ordering asc');
			
			$db->setQuery($query_int);
			$int_attributes = $db->loadObjectList();
			$db->setQuery($query_text);
			$text_attributes = $db->loadObjectList();
			$db->setQuery($query_date);
			$date_attributes = $db->loadObjectList();

			foreach ($text_attributes as $attribute) {
				if ($attribute->item_id == $id) {
					$field = '_ef_'.$attribute->alias;
					$this->_item[$id]->$field = $attribute->value;
				}
			}
			foreach ($date_attributes as $attribute) {
				if ($attribute->item_id == $id) {
					$field = '_ef_'.$attribute->alias;
					$this->_item[$id]->$field = $attribute->value;
				}
			}
			foreach ($int_attributes as $attribute) {
				if ($attribute->item_id == $id) {
					$field = '_ef_'.$attribute->alias;
					$param_field = '_efp_'.$attribute->alias;
					
					if (!isset($this->_item[$id]->$field) || !is_array($this->_item[$id]->$field)) {
						$this->_item[$id]->$field = array();
					}
					if (!in_array($attribute->value, $this->_item[$id]->$field)) {
						$tmp_arr = $this->_item[$id]->$field;
						$tmp_arr[$attribute->option_id] = $attribute->value;
						$this->_item[$id]->$field = $tmp_arr;
					}
					
					if (!isset($this->_item[$id]->$param_field) || !is_array($this->_item[$id]->$param_field)) {
						$this->_item[$id]->$param_field = array();
					}
					
					$tmp_arr = $this->_item[$id]->$param_field;
					$tmp_arr[$attribute->option_id] = new Registry($attribute->option_params);
					
					$this->_item[$id]->$param_field = $tmp_arr;
				}
			}
		}
	}
}