<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class Djcatalog2ModelOrders extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
					'a.id', 'a.order_number', 'a.invoice_number', 'a.created_date', 'a.status', 'a.grand_total'
			);
		}

		parent::__construct($config);
	}
	protected function populateState($ordering = null, $direction = null)
	{
		// List state information.
		parent::populateState('a.order_number', 'desc');
		
		// Initialise variables.
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		
		//$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'search');
		$search = $app->input->getString('search');
		$this->setState('filter.search', $search);
		
		$user = JFactory::getUser();
		$salesman = $user->authorise('djcatalog2.salesman', 'com_djcatalog2');
		$salesUser = $app->getUserState($app->getUserState('com_djcatalog2.checkout.user_id', null));
		
		if (!$salesman && !$salesUser) {
			$this->setState('filter.user', $user->id);
		} else {
			if ((int)$salesUser > 0) {
				$this->setState('filter.user', (int)$salesUser);
			} else {
				$this->setState('filter.salesman', $user->id);
			}
		}
		
		$limit		= 10;
		$this->setState('list.limit', $limit);
		
		$limitstart	= $app->input->get( 'limitstart', 0, 'int' );
		$this->setState('list.start', $limitstart);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_djcatalog2');
		$this->setState('params', $params);
	}
	
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.user');
		$id	.= ':'.$this->getState('filter.salesman');

		return parent::getStoreId($id);
	}

	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		);
		$query->from('#__djc2_orders AS a');
		
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			} else if (stripos($search, 'uid:') === 0) {
				$query->where('a.user_id = '.(int) substr($search, 4));
			}
			else {
				$search = $db->quote('%'.$db->escape($search, true).'%');
				$query->where('(a.order_number LIKE '.$search.' OR a.email LIKE '.$search.' OR a.firstname LIKE '.$search.' OR a.lastname LIKE '.$search.' OR a.company LIKE '.$search.')');
			}
		}
		
		$user = (int)$this->getState('filter.user', -1);
		$salesman = (int)$this->getState('filter.salesman', -1);
		
		if ($user > 0){
			$query->where('a.user_id='.$user);
		}

		$ids = $this->getState('filter.ids', false);
		if (!empty($ids)) {
			$query->where('a.id IN ('.$ids.')');
		}

		if ($salesman > 0) {
			$vendor = Djcatalog2Helper::getVendor();
			if ($vendor) {
				$userIds = Djcatalog2Helper::getVendorUsers(null, true);
				if (count($userIds)) {
					$query->where('(a.user_id IN ('.implode(',', $userIds).') OR a.salesman_id='.(int)$salesman.' OR a.user_id = '.JFactory::getUser()->id.')');
				}
			} else {
				$query->where('(a.salesman_id='.$salesman.'  OR a.user_id = '.JFactory::getUser()->id.')');
			}
		}
		
		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');

		if($orderCol || $orderDirn)
			$query->order($db->escape($orderCol.' '.$orderDirn));
		return $query;
	}

	public function getItems()
	{
		// Get a storage key.
		$store = $this->getStoreId();

		// Try to load the data from internal storage.
		if (!empty($this->_cache[$store])) {
			return $this->_cache[$store];
		}

		// Load the list items.
		$query  = $this->getListQuery();
		$items  = $this->_getList((string) $query, $this->getState('list.start'), $this->getState('list.limit'));

		// Check for a database error.
		if ($this->_db->getErrorNum()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Add the items to the internal cache.
		$this->_cache[$store] = $items;

		if($this->getState('order_items')) {
			$this->bindOrderItems($store);
		}

		return $this->_cache[$store];
	}

	private function bindOrderItems($store) {
		if (!empty($this->_cache[$store])) {
			$ids = array_keys($this->_cache[$store]);

			if (empty($ids)) {
				return;
			}

			$order_items = $this->getOrderItems($ids);
			if(count($order_items)) {
				foreach ($order_items as $order_item) {
					$this->_cache[$store][$order_item->order_id]->items[] = $order_item;
				}
			}

		}
	}

	protected function _getList($query, $limitstart = 0, $limit = 0)
	{
		$this->_db->setQuery($query, $limitstart, $limit);
		$result = $this->_db->loadObjectList('id');

		return $result;
	}

	public function getOrderItems($order_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('*');
		$query->from($db->quoteName('#__djc2_order_items'));

		if(is_array($order_id) && count($order_id)) {
			$query->where($db->quoteName('order_id') . ' IN ('. implode($order_id, ",") .')');
		} elseif (is_int($order_id)) {
			$query->where($db->quoteName('order_id') . ' = '. (int)$order_id);
		}


		$db->setQuery($query);

		return $db->loadObjectList();
	}
	
}