<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

// No direct access.

defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');

class Djcatalog2ModelOrder extends JModelAdmin
{
	protected $_item = null;
	
	public $invoiceStatuses = array('C', 'P', 'F');
	
	protected $_context = 'com_djcatalog2.order';
	
	public $delivery_methods = false;
	public $payment_methods = false;
	
	public function __construct($config = array()) {
		parent::__construct($config);
	}
	
	protected function populateState()
	{
		$table = $this->getTable();
		$key = 'oid';
		
		// Get the pk of the record from the request.
		$pk = JFactory::getApplication()->input->getInt($key);
		$this->setState($this->getName() . '.id', $pk);
		
		// Load the parameters.
		$value = JComponentHelper::getParams('com_djcatalog2');
		$this->setState('params', $value);
	}
	
	public function getTable($type = 'Orders', $prefix = 'Djcatalog2Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	public function getItem($pk = null)
	{
		$pk = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
		$table = $this->getTable();

		if ($pk > 0)
		{
			// Attempt to load the row.
			$return = $table->load($pk);
			
			// Check for a table object error.
			if ($return === false && $table->getError())
			{
				$this->setError($table->getError());
				return false;
			}
		}
		
		// Convert to the JObject before adding other data.
		$properties = $table->getProperties(1);
		
		$item = JArrayHelper::toObject($properties, 'JObject');
		
		if (!is_array($item->items)) {
			if (isset($item->id)) {
				
				$query = $this->_db->getQuery(true);
				$query->select('oi.*, i.product_type');
				$query->from('#__djc2_order_items AS oi');
				$query->join('LEFT', '#__djc2_items AS i ON i.id = oi.item_id AND oi.item_type='.$this->_db->quote('item'));
				$query->where('oi.order_id='.$item->id);
				
				$this->_db->setQuery($query);
				$item->items = $this->_db->loadObjectList();
				
				require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/download.php';
				
				$item->files = Djcatalog2HelperDownload::getOrderFiles($item);
			} else {
				$item->items = array();
			}
		}
		
		if (!isset($item->transactions)) {
			if (isset($item->id)) {
				$query = $this->_db->getQuery(true);
				$query->select('*');
				$query->from('#__djc2_transactions');
				$query->where('order_id='.$item->id);
				$query->order('id desc');
				$this->_db->setQuery($query);
				$item->transactions = $this->_db->loadObjectList();
			} else {
				$item->transactions = array();
			}
		}
		
		if (property_exists($item, 'params'))
		{
			$registry = new Registry();
			$registry->loadString($item->params);
			$item->params = $registry->toArray();
		}
		
		return $item;
	}
	
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		//$form = $this->loadForm('com_djcatalog2.userprofile', 'userprofile', array('control' => 'jform', 'load_data' => $loadData));
		$form = $this->loadForm('com_djcatalog2.checkout', Djcatalog2HelperUser::getUserFormXML('com_djcatalog2.checkout', $data), array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		
		return $form;
	}
	
	protected function preprocessForm(JForm $form, $data, $group = 'content') {
		if (!($form instanceof JForm))
		{
			$this->setError('JERROR_NOT_A_FORM');
			return false;
		}
		
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');
		$user = JFactory::getUser();
		$language = JFactory::getLanguage();
		$basket = Djcatalog2HelperCart::getInstance();
		
		$plugin = JFactory::getApplication()->getParams()->get('cart_captcha', JFactory::getConfig()->get('captcha'));
		
		if ($user->guest == false || ($plugin === 0 || $plugin === '0' || $plugin === '' || $plugin === null)) {
			$form->removeField('captcha', 'djcatalog2captcha');
		} else {
			JFactory::getApplication()->getParams()->set('captcha', $plugin);
		}
		
		$group = 'djcatalog2profile';
		$salesman = $user->authorise('djcatalog2.salesman', 'com_djcatalog2');
		
		if ($user->guest == false && !$salesman) {
			$form->setValue('email', $group, $user->email);
			$form->setFieldAttribute('email', 'readonly', 'true', $group);
			$form->setFieldAttribute('email', 'class', $form->getFieldAttribute('email', 'class', '', $group).' readonly', $group);
		}

		if (!$salesman || !$params->get('cart_enable_salesman', false)) {
			$form->removeField('user_id', 'djcatalog2profile');
		}
		
		//$form->removeField('client_type', 'djcatalog2profile');
		$form->removeField('customer_group_id', 'djcatalog2profile');
        $form->removeField('customer_note', 'djcatalog2profile');
        
        if ($params->get('cart_orderfield_customer_note', '0') == '0') {
        	$form->removeField('customer_note', 'djcatalog2message');
        } else {
        	if ($params->get('cart_orderfield_customer_note', '0') == '2') {
        		$form->setFieldAttribute('customer_note', 'required', 'required', $group);
        		$form->setFieldAttribute('customer_note', 'class', $form->getFieldAttribute('customer_note', 'class', '', 'djcatalog2message').' required', 'djcatalog2message');
        	} else {
        		$form->setFieldAttribute('customer_note', 'required', false, 'djcatalog2message');
        		
        		$class = $form->getFieldAttribute('customer_note', 'class', '', 'djcatalog2message');
        		$class = str_replace('required', '', $class);
        		
        		$form->setFieldAttribute('customer_note', 'class', $class, 'djcatalog2message');
        	}
        }

		/*
		$fields = array('company', 'position', 'address', 'city', 'postcode', 'country_id', 'state_id', 'vat_id', 'phone', 'fax', 'www');
		$delivery = array('company', 'address', 'city', 'postcode', 'country_id', 'state_id', 'phone');
		$message = array('customer_note', 'tos');
		
		$formFields = array(
			'djcatalog2profile' => $fields,
			'djcatalog2delivery' => $delivery,
			'djcatalog2message' => $message
		);
		*/
		/*
		foreach ($formFields as $group => $fields) {
			$paramSfx = '';
			switch ($group) {
				case 'djcatalog2profile' :
				case 'djcatalog2message' : $paramSfx = 'orderfield'; break;
				
				// TODO: common settings, perhaps temporarily
				//case 'djcatalog2delivery' : $paramSfx = 'deliveryfield'; break;
				case 'djcatalog2delivery' : $paramSfx = 'orderfield'; break;
				default: break;
			}
			
			foreach ($fields as $field) {
				// in case config is broken - using defaults from XML file
				if ($params->get('cart_'.$paramSfx.'_'.$field, false) === false) {
					continue;
				}
				
				if ($params->get('cart_'.$paramSfx.'_'.$field, '0') == '0') {
					$form->removeField($field, $group);
				} else {
					if ($params->get('cart_'.$paramSfx.'_'.$field, '0') == '2') {
						$form->setFieldAttribute($field, 'required', 'required', $group);
						$form->setFieldAttribute($field, 'class', $form->getFieldAttribute($field, 'class', '', $group).' required', $group);
					} else {
						$form->setFieldAttribute($field, 'required', false, $group);
						
						$class = $form->getFieldAttribute($field, 'class', '', $group);
						$class = str_replace('required', '', $class);
						
						$form->setFieldAttribute($field, 'class', $class, $group);
					}
				}
			}
		}*/
		
		if ($salesman) {
			//$form->removeField('tos', 'djcatalog2statements');
			$form->removeGroup('djcatalog2statements');
		} /*else {
			$tos_field = $params->get('cart_tos_field', true);
			if (!$tos_field) {
				$form->removeField('tos', 'djcatalog2statements');
			} else {
				$tos_link = $params->get('cart_tos_link', '');
				$tos_link = JUri::isInternal($tos_link) ? JRoute::_($tos_link) : $tos_link;
				if ($tos_link) {
					$form->setFieldAttribute('tos', 'label', JText::sprintf('COM_DJCATALOG2_TOS_WITH_LINK', $tos_link), 'djcatalog2statements');
				}
			}
		}*/
		
		/*
		$gdpr_policy = $params->get('cart_gdpr_policy');
		
		if ($gdpr_policy && !$salesman) {
			$policy_info = JText::sprintf('COM_DJCATALOG2_GDPR_POLICY_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_policy_info')) != '') {
				$policy_info = $params->get('cart_gdpr_policy_info');
				if ($language->hasKey($policy_info)) {
					$policy_info = JText::_($policy_info);
				}
			}
			$form->setFieldAttribute('gdpr_policy', 'label', $policy_info, 'djcatalog2statements');
		} else {
			$form->removeField('gdpr_policy', 'djcatalog2statements');
		}
		
		$gdpr_agreement = $params->get('cart_gdpr_agreement');
		if ($gdpr_agreement && !$salesman) {
			$agreement_info = JText::sprintf('COM_DJCATALOG2_GDPR_AGREE', $app->get('sitename'));
			if (trim($params->get('cart_gdpr_agreement_info')) != '') {
				$agreement_info = $params->get('cart_gdpr_agreement_info');
				if ($language->hasKey($agreement_info)) {
					$agreement_info = JText::_($agreement_info);
				}
			}
			$form->setFieldAttribute('gdpr_agreement', 'label', $agreement_info, 'djcatalog2statements');
		} else {
			$form->removeField('gdpr_agreement', 'djcatalog2statements');
		}
		*/
		
		$delivery_methods = $this->getDeliveryMethods();
		
		$current_delivery_id = $default_delivery_id = 0;
		
		if (empty($delivery_methods) || $basket->productTypes['tangible'] == 0) {
			$form->removeField('delivery_method_id', 'djcatalog2orderdetails');
			$form->removeGroup('djcatalog2delivery');
		} else {
			$form->setFieldAttribute('delivery_method_id', 'required', true, 'djcatalog2orderdetails');
			if (!($current_delivery_id = $form->getFieldAttribute('delivery_method_id', 'value', false, 'djcatalog2orderdetails'))) {
				$default_delivery_id = $delivery_methods[array_keys($delivery_methods)[0]]->id;
				//$form->setFieldAttribute('delivery_method_id', 'default', $default_delivery_id, 'djcatalog2orderdetails');
			}
		}
		
		$current_delivery_id = ($current_delivery_id > 0) ? $current_delivery_id : $default_delivery_id;
		$payment_methods = $this->getPaymentMethods($current_delivery_id);
		
		$all_payment_methods = $current_delivery_id > 0 ? $this->getPaymentMethods(0) : $payment_methods;
		
		if (empty($payment_methods) && empty($all_payment_methods)) {
			$form->removeField('payment_method_id', 'djcatalog2orderdetails');
		} else {
			$form->setFieldAttribute('payment_method_id', 'required', true, 'djcatalog2orderdetails');
			if (empty($delivery_methods)) {
				$form->setFieldAttribute('payment_method_id', 'no_shipment', true, 'djcatalog2orderdetails');
			}
			if (!($current_payment_id = $form->getFieldAttribute('payment_method_id', 'value', false, 'djcatalog2orderdetails'))) {
				
				if (empty($payment_methods) && empty($delivery_methods)) {
					$form->removeField('payment_method_id', 'djcatalog2orderdetails');
				} else {
					$default_payment_id = (empty($payment_methods)) ? '' : $payment_methods[array_keys($payment_methods)[0]]->id;
					//$form->setFieldAttribute('payment_method_id', 'default', $default_payment_id, 'djcatalog2orderdetails');
				}
			}
			
			$recurringShowOn = array();
			foreach($all_payment_methods as $pm) {
				if (isset($pm->recurring) && $pm->recurring) {
					$recurringShowOn[] = $pm->id;
				}
			}
			if (count($recurringShowOn)) {
				$form->setFieldAttribute('recurring', 'showon', 'payment_method_id:'.implode(',', $recurringShowOn).'', 'djcatalog2orderdetails');
			}
		}
		
		// Import the appropriate plugin group.
		JPluginHelper::importPlugin($group);
		JPluginHelper::importPlugin('djcatalog2payment');
		JPluginHelper::importPlugin('djcatalog2delivery');
		
		// Get the dispatcher.
		$dispatcher = JEventDispatcher::getInstance();
		
		// Trigger the form preparation event.
		$results = $dispatcher->trigger('onContentPrepareForm', array($form, $data));
	}
	
	protected function loadFormData()
	{
		$app = JFactory::getApplication();
		$user_id = $app->getUserState('com_djcatalog2.checkout.user_id', null);
		$db = JFactory::getDbo();
		
		$userProfile = Djcatalog2HelperUser::getUserProfile($user_id);
		$data = (isset($userProfile->djcatalog2profile)) ? array('djcatalog2profile' => JArrayHelper::fromObject($userProfile->djcatalog2profile, true)) : array();

		/*
		echo '<pre>' . print_r($data, true) . '</pre>';
		echo '<pre>' . print_r($userProfile, true) . '</pre>';
		die();
		*/
		
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$post_data = (array)JFactory::getApplication()->getUserState('com_djcatalog2.order.data', array());

		if(is_numeric($user_id) && $user_id == 0) {
			$data['djcatalog2profile']['email'] = $params->get('salesman_email', 'none@example.com');
		}

		if (!empty($post_data)) {
			foreach($post_data as $k=>$v) {
				$data[$k] = $v;
			}
		}
		
		if (empty($data['djcatalog2delivery'])) {
			$db->setQuery('select * from #__djc2_orders where user_id='.(int)$user_id.' order by id desc limit 1');
			$lastOrder = $db->loadObject();
			if ($lastOrder && $user_id > 0) {
				$delFields = array('firstname', 'lastname', 'company', 'address', 'city', 'postcode', 'country_id', 'state_id', 'phone');
				$data['djcatalog2delivery']['delivery_to_billing'] = $lastOrder->delivery_to_billing;
				foreach ($delFields as $field) {
					$attr = 'delivery_' . $field;
					if (isset($lastOrder->$attr)) {
						$data['djcatalog2delivery'][$field] = $lastOrder->$attr;
					}
				}
				
			} else {
				$data['djcatalog2delivery'] = $data['djcatalog2profile'];
			}
		}
		
		unset($data['djcatalog2delivery']['id']);
		unset($data['djcatalog2delivery']['save']);
		unset($data['djcatalog2delivery']['name']);
		
		$basket = Djcatalog2HelperCart::getInstance();
		
		if (!empty($basket->delivery) && isset($basket->delivery->id)) {
			$data['djcatalog2orderdetails']['delivery_method_id'] = $basket->delivery->id;
		}
		
		if (!empty($basket->payment) && isset($basket->payment->id)) {
			$data['djcatalog2orderdetails']['payment_method_id'] = $basket->payment->id;
		}
		
		$this->preprocessData('com_djcatalog2.order', $data);
		
		return $data;
	}
	
	protected function preprocessData($context, &$data, $group = 'content')
	{
		// Get the dispatcher and load the users plugins.
		$dispatcher = JEventDispatcher::getInstance();
		JPluginHelper::importPlugin('content');
		
		// Trigger the data preparation event.
		$results = $dispatcher->trigger('onContentPrepareData', array($context, $data));
		
		// Check for errors encountered while preparing the data.
		if (count($results) > 0 && in_array(false, $results, true))
		{
			$this->setError($dispatcher->getError());
		}
	}
	
	protected function prepareTable($table)
	{
		$db = JFactory::getDbo();
		
		if (empty($table->order_number)) {
			$db->setQuery('select max(order_number) from #__djc2_orders');
			$current = (int)$db->loadResult();
			$table->order_number = $current + 1;
		}
	}
	
	protected function getReorderConditions($table = null)
	{
		$condition = array();
		return $condition;
	}
	
	public function validate($form, $data, $group = null)
	{
		/*if ($group == null) {
		 $group = 'djcatalog2profile';
		 }
		*/
		//Djcatalog2HelperUser::prepareFormValidation($form, $data);
		
		$ret = parent::validate($form, $data, $group);
		
		if ($ret == false) {
			return $ret;
		}
		
		if ($group == 'djcatalog2profile' || $group == 'djcatalog2billing') {
			return $ret;
		}
		
		if (!isset( $data['djcatalog2orderdetails'])) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_DELIVERY_METHOD'));
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_PAYMENT_METHOD'));
			return false;
		}
		
		$db = JFactory::getDbo();
		
		$delivery = isset($data['djcatalog2orderdetails']['delivery_method_id']) ? $data['djcatalog2orderdetails']['delivery_method_id'] : 0;
		$payment = isset($data['djcatalog2orderdetails']['payment_method_id']) ? $data['djcatalog2orderdetails']['payment_method_id'] : 0;
		
		$basket = Djcatalog2HelperCart::getInstance();
		
		$deliveryMethods = $this->getDeliveryMethods();
		
		if (count($deliveryMethods) > 0) {
			if ($basket->productTypes['tangible'] > 0 && !$delivery) {
				$this->setError(JText::_('COM_DJCATALOG2_ERROR_MUST_SELECT_DELIVERY_METHOD'));
				return false;
			}
		}
		
		//TODO: 2. payment method may also be not necessary, e.g. free offers, 100% discount, etc.
		
		$paymentMethods = $this->getPaymentMethods('*');
		
		if (!$payment && count($paymentMethods) > 0) {
			return $ret;
		}
		
		//TODO: 3. Check delivery method's & payment method's availability - for given customer group etc.
		
		$extValid = true;
		
		$db->setQuery('select m.id
				from #__djc2_payment_methods as m
				left join #__djc2_deliveries_payments as dp on dp.payment_id = m.id
				where m.published = 1 and (dp.delivery_id = '.(int)$delivery.' or dp.payment_id is null)
				');
		$availablePayments = $db->loadColumn();
		
		if ($payment) {
			if (empty($availablePayments) || !in_array($payment, $availablePayments)) {
				$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_PAYMENT_METHOD'));
				$extValid = false;
			} else {
				if (!isset($paymentMethods[$payment])) {
					$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_PAYMENT_METHOD'));
					$extValid = false;
				} else {
					$validCountry = false;
					$validPostcode = false;
					$paymentMethod = $paymentMethods[$payment];
					$deliveryOpt = ( isset($data['djcatalog2delivery']) && isset($data['djcatalog2delivery']['delivery_to_billing']) ) ? ($data['djcatalog2delivery']['delivery_to_billing'] == 1 ? 'djcatalog2profile' : 'djcatalog2delivery') : 'djcatalog2profile';
					
					if (!empty($paymentMethod->countries) && is_array($paymentMethod->countries)) {
						$paymentCountry = isset($data[$deliveryOpt]['country_id']) ? $data[$deliveryOpt]['country_id'] : 0;
						$validCountry = (bool)($paymentCountry > 0 && in_array($paymentCountry, $paymentMethod->countries));
					} else {
						$validCountry = true;
					}
					
					if (!empty($paymentMethod->postcodes) && is_array($paymentMethod->postcodes)) {
						$paymentPostcode = isset($data[$deliveryOpt]['postcode']) ? $data[$deliveryOpt]['postcode'] : '';
						if (trim($paymentPostcode) == '') {
							$validPostcode = false;
						} else {
							if (count($paymentMethod->postcodes) == 1) {
								$validPostcode = (bool)($paymentPostcode == $paymentMethod->postcodes[0]);
							} else {
								$validPostcode = (bool)($paymentPostcode >= $paymentMethod->postcodes[0] && $paymentPostcode <= $paymentMethod->postcodes[1]);
							}
						}
					} else {
						$validPostcode = true;
					}
					
					if (!$validCountry || !$validPostcode) {
						$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_PAYMENT_METHOD'));
						$extValid = false;
					}
				}
			}
		} else if (count($availablePayments) > 0) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_PAYMENT_METHOD'));
			$extValid = false;
		}
		
		if ($delivery) {
			/*$db->setQuery('select id from #__djc2_delivery_methods where published=1 and id='.(int)$delivery);
			 if (!$db->loadResult()) {
			 $this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_DELIVERY_METHOD'));
			 $extValid = false;
			 }*/
			if (!isset($deliveryMethods[$delivery])) {
				$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_DELIVERY_METHOD'));
				$extValid = false;
			} else {
				$validCountry = false;
				$validPostcode = false;
				$validWeight = false;
				
				$deliveryMethod = $deliveryMethods[$delivery];
				$deliveryOpt = ( isset($data['djcatalog2delivery']) && isset($data['djcatalog2delivery']['delivery_to_billing']) ) ? ($data['djcatalog2delivery']['delivery_to_billing'] == 1 ? 'djcatalog2profile' : 'djcatalog2delivery') : 'djcatalog2profile';
				
				if (!empty($deliveryMethod->countries) && is_array($deliveryMethod->countries)) {
					$deliveryCountry = isset($data[$deliveryOpt]['country_id']) ? $data[$deliveryOpt]['country_id'] : 0;
					$validCountry = (bool)($deliveryCountry > 0 && in_array($deliveryCountry, $deliveryMethod->countries));
				} else {
					$validCountry = true;
				}
				
				if (!empty($deliveryMethod->postcodes) && is_array($deliveryMethod->postcodes)) {
					$deliveryPostcode = isset($data[$deliveryOpt]['postcode']) ? $data[$deliveryOpt]['postcode'] : '';
					if (trim($deliveryPostcode) == '') {
						$validPostcode = false;
					} else {
						if (count($deliveryMethod->postcodes) == 1) {
							$validPostcode = (bool)($deliveryPostcode == $deliveryMethod->postcodes[0]);
						} else {
							$validPostcode = (bool)($deliveryPostcode >= $deliveryMethod->postcodes[0] && $deliveryPostcode <= $deliveryMethod->postcodes[1]);
						}
					}
				} else {
					$validPostcode = true;
				}
				
				if ( ( (float)$deliveryMethod->min_weight > 0 || (float)$deliveryMethod->max_weight > 0 ) && $deliveryMethod->weight_unit) {
					$minWeight = DJCatalog2HelperQuantity::convertWeigthUnit($deliveryMethod->min_weight, $deliveryMethod->weight_unit, 'G');
					$maxWeight = DJCatalog2HelperQuantity::convertWeigthUnit($deliveryMethod->max_weight, $deliveryMethod->weight_unit, 'G');
					$basketWeight = $basket->getTotalWeight();
					
					if ($basketWeight < $minWeight || $basketWeight > $maxWeight) {
						$validWeight = false;
					} else {
						$validWeight = true;
					}
					
				} else {
					$validWeight = true;
				}
				
				if (!$validCountry || !$validPostcode || !$validWeight) {
					$this->setError(JText::_('COM_DJCATALOG2_ERROR_INVALID_DELIVERY_METHOD'));
					$extValid = false;
				}
			}
		}
		
		if ($extValid == false) {
			return false;
		}
		
		return $ret;
	}
	
	public function save($data)
	{
		$dispatcher = JEventDispatcher::getInstance();
		$table = $this->getTable();
		
		$table->reset();
		
		$db = JFactory::getDbo();
		
		$key = $table->getKeyName();
		$pk = (!empty($data[$key])) ? $data[$key] : (int) $this->getState($this->getName() . '.id');
		$isNew = true;
		
		$deliveryObject = $paymentObject = $deliveryPlg = $paymentPlg = false;
		
		JPluginHelper::importPlugin('djcatalog2payment');
		JPluginHelper::importPlugin('djcatalog2delivery');
		
		if (!empty($data['delivery_method_id'])) {
			$db->setQuery('select * from #__djc2_delivery_methods where id='.(int)$data['delivery_method_id']);
			if ($deliveryObject = $db->loadObject()) {
				$params = new Registry();
				$params->loadString($deliveryObject->params, 'JSON');
				$deliveryObject->params = $params;
				$deliveryPlg = JPluginHelper::getPlugin('djcatalog2delivery', $deliveryObject->plugin);
			}
		}
		
		if (!empty($data['payment_method_id'])) {
			$db->setQuery('select * from #__djc2_payment_methods where id='.(int)$data['payment_method_id']);
			if ($paymentObject = $db->loadObject()) {
				$params = new Registry();
				$params->loadString($paymentObject->params, 'JSON');
				$paymentObject->params = $params;
				$paymentPlg = JPluginHelper::getPlugin('djcatalog2payment', $paymentObject->plugin);
			}
		}

		// Allow an exception to be thrown.
		try
		{
			// Load the row if saving an existing record.
			if ($pk > 0)
			{
				$table->load($pk);
				$isNew = false;
			}
			
			// Bind the data.
			if (!$table->bind($data))
			{
				$this->setError($table->getError());
				
				return false;
			}
			
			// Prepare the row for saving
			$this->prepareTable($table);
			
			// Check the data.
			if (!$table->check())
			{
				$this->setError($table->getError());
				return false;
			}
			
			$deliveryRes = $dispatcher->trigger('onDJC2BeforeSaveOrder', array('com_djcatalog2.checkout.delivery', $table, $isNew, $deliveryObject));
			$paymentRes = $dispatcher->trigger('onDJC2BeforeSaveOrder', array('com_djcatalog2.checkout.payment', $table, $isNew, $paymentObject));
			
			if (in_array(false, $deliveryRes, true) || in_array(false, $paymentRes, true))
			{
				$this->setError($table->getError());
				return false;
			}
			
			// Store the data.
			if (!$table->store())
			{
				$this->setError($table->getError());
				return false;
			}
			
			$params = JComponentHelper::getParams('com_djcatalog2');
			
			if (empty($table->proforma_number) && $params->get('cart_proformas')) {
				require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/invoice.php';
				$invoiceCounter = 0;
				$date = JFactory::getDate();
				
				$invoiceNumber = DJCatalog2HelperInvoice::getNext($invoiceCounter, $date, 'proforma');
				
				$query = $db->getQuery(true);
				$query->update('#__djc2_orders');
				$query->set('proforma_counter='.$invoiceCounter);
				$query->set('proforma_number='.$db->quote($invoiceNumber));
				$query->where('id='.(int)$table->id);
				$db->setQuery($query);
				
				if (!$db->execute()) {
					$this->setError($db->getErrorMsg());
					return false;
				}
				
				$table->proforma_counter = $invoiceCounter;
				$table->proforma_number = $invoiceNumber;
				
				DJCatalog2HelperInvoice::update($invoiceCounter, $date, 'proforma');
			}
			
			// Clean the cache.
			$this->cleanCache();
			
			$deliveryRes = $dispatcher->trigger('onDJC2AfterSaveOrder', array('com_djcatalog2.order.delivery', $table, $isNew, $deliveryObject));
			$paymentRes = $dispatcher->trigger('onDJC2AfterSaveOrder', array('com_djcatalog2.order.payment', $table, $isNew, $paymentObject));
			
			$dispatcher->trigger($this->event_after_save, array('com_djcatalog2.order', $table, $isNew, $data));
		}
		catch (Exception $e)
		{
			$this->setError($e->getMessage());
			
			return false;
		}
		
		$pkName = $table->getKeyName();
		$orderId = $table->$pkName;
		
		foreach($data['order_items']['item_id'] as $k => $itemId) {
			if ($itemId == 0 || $data['order_items']['item_type'][$k] != 'item') continue;
			
			$quantity = $data['order_items']['quantity'][$k];
			if (!($quantity > 0.0000)) continue;
			
			if ($data['order_items']['combination_id'][$k] == 0) {
				$db->setQuery('UPDATE #__djc2_items SET stock = stock - '.(float)$quantity.' WHERE id='.(int)$itemId);
				$db->execute();
			} else {
				$db->setQuery('UPDATE #__djc2_items_combinations SET stock = stock - '.(float)$quantity.' WHERE id='.(int)$data['order_items']['combination_id'][$k]);
				$db->execute();
			}
		}
		
		if (isset($table->$pkName))
		{
			$this->setState($this->getName() . '.id', $orderId);
		}
		$this->setState($this->getName() . '.number', $table->order_number);
		$this->setState($this->getName() . '.new', $isNew);
		
		return true;
	}
	
	public function sendNewOrderEmail($data, $attachments = array())
	{
		require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/messenger.php');
		
		$app		= JFactory::getApplication();
		$params 	= JComponentHelper::getParams('com_djcatalog2');
		$user = JFactory::getUser();
		
		// Prepate the data for notifications
		$data['order_number'] = str_pad($data['order_number'], 6, '0', STR_PAD_LEFT);
		
		$data['onEmailAfterPaymentDisplay'] = null;
		$data['onEmailAfterDeliveryDisplay'] = null;
		
		$model = JModelLegacy::getInstance('Order', 'DJCatalog2Model', array('ignore_request' => true));
		$dispatcher = JDispatcher::getInstance();
		if (!empty($data['payment_method_id'])) {
			$paymentMethod = $model->getPaymentMethod($data['payment_method_id']);
			if ($paymentMethod) {
				$onEmailAfterPaymentDisplay = $dispatcher->trigger('onEmailAfterPaymentDisplay', array('com_djcatalog2.cart.confirm', &$data, $paymentMethod));
				foreach ($onEmailAfterPaymentDisplay as $pluginResponse) {
					if (empty($pluginResponse)) continue;
					$data['onEmailAfterPaymentDisplay'] .= $pluginResponse . PHP_EOL;
				}
			}
		}
		
		if (!empty($data['delivery_method_id'])) {
			$deliveryMethod = $model->getDeliveryMethod($data['delivery_method_id']);
			if ($deliveryMethod) {
				$onEmailAfterDeliveryDisplay = $dispatcher->trigger('onEmailAfterDeliveryDisplay', array('com_djcatalog2.cart.confirm', &$data, $deliveryMethod));
				foreach ($onEmailAfterDeliveryDisplay as $pluginResponse) {
					if (empty($pluginResponse)) continue;
					$data['onEmailAfterDeliveryDisplay'] .= $pluginResponse . PHP_EOL;
				}
			}
		}
		
		$mailfrom	= $app->getCfg('mailfrom');
		//$fromname	= $app->getCfg('fromname');
		//$sitename	= $app->getCfg('sitename');
		
		// Send notifications to admins
		$vendors = Djcatalog2Helper::getVendors($user->id);
		
		$contact_list = $params->get('contact_list', false);
		$recipient_list = array();
		if ($contact_list !== false) {
			$recipient_list = explode(PHP_EOL, $params->get('contact_list', ''));
		}
		
		$list_is_empty = true;
		foreach ($recipient_list as $r) {
			if (strpos($r, '@') !== false) {
				$list_is_empty = false;
				break;
			}
		}
		
		if ($list_is_empty) {
			$recipient_list[] = $mailfrom;
		}
		if ($user->authorise('djcatalog2.salesman', 'com_djcatalog2')) {
			$recipient_list[] = $user->email;
		}
		if (count($vendors) > 0) {
			foreach($vendors as $vendor) {
				$recipient_list[] = $vendor->email;
			}
		}
		$recipient_list = array_unique($recipient_list);
		
		$customerName = $data['firstname'].' '.$data['lastname'];
		if (!empty($data['company'])) {
			$customerName = $data['company'];
		}
		
		$adminMailopts = [
			'recipient_name' => $customerName,
			'order_number' => $data['order_number'],
			'order_customer_data' => DJCatalog2HtmlHelper::getThemeLayout($data, 'order_customer', 'email/layouts'),
			'order_items' => DJCatalog2HtmlHelper::getThemeLayout($data, 'order_items', 'email/layouts'),
			'order_link' => JRoute::_(DJCatalog2HelperRoute::getOrderRoute($data['id']) . '&token=' . $data['token'], false, (JUri::getInstance()->isSsl() ? 1 : -1))
		];
		
		foreach($recipient_list as $recipient) {
			$messenger = new DJCatalog2HelperMessenger();
			$messenger->notify($recipient, ['type' => 'order_admin'], $attachments, $adminMailopts );
		}
		
		// Email to the customer
		$mailopts = [
			//'recipient_name' => $data['firstname'].' '.$data['lastname'],
			'recipient_name' => $customerName,
			'order_number' => $data['order_number'],
			'order_customer_data' => DJCatalog2HtmlHelper::getThemeLayout($data, 'order_customer', 'email/layouts'),
			'order_items' => DJCatalog2HtmlHelper::getThemeLayout($data, 'order_items', 'email/layouts'),
			'order_link' => JRoute::_(DJCatalog2HelperRoute::getOrderRoute($data['id']) . '&token=' . $data['token'], false, (JUri::getInstance()->isSsl() ? 1 : -1))
		];
		
		$messenger = new DJCatalog2HelperMessenger();
		$messenger->notify($data['email'], ['type' => 'order'], $attachments, $mailopts );
		
		return true;
	}
	
	public function saveRecurring($recurringData, $orderData) {
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		$item = new stdClass();
		$item->id = 0;
		$item->order_id = $orderData['id'];
		$item->executed = 0;
		
		$dates = array();
		
		$now = JFactory::getDate();
		//$start = JFactory::getDate(JFactory::getDate('+ 1 day')->format('Y-m-d'). ' 00:00:00');
		$start = JFactory::getDate(JFactory::getDate()->format('Y-m-d'). ' 00:00:00');
		
		$end = JFactory::getDate($recurringData['repeat_until']);
		$duration = $end->toUnix() - $start->toUnix();
		
		$interval = ' + 1 ';
		switch($recurringData['repeat']) {
			case 'yearly' : {
				$interval .= 'year';
				break;
			}
			case 'monthly' : {
				$interval .= 'month';
				break;
			}
			case 'weekly' :
			default: {
				$interval .= 'week';
				break;
			}
		}
		
		$until	= JFactory::getDate($recurringData['repeat_until'].' 23:59:59')->toUnix();
		
		// make sure repeat until date is later than end event date
		if($start->toUnix() > $until) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_RECURRING_ORDER_UNTIL_BEFORE_START'));
			return false;
		}
		
		if($recurringData['repeat'] == 'weekly') {
			// weekly repetition with selected week day(s)
			
			$weekdays = empty($recurringData['weekly_weekdays']) ? array(1) : (is_array($recurringData['weekly_weekdays']) ? $recurringData['weekly_weekdays'] : array($recurringData['weekly_weekdays']));
			
			$from = JFactory::getDate()->toUnix(); //$start->toUnix();
			$weekday = $start->format('N');
			// shift start date to the beginning of the week
			if($weekday != 1) {
				$start = JFactory::getDate($start->format('Y-m-d H:i').' -'.($weekday - 1).' days');
			}
			
			do {
				foreach($weekdays as $weekday) {
					$item->id = 0;
					
					$start2 = JFactory::getDate($start->format('Y-m-d H:i').' +'.($weekday - 1).' days');
					
					if ($start2->toUnix() >= $from && $start2->toUnix() < $until) {
						
						$item->start = $start2->toSql();
						if($db->insertObject('#__djc2_orders_recurring', $item) == false) {
							$app->enqueueMessage($db->getError(), 'error');
						}
						
						$dates[] = $start2->format('Y-m-d');
					}
				}
				
				$start = JFactory::getDate($start->format('Y-m-d H:i').$interval);
				
			} while ($start->toUnix() < $until);
			
		} else if ($recurringData['repeat'] == 'monthly') {
			// monthly repetition with selected
			$weekno = 	array(1, 2, 3, 4, 5);
			$weekdays = array(1, 2, 3, 4, 5, 6, 7);
			
			$monthday = $recurringData['monthday'];
			
			$from = JFactory::getDate()->toUnix(); //$start->toUnix();
			
			// shift start date to the beginning of the month
			$start = JFactory::getDate($start->format('Y-m').'-01 '.$start->format('H:i'));
			do {
				/*for($d = 1; $d <= $start->format('t'); $d++) {
				
				$which = ceil($d / 7);
				if(!in_array($which, $weekno)) continue;
				
				$start2 = JFactory::getDate($start->format('Y-m').'-'.($d < 10 ? '0':'').$d.' '.$start->format('H:i'));
				if(!in_array($start2->format('N'), $weekdays)) continue;
				
				if($start2->toUnix() >= $from && $start2->toUnix() < $until) {
				
				$item->id = 0;
				$item->start = $start2->toSql();
				if($db->insertObject('#__djc2_orders_recurring', $item) == false) {
				$app->enqueueMessage($db->getError(), 'error');
				}
				
				$dates[] = $start2->format('Y-m-d');
				}
				}
				*/
				
				$monthDaysNo = $start->format('t');
				$monthdayCurrent = min($monthDaysNo, $monthday);
				$start2 = JFactory::getDate($start->format('Y-m').'-'.($monthdayCurrent < 10 ? '0':'').$monthdayCurrent.' '.$start->format('H:i'));
				
				if($start2->toUnix() >= $from && $start2->toUnix() < $until) {
					
					$item->id = 0;
					$item->start = $start2->toSql();
					if($db->insertObject('#__djc2_orders_recurring', $item) == false) {
						$app->enqueueMessage($db->getError(), 'error');
					}
					
					$dates[] = $start2->format('Y-m-d');
				}
				
				$start = JFactory::getDate($start->format('Y-m-d H:i').$interval);
				
			} while ($start->toUnix() < $until);
			
		} else {
			$from = JFactory::getDate()->toUnix(); //$start->toUnix();
			
			// simple repetition based on interval only
			do {
				if($start->toUnix() >= $from && $start->toUnix() < $until) {
					$item->id = 0;
					$item->start = $start->toSql();
					if($db->insertObject('#__djc2_orders_recurring', $item) == false) {
						$app->enqueueMessage($db->getError(), 'error');
					}
					
					$dates[] = $start->format('Y-m-d');
				}
				
				$start = JFactory::getDate($start->format('Y-m-d H:i').$interval);
				
			} while ($start->toUnix() < $until);
		}
		
		if(!count($dates)) {
			$this->setError(JText::_('COM_DJCATALOG2_ERROR_RECURRING_ORDER_REPETITION_FAILED'));
			return false;
		}
		
		return $dates;
	}
	
	public function getDeliveryMethods() {
		if ($this->delivery_methods === false) {
			
			$user	= JFactory::getUser();
			$userGroups = implode(',', $user->getAuthorisedViewLevels());
			
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('d.*');
			$query->from('#__djc2_delivery_methods AS d');
			$query->where('d.published=1');
			
			if(!$user->authorise('djcatalog2.salesman', 'com_djcatalog2')) {
				$query->where('access IN ('.$userGroups.')');
			}
			$query->order('d.ordering asc');
			
			$db->setQuery($query);
			$delivery_methods = $db->loadObjectList('id');
			foreach($delivery_methods as &$method) {
				$method->countries = $method->countries != '' ? explode(',', $method->countries) : null;
				$method->postcodes = $method->postcodes != '' ? explode('|', $method->postcodes) : null;
				$method->price = Djcatalog2HelperPrice::applyPriceRules($method->price, true, 'delivery', $method, 'delivery');
			}
			unset($method);
			
			$this->delivery_methods = count($delivery_methods) ? $delivery_methods : array();
		}
		return $this->delivery_methods;
	}
	
	public function getPaymentMethods($delivery_method_id = 0) {
		if (!is_array($this->payment_methods)) {
			$this->payment_methods = array();
		}
		if (!isset($this->payment_methods[$delivery_method_id])) {
			$db = JFactory::getDbo();
			
			if ($delivery_method_id > 0) {
				$query = 'select m.*
					from #__djc2_payment_methods as m
					left join #__djc2_deliveries_payments as dp on dp.payment_id = m.id
					where m.published = 1 and (dp.delivery_id = '.(int)$delivery_method_id.' or dp.payment_id is null)
					group by m.id order by m.ordering asc ';
			} else if ($delivery_method_id === '*') {
				$query = 'select m.*
					from #__djc2_payment_methods as m
					where m.published = 1
					order by m.ordering asc ';
			} else {
				$query = 'select m.*
					from #__djc2_payment_methods as m
					left join #__djc2_deliveries_payments as dp on dp.payment_id = m.id
					where m.published = 1 and dp.payment_id is null
					group by m.id order by m.ordering asc ';
			}
			
			$db->setQuery($query);
			$payment_methods = $db->loadObjectList('id');
			
			foreach($payment_methods as &$method) {
				$method->price = Djcatalog2HelperPrice::applyPriceRules($method->price, true, 'payment', $method, 'payment');
			}
			unset($method);
			
			$this->payment_methods[$delivery_method_id] = count($payment_methods) ? $payment_methods : array();
		}
		return $this->payment_methods[$delivery_method_id];
	}
	
	public function getPaymentMethod($payment_method_id) {
		$db = JFactory::getDbo();
		$db->setQuery('select * from #__djc2_payment_methods where id='.(int)$payment_method_id);
		$result = $db->loadObject();
		
		if ($result) {
			$params = new Registry();
			$params->loadString(trim($result->params), 'JSON');
			$result->params = $params;
		}
		
		return $result;
	}
	
	public function getDeliveryMethod($delivery_method_id) {
		$db = JFactory::getDbo();
		$db->setQuery('select * from #__djc2_delivery_methods where id='.(int)$delivery_method_id);
		$result = $db->loadObject();
		
		if ($result) {
			$params = new Registry();
			$params->loadString(trim($result->params), 'JSON');
			$result->params = $params;
		}
		
		return $result;
	}
	
	public function setOrderPaid($order, $notifyUser, $notifyAdmin, $statusComment = '') {
		$params = JComponentHelper::getParams('com_djcatalog2');
		$status = $params->get('cart_status_paid', 'P');
		if (trim($status) == '') {
			$status = 'P';
		}
		return $this->changeStatus($order, $status, $notifyUser, $notifyAdmin, $statusComment);	
	}
	
	public function changeStatus($order, $value, $notifyUser, $notifyAdmin, $statusComment = '') {
		if (empty($order->id)) {
			return false;
		}
		
		$oldStatus = $order->status;
		
		$dispatcher = JEventDispatcher::getInstance();
		$params = JComponentHelper::getParams('com_djcatalog2');
		$date = JFactory::getDate();
		$db = JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->update('#__djc2_orders');
		$query->set('status='.$db->quote($value));
		$query->where('id='.(int)$order->id);
		
		$attachments = array();
		
		$invoiceStatuses = (array)$params->get('cart_status_invoice', $this->invoiceStatuses);
		
		if (empty($order->invoice_number) && in_array($value, $invoiceStatuses)) {
			$paymentDate = (empty($order->payment_date) || $order->payment_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $order->payment_date;
			$serviceDate = (empty($order->service_date) || $order->service_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $order->service_date;
			
			$query = $db->getQuery(true);
			$query->update('#__djc2_orders');
			$query->set('status='.$db->quote($value));
			
			$query->set('payment_date='.$db->quote($paymentDate));
			$query->set('service_date='.$db->quote($serviceDate));
			
			$newInvoice = false;
			if ($params->get('cart_invoices')) {
				$invoiceDate = (empty($order->invoice_date) || $order->invoice_date == '0000-00-00 00:00:00') ? $date->toSql(true) : $order->invoice_date;
				
				//$invoiceNumber = $this->getNextInvoiceNumber($date);
				require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/invoice.php';
				$invoiceCounter = 0;
				$invoiceNumber = DJCatalog2HelperInvoice::getNext($invoiceCounter, $date, 'invoice');
				
				$query->set('invoice_counter='.$invoiceCounter);
				$query->set('invoice_number='.$db->quote($invoiceNumber));
				$query->set('invoice_date='.$db->quote($invoiceDate));
				
				$newInvoice = true;
			}
			
			$query->where('id='.(int)$order->id);
			$db->setQuery($query);
			
			if (!$db->execute()) {
				$this->setError($db->getErrorMsg());
				return false;
			}
			
			if ($newInvoice) {
				if ($params->get('cart_invoices_email', 0) && $order->want_invoice) {
					$pdf = DJCatalog2HelperInvoice::getPdfInvoice($order->id, 'invoice', false);
					if ($pdf) {
						$attachments[] = $pdf;
					}
				}
				
				DJCatalog2HelperInvoice::update($invoiceCounter, $date, 'invoice');
			}
			
			require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/subscription.php';
			$sub = new DJCatalog2Subscription();
			if ($sub->setSubscriptions($order)) {
				//$notifyUser = false;
			}
			
		} else {
			$query = $db->getQuery(true);
			$query->update('#__djc2_orders');
			$query->set('status='.$db->quote($value));
			$query->where('id='.(int)$order->id);
			$db->setQuery($query);
			
			if (!$db->execute()) {
				$this->setError($db->getErrorMsg());
				return false;
			}
		}
		
		$table = $this->getTable('Orders');
		
		if ($table->load((int)$order->id)) {
			$data = $table->getProperties();
			foreach ($data['items'] as $k=>$v) {
				$data['items'][$k] = JArrayHelper::fromObject($v);
			}
			
			// update stock information if necessary
			$updStock = 0;
			if ( ($value == 'W' || $value =='R')  && ($oldStatus != 'W' && $oldStatus != 'R') ) {
				$updStock = 1;
			} else if (($value != 'W' && $value != 'R') && ($oldStatus == 'W' || $oldStatus == 'R')) {
				$updStock = -1;
			}
			
			if ($updStock != 0) {
				foreach($data['items'] as $item) {
					if ($item['item_type'] != 'item' || $item['item_id'] == 0) continue;
					
					$quantity = $item['quantity'];
					if (!($quantity > 0.0000)) continue;
					
					$operation = ($updStock > 0) ? '+ '.(float)$quantity : '- ' .(float)$quantity;
					
					if ($item['combination_id'] == 0) {
						$db->setQuery('UPDATE #__djc2_items SET stock = stock '.$operation.' WHERE id='.(int)$item['item_id']);
						$db->execute();
					} else {
						$db->setQuery('UPDATE #__djc2_items_combinations SET stock = stock '.$operation.' WHERE id='.(int)$item['combination_id']);
						$db->execute();
					}
				}
			}
			
			$data['status_comment'] = $statusComment;
			
			$dispatcher->trigger('onDJC2AfterOrderStatusChange', array($data));
			
			return $this->sendStatusEmail($data, $notifyUser, $notifyAdmin, $attachments);
		}
		
		return true;
	}
	
	public function sendStatusEmail($order, $notifyUser, $notifyAdmin, $attachments = array())
	{
		$app = JFactory::getApplication();
		
		require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/html.php';
		require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/djcatalog2.php';
		require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/messenger.php');
		
		$params 	= JComponentHelper::getParams('com_djcatalog2');
		$config 	= JFactory::getConfig();
		
		$customerName = $order['firstname'].' '.$order['lastname'];
		if (!empty($order['company'])) {
			$customerName = $order['company'];
		}
		
		$statusObj = DJCatalog2HtmlHelper::getOrderStatus($order['status']);
		$msg_type = (!empty($statusObj) && !empty($statusObj->message_template)) ? $statusObj->message_template : 'order_status';
		
		$status = DJCatalog2HtmlHelper::getOrderStatusName($order['status']);
		$status_desc = DJCatalog2HtmlHelper::getOrderStatusInfo($order['status']);
		$orderLink = null;
		if ($app->isSite()) {
			$orderLink = JRoute::_(DJCatalogHelperRoute::getOrderRoute($order['id']).'&token='.$order['token'], true, (JUri::getInstance()->isSsl() ? 1 : -1));
		} else {
			require_once JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/route.php';
			$orderLink = DJCatalog2HelperSiteRoute::buildRoute('getOrderRoute', array($order['id']), '&token='.$order['token'], true);
		}
		
		if ($notifyAdmin) {
			$mailfrom	= $config->get('mailfrom');
			
			$contact_list = $params->get('contact_list', false);
			$recipient_list = array();
			if ($contact_list !== false) {
				$recipient_list = explode(PHP_EOL, $params->get('contact_list', ''));
			}
			
			$list_is_empty = true;
			foreach ($recipient_list as $r) {
				if (strpos($r, '@') !== false) {
					$list_is_empty = false;
					break;
				}
			}
			
			if ($list_is_empty) {
				$recipient_list[] = $mailfrom;
			}
			$recipient_list = array_unique($recipient_list);
			
			$adminMailopts = [
				'recipient_name' => $customerName,
				'order_number' => $order['order_number'],
				'order_status' => $status,
				'order_status_description' => $status_desc,
				'order_customer_data' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_customer', 'email/layouts'),
				'order_items' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_items', 'email/layouts'),
				'order_link' =>  $orderLink
			];
			
			foreach($recipient_list as $recipient) {
				$messenger = new DJCatalog2HelperMessenger();
				$messenger->notify($recipient, ['type' => 'order_status_admin'], $attachments, $adminMailopts );
			}
		}
		
		if ($notifyUser && strstr($order['email'], '@example.com') === false) {
			$mailopts = [
				'recipient_name' => $customerName,
				'order_number' => $order['order_number'],
				'order_status' => $status,
				'order_status_description' => $status_desc,
				'order_customer_data' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_customer', 'email/layouts'),
				'order_items' => DJCatalog2HtmlHelper::getThemeLayout($order, 'order_items', 'email/layouts'),
				'order_link' =>  $orderLink
			];
			
			$messenger = new DJCatalog2HelperMessenger();
			$messenger->notify($order['email'], ['type' => $msg_type], $attachments, $mailopts );
		}
		
		return true;
	}
	
	/*public function getNextInvoiceNumber($date = false) {
	 $db = JFactory::getDbo();
	 
	 if (!$date) {
	 $date = JFactory::getDate();
	 }
	 
	 $db->setQuery('select count(*) from #__djc2_orders where (invoice_date > 0 or (invoice_number IS NOT NULL and invoice_number != "")) and year(invoice_date) = '.$db->quote($date->format('Y')));
	 
	 $count = $db->loadResult();
	 $count++;
	 
	 $number = str_pad($count, 6, '0', STR_PAD_LEFT).'/'.$date->format("Y");
	 
	 return $number;
	 }*/
	
	public function repeatOrder($order) {
		$newOrder = JArrayHelper::fromObject($order);
		$newOrder['order_items'] = array();
		$order_items = $newOrder['items'];
		
		foreach($order_items as $pos => $rec) {
			foreach($rec as $k=>$v) {
				if ($k == 'order_id') {
					continue;
				}
				if (!isset($newOrder['order_items'][$k])) {
					$newOrder['order_items'][$k] = array();
				}
				
				$newVal = $v;
				if ($k == 'id') {
					$newVal = null;
				}
				
				$newOrder['order_items'][$k][] = $newVal;
			}
		}
		
		$newOrder['id'] = 0;
		$newOrder['recurring'] = 2;
		$newOrder['recurring_params'] = null;
		$newOrder['order_number']	 	= null;
		$newOrder['invoice_number'] 	= null;
		$newOrder['invoice_counter'] 	= null;
		$newOrder['proforma_number'] 	= null;
		$newOrder['proforma_counter'] 	= null;
		$newOrder['created_date'] 		= JFactory::getDate()->toSql(true);
		$newOrder['status'] = $newOrder['user_id'] ? 'A' : 'N';
		
		unset($newOrder['items']);
		unset($newOrder['transactions']);
		unset($newOrder['modified']);
		unset($newOrder['modified_by']);
		
		$this->setState($this->getName() . '.id', null);
		$this->setState($this->getName() . '.number', null);
		
		if ($this->save($newOrder) == false) {
			return false;
		}
		
		$newOrder['id'] = $this->getState('order.id');
		$newOrder['order_number'] = $this->getState('order.number');
		$newOrder['items'] = $order_items;
		
		$this->sendRecurringOrderEmail($newOrder);
		return true;
	}
	
	
	public function sendRecurringOrderEmail($data, $attachments = array())
	{
		$app		= JFactory::getApplication();
		$params 	= JComponentHelper::getParams('com_djcatalog2');
		$notifyOwners = (bool)($params->get('cart_query_notifyowners', 0) == '1');
		
		$user = JFactory::getUser();
		
		$mailfrom	= $app->getCfg('mailfrom');
		$fromname	= $app->getCfg('fromname');
		$sitename	= $app->getCfg('sitename');
		
		$vendors = Djcatalog2Helper::getVendors($user->id);
		
		$contact_list = $params->get('contact_list', false);
		$recipient_list = array();
		if ($contact_list !== false) {
			$recipient_list = explode(PHP_EOL, $params->get('contact_list', ''));
		}
		
		$list_is_empty = true;
		foreach ($recipient_list as $r) {
			if (strpos($r, '@') !== false) {
				$list_is_empty = false;
				break;
			}
		}
		
		if ($list_is_empty) {
			$recipient_list[] = $mailfrom;
		}
		
		if ($user->authorise('djcatalog2.salesman', 'com_djcatalog2')) {
			$recipient_list[] = $user->email;
		}
		
		if (count($vendors) > 0) {
			foreach($vendors as $vendor) {
				$recipient_list[] = $vendor->email;
			}
		}
		
		$recipient_list = array_unique($recipient_list);
		
		$subject = null;
		$admin_body = null;
		$client_body = null;
		
		$subject = JText::sprintf('COM_DJCATALOG2_EMAIL_NEW_ORDER_SUBJECT', $data['order_number'], $sitename);
		$admin_body = DJCatalog2HtmlHelper::getEmailTemplate($data, 'admin.order', $attachments);
		$client_body = DJCatalog2HtmlHelper::getEmailTemplate($data, 'order', $attachments);
		
		if (!$admin_body) {
			return false;
		}
		
		// Send admin's email first
		$mail = JFactory::getMailer();
		
		foreach ($recipient_list as $k=> $recipient) {
			$mail = JFactory::getMailer();
			$mail->addRecipient(trim($recipient));
			$mail->setSender(array($mailfrom, $fromname));
			$mail->addReplyTo($data['email'], $data['firstname'].' '.$data['lastname']);
			$mail->setSubject($subject . ' - '.$data['firstname'].' '.$data['lastname']);
			$mail->setBody($admin_body);
			$mail->isHtml(true);
			
			if (is_array($attachments) && count($attachments)) {
				foreach($attachments as $file) {
					$name = basename($file);
					$mail->addAttachment($file, $name);
				}
			}
			
			$admin_sent = $mail->Send() ? true : $admin_sent;
		}
		
		// Send an email to customer
		$mail = JFactory::getMailer();
		
		//$mail->addRecipient($mailfrom);
		$mail->addRecipient($data['email']);
		
		$mail->setSender(array($mailfrom, $fromname));
		$mail->setSubject($subject);
		$mail->setBody($client_body);
		$mail->isHtml(true);
		
		if (is_array($attachments) && count($attachments)) {
			foreach($attachments as $file) {
				$name = basename($file);
				$mail->addAttachment($file, $name);
			}
		}
		
		$mail->Send();
		
		return $admin_sent;
	}
}
