<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

require_once dirname(__FILE__).'/items.php';
require_once dirname(__FILE__).'/item.php';

class DJCatalog2ModelConfigurable extends JModelLegacy
{
	public function getItems() {
		$input = JFactory::getApplication()->input;
		
		$model = JModelLegacy::getInstance('Items', 'DJCatalog2Model', array('ignore_request' => true));
		$state = $model->getState();
		
		$model->setState('list.start', 0);
		$model->setState('list.limit', 0);
		$model->setState('filter.configurable', true);
		
		$id = $input->getInt('id');
		$cid = $input->getInt('cid');
	
		$item = null;
		if ($id > 0) {
			$item = $this->getItem($id);
			if (!empty($item)) {
				$cid = $item->cat_id;
			}
		}
		
		if ($cid > 0) {
			$model->setState('filter.category', $cid);
		}
		
		$items = $model->getItems();
		
		return $items;
	}
	
	public function getItem($id = null) {
		
		if (empty($id)) {
			$id = JFactory::getApplication()->input->getInt('id');
		}
		
		if (!$id) return false;
		
		$model = JModelLegacy::getInstance('Item', 'DJCatalog2Model', array('ignore_request' => true));
		$state = $model->getState();
		
		return $model->getItem($id);
	}
	
	public function getCategories($cid = null) {
		if (empty($id)) {
			$cid = JFactory::getApplication()->input->getInt('cid', 0);
		}
		
		$user	= JFactory::getUser();
		$groups	= $user->getAuthorisedViewLevels();
		$categories = Djc2Categories::getInstance(array('state'=>'1', 'access'=>$groups));
		
		$category = $categories->get($cid);
		if (empty($category)) {
			return false;
		}
		
		return $category->getChildren();
	}
	
	public function getConfiguration() {
		
	}
}