<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

// No direct access.
defined('_JEXEC') or die;

class Djcatalog2ModelAddress extends JModelAdmin
{
	protected $text_prefix = 'COM_DJCATALOG2';

	public function __construct($config = array()) {
		parent::__construct($config);
	}

	public function getTable($type = 'Addresses', $prefix = 'Djcatalog2Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_djcatalog2.address', 'address', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		return $form;
	}

	protected function loadFormData()
	{
		$data = JFactory::getApplication()->getUserState('com_djcatalog2.edit.address.data', array());

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}

	protected function preprocessForm(JForm $form, $data, $group = 'content') {

		if (!($form instanceof JForm))
		{
			$this->setError('JERROR_NOT_A_FORM');
			return false;
		}

		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');
		$user = JFactory::getUser();
		$language = JFactory::getLanguage();

		$delivery = array('company', 'address', 'city', 'postcode', 'country_id', 'state_id', 'phone');

		$paramSfx = 'orderfield';
		
		foreach ($delivery as $field) {
			// in case config is broken - using defaults from XML file
			if ($params->get('cart_'.$paramSfx.'_'.$field, false) === false) {
				continue;
			}

			if ($params->get('cart_'.$paramSfx.'_'.$field, '0') == '0') {
				$form->removeField($field);
			} else {
				if ($params->get('cart_'.$paramSfx.'_'.$field, '0') == '2') {
					$form->setFieldAttribute($field, 'required', 'required');
					$form->setFieldAttribute($field, 'class', $form->getFieldAttribute($field, 'class', '').' required');
				} else {
					$form->setFieldAttribute($field, 'required', false);

					$class = $form->getFieldAttribute($field, 'class', '');
					$class = str_replace('required', '', $class);

					$form->setFieldAttribute($field, 'class', $class);
				}
			}
		}
	}
	
	protected function canDelete($record)
	{
		$user = JFactory::getUser();
		
		return ($user->id == $record->user_id || parent::canDelete($record));
	}
	
	public function save($data) {
		
		$db = JFactory::getDbo();
		
		if (!empty($data['country_id'])) {
			$db->setQuery('select country_name from #__djc2_countries where id='.(int)$data['country_id']);
			$country = $db->loadResult();
			$data['country'] = $country ? $country : '';
		}
		
		if (!empty($data['state_id'])) {
			$db->setQuery('select name from #__djc2_countries_states where id='.(int)$data['state_id']);
			$state = $db->loadResult();
			$data['state'] = $state ? $state : '';
		}
				
		return parent::save($data);
	}
}