<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access'); 

$item = $displayData['item'];

$model = JModelLegacy::getInstance('Stocknotify', 'DJCatalog2Model', ['ignore_request' => true]);
$form = $model->getForm(['item_id'=>$item->id]);

$uri = JUri::getInstance();
$return = $uri->toString(array('scheme', 'host', 'port', 'path', 'query'));
if (!empty($displayData['return'])) {
	$return = $displayData['return'];
}

$type = isset($displayData['item_type']) ? $displayData['item_type'] : 'item';

if (empty($form)) return false;

?>

<div class="djc_low_stock_notification" data-itemid="<?php echo $item->id; ?>" data-type="<?php echo $type; ?>">
	<form action="<?php echo JRoute::_('index.php?option=com_djcatalog2&task=item.stocknotify');  ?>" method="post" class="djc_low_stock_notification--form form form-validate form-inline">
		<fieldset>
			<p class="djc_low_stock_notification--info"><?php echo JText::_('COM_DJCATALOG2_REQUEST_STOCK_AVAILABILITY_LEGEND'); ?></p>
			<div class="input-append djc_low_stock_notification--input">
				<?php echo $form->getInput('email'); ?>
				<button type="submit" class="btn btn-primary validate"><?php echo JText::_('COM_DJCATALOG2_REQUEST_STOCK_AVAILABILITY_BTN');?></button>
			</div>
		</fieldset>
		
		<input type="hidden" name="item_id" value="<?php echo $item->id; ?>" />
		<input type="hidden" name="item_type" value="<?php echo $type; ?>" />
		<input type="hidden" name="option" value="com_djcatalog2" />
		<input type="hidden" name="task" value="item.stocknotify" />
		<input type="hidden" name="return" value="<?php echo base64_encode($return)?>" />
		<?php echo JHtml::_( 'form.token' ); ?>
	</form>
</div>