<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$row = $displayData['item'];
$params = $displayData['params'];
$context = $displayData['context'];
$canVote = isset($displayData['can_vote']) ? $displayData['can_vote'] : true;

$notHidden = (isset($displayData['not_hidden'])) ? $displayData['not_hidden'] : false;

/**
 * Layout variables
 * -----------------
 * @var   string   $context  The context of the content being passed to the plugin
 * @var   object   &$row     The article object
 * @var   object   &$params  The article params
 * @var   integer  $page     The 'page' number
 * @var   array    $parts    The context segments
 * @var   string   $path     Path to this file
 */

$uri = clone JUri::getInstance();
$uri->setVar('hitcount', '0');

// Create option list for voting select box
$options = array();

for ($i = 1; $i < 6; $i++)
{
	$options[] = JHtml::_('select.option', $i, JText::sprintf('COM_DJCATALOG2_ITEM_VOTE_OPT', $i));
}

$ratingOnly = (bool)($params->get('product_rating') == '1');
$displayForm = (bool)($canVote && ($ratingOnly || $context == 'com_djcatalog2.item' || $context == 'com_djcatalog2.order_item'));
$style = ($notHidden && $canVote) ? '' : 'style="display: none"';

?>
<div class="djc_star_rating--vote" data-id="<?php echo $row->id; ?>" <?php echo $style; ?>>
<?php if ($displayForm) {?>
	<form method="post" action="<?php echo htmlspecialchars($uri->toString(), ENT_COMPAT, 'UTF-8'); ?>" class="form-inline form">
		<div class="control-group">
			<div class="controls">
				<span class="content_vote">
					<label class="unseen element-invisible" for="content_vote_<?php echo (int) $row->id; ?>"><?php echo JText::_('COM_DJCATALOG2_ITEM_VOTE_LBL'); ?></label>
					<?php echo JHtml::_('select.genericlist', $options, 'user_rating', null, 'value', 'text', '5', 'content_vote_' . (int) $row->id); ?>
				</span>
			</div>
		</div>
		
		<?php if ($ratingOnly == false) {?>
			<div class="control-group">
				<div class="controls">
					<textarea name="user_review" placeholder="<?php echo JText::_('COM_DJCATALOG2_REVIEW_CONTENT_PLACEHOLDER')?>"></textarea>
				</div>
			</div>
		<?php } ?>
		
		<div class="control-group">
			<div class="controls">
				<input class="btn btn-mini" type="submit" name="submit_vote" value="<?php echo JText::_('COM_DJCATALOG2_ITEM_VOTE_SUBMIT'); ?>" />
			</div>
		</div>
		<input type="hidden" name="task" value="item.vote" />
		<input type="hidden" name="hitcount" value="0" />
		<input type="hidden" name="option" value="com_djcatalog2" />
		<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
		<input type="hidden" name="url" value="<?php echo htmlspecialchars($uri->toString(), ENT_COMPAT, 'UTF-8'); ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
<?php } else {?>
	<a href="<?php echo JRoute::_(DJCatalog2HelperRoute::getItemRoute($row->slug, $row->catslug)); ?>" class="btn"><?php echo JText::_('COM_DJCATALOG2_ITEM_VOTE_LBL'); ?></a>
<?php } ?>
</div>
