<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$field = $displayData['field'];
$params = $displayData['params'];
$jsonData = json_encode($field->_variantData);
$item_id = $displayData['itemid'];
$fieldName = $field->cart_variant == 1 ? 'cart_field' : 'feature_field';

?>

<div class="control-group">
    <div class="control-label"><label><?php echo $field->name; ?></label></div>
    <div class="controls">
    	<?php if ($field->type == 'color' || $field->type == 'multicolor' || $field->type == 'radio') {?>
    		<?php $fieldsetClass = ($field->type == 'color' || $field->type == 'multicolor') ? 'djc_cartvariant_colors' : 'djc_cartvariant_radio'; ?>
            <fieldset djc-required="true">
                <div class="<?php echo $fieldsetClass; ?>" data-fieldid="<?php echo $field->id; ?>" data-combinations='<?php echo $jsonData; ?>'>
                    <?php $idx = 0;?>
                    <?php foreach ($field->_variantData->options as $option) { ?>
                        <?php if (!in_array($option, $field->_variantData->availableOptions)) { continue; } ?>
                        
                        <?php if ( $field->type == 'radio') {?>
							<?php 
							$optionCombinations = isset($field->_variantData->optionCombinations[$option]) ? $field->_variantData->optionCombinations[$option] : array();
							?>
							<label for="<?php echo 'djc_'. $item_id . '-' . $fieldName.'-'.$field->id.'-'.$idx; ?>" class="radio" tabindex="0">
								<input type="radio" value="<?php echo $option; ?>"  name="<?php echo $fieldName; ?>[<?php echo $field->id; ?>]" id="djc_<?php echo $item_id . '-' . $fieldName; ?>-<?php echo $field->id.'-'.$idx; ?>" data-fieldid="<?php echo $field->id; ?>" data-fieldoption="<?php echo $option; ?>" data-optioncombinations='<?php echo json_encode($optionCombinations); ?>' <?php if ($field->cart_variant == 1) echo 'class="has_combo"'; ?> />
								<span class="djc_cartvariant_radio">
									<span class="djc_cartvariant_radio-name"><?php echo $field->optionValues[$option]; ?></span>
								</span>
							</label>
						<?php } else {?>
							<?php
	                        $optionCombinations = isset($field->_variantData->optionCombinations[$option]) ? $field->_variantData->optionCombinations[$option] : array();
	                        $style = '';
	                        $description = '';
	                        $optionParams = $field->optionParams[$option];
	                        if ($optionParams->get('hexcode')) {
	                        	$style .= 'background-color: ' . $optionParams->get('hexcode').';';
	                        }
	                        if ($optionParams->get('file_name')) {
	                            $style .= 'background-image: url(\''.JUri::base(true) .'/media/djcatalog2/images/colors/'. $optionParams->get('file_name').'\');';
	                        }
	                        if ($style == '') {
	                            $style = 'background-color: #ccc; background-image: url(\''.JUri::base(true) .'/components/com_djcatalog2/themes/'.$params->get('theme', 'default').'/images/icon-no-color.png\')';
	                        }
	                        if ($optionParams->get('description')) {
	                        	$description = $optionParams->get('description');
	                        }
	                        ?>
	                        <label for="<?php echo 'djc_'. $item_id . '-' . $fieldName.'-'.$field->id.'-'.$idx; ?>" class="radio <?php echo ($description) ? 'hasTooltip' : ''; ?>" data-title="<?php echo htmlspecialchars($description); ?>" title="<?php echo htmlspecialchars($description); ?>" tabindex="0">
	                            <input type="radio" value="<?php echo $option; ?>"  name="<?php echo $fieldName; ?>[<?php echo $field->id; ?>]" id="djc_<?php echo $item_id . '-' . $fieldName; ?>-<?php echo $field->id.'-'.$idx; ?>" data-fieldid="<?php echo $field->id; ?>" data-fieldoption="<?php echo $option; ?>" data-optioncombinations='<?php echo json_encode($optionCombinations); ?>' <?php if ($field->cart_variant == 1) echo 'class="has_combo"'; ?> />
	                            <span class="djc_cartvariant_color">
									<span class="djc_cartvariant_color-bg" style="<?php echo $style; ?>">
									</span>
									<span class="djc_cartvariant_color-name"><?php echo $field->optionValues[$option]; ?></span>
								</span>
	                        </label>
						<?php } ?>
                        <?php $idx++; ?>
                    <?php } ?>
                </div>
            </fieldset>
        <?php } else { ?>
            <select djc-required="true" name="<?php echo $fieldName; ?>[<?php echo $field->id; ?>]" id="djc_<?php echo $item_id.'-'.$fieldName; ?>-<?php echo $field->id; ?>" data-fieldid="<?php echo $field->id; ?>" data-combinations='<?php echo $jsonData; ?>' <?php if ($field->cart_variant == 1) echo 'class="has_combo"'; ?> >
                <option value="" data-fieldid="<?php echo $field->id; ?>" data-fieldoption="" data-optioncombinations=''><?php echo JText::sprintf('COM_DJCATALOG2_OPTION_SELECT', $field->name); ?></option>
                <?php foreach ($field->_variantData->options as $option) { ?>
                    <?php if (!in_array($option, $field->_variantData->availableOptions)) { continue; } ?>
                    <?php $optionCombinations = isset($field->_variantData->optionCombinations[$option]) ? $field->_variantData->optionCombinations[$option] : array(); ?>
                    <option value="<?php echo $option?>" data-fieldid="<?php echo $field->id; ?>" data-fieldoption="<?php echo $option; ?>" data-optioncombinations='<?php echo json_encode($optionCombinations); ?>'><?php echo $field->optionValues[$option]; ?></option>
                <?php } ?>
            </select>
        <?php } ?>
    </div>
</div>
