<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$row = $displayData['item'];
$params = $displayData['params'];
$context = $displayData['context'];
$canVote = (bool)(!empty($displayData['can_vote']) );
$notHidden = (isset($displayData['not_hidden_reviews'])) ? $displayData['not_hidden_reviews'] : false;

$rating = (int) $row->rating;
$rcount = (int) $row->rating_count;

// Look for images in template if available
$starImageOn  = JHtml::_('image', 'system/rating_star.png', JText::_('COM_DJCATALOG2_ITEM_VOTE_STAR_ACTIVE'), null, true);
$starImageOff = JHtml::_('image', 'system/rating_star_blank.png', JText::_('COM_DJCATALOG2_ITEM_VOTE_STAR_INACTIVE'), null, true);

$img = '';

for ($i = 0; $i < $rating; $i++) {
	$img .= $starImageOn;
}

for ($i = $rating; $i < 5; $i++) {
	$img .= $starImageOff;
}

$ratingOnly = (bool)($params->get('product_rating') == '1');
$displayReviews = (bool)(!$ratingOnly && $context == 'com_djcatalog2.item' && $rcount > 0 && !empty($row->_reviews));

$style = ($notHidden) ? '' : 'style="display: none"';
?>
<div class="content_rating djc_star_rating">
	<?php if ($rcount) : ?>
		<p class="unseen element-invisible djc_star_rating--meta" itemprop="aggregateRating" itemscope itemtype="https://schema.org/AggregateRating">
			<?php echo JText::sprintf('COM_DJCATALOG2_ITEM_VOTE_USER_RATING', '<span itemprop="ratingValue">' . $rating . '</span>', '<span itemprop="bestRating">5</span>'); ?>
			<meta itemprop="ratingCount" content="<?php echo $rcount; ?>" />
			<meta itemprop="worstRating" content="1" />
		</p>
	<?php endif; ?>
	<p class="djc_star_rating--stars">
		<?php echo $img; ?>
		<?php if ($displayReviews) {?>
			&#160;<button class="btn btn-mini djc_star_rating--reviews-btn" data-id="<?php echo $row->id; ?>"><?php echo JText::_('COM_DJCATALOG2_RATNG_DISPLAY_REVIEWS_BTN')?></button>
		<?php } ?>
		<?php if ($canVote && $context == 'com_djcatalog2.item') {?>
			&#160;<button class="btn btn-mini djc_star_rating--vote-btn" data-id="<?php echo $row->id; ?>"><?php echo JText::_('COM_DJCATALOG2_RATNG_VOTE_FORM_BTN')?></button>
		<?php } ?>
	</p>
	<?php if ($displayReviews) { ?>
		<div class="djc_star_rating--reviews-wrap" data-id="<?php echo $row->id; ?>" <?php echo $style; ?> itemprop="review" itemscope itemtype="https://schema.org/Review">
			<?php foreach($row->_reviews as $review) {?>
				<?php $author = '<span itemprop="author">'.$review->author.'</span>'; ?>
				<?php $datetime = '<span itemprop="datePublished">'.Jhtml::_('date', $review->created, $params->get('date_format_datetime', 'd/m/Y H:i')).'</span>'; ?>
				<blockquote class="djc_star_rating--single-review">
					<?php 
					$img = '';
					for ($i = 0; $i < $review->rating; $i++) {
						$img .= $starImageOn;
					}
					for ($i = $review->rating; $i < 5; $i++) {
						$img .= $starImageOff;
					}
					?>
					<?php echo $img; ?>
					<p class="djc_star_rating--review-content" itemprop="reviewBody"><?php echo nl2br($review->review); ?></p>
					<small><?php echo JText::sprintf('COM_DJCATALOG2_ITEM_REVIEW_AUTHOR', $author); ?>, <?php echo JText::sprintf('COM_DJCATALOG2_ITEM_REVIEW_DATE', $datetime); ?></small>
					<meta itemprop="reviewRating" content="<?php echo $review->rating; ?>" />
					<meta itemprop="name" content="<?php echo htmlspecialchars($row->name, ENT_COMPAT, 'UTF-8'); ?>" />
				</blockquote>
			<?php } ?>
		</div>
	<?php } ?>
</div>
