<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined ('_JEXEC') or die('Restricted access');

$item = $displayData['item'];

$uri = JUri::getInstance();
$login_redirect = $uri->toString(array('scheme', 'host', 'port', 'path', 'query'));
if (isset($displayData['login_redirect'])) {
	$login_redirect = $displayData['login_redirect'];
}
$download_link = !empty($displayData['download_link']) ? $displayData['download_link'] : false;

$user = JFactory::getUser();
JFactory::getDocument()->addScript(JUri::base(true) . '/components/com_djcatalog2/assets/js/accesslogin.js');

?>
<div class="well" data-access-item="<?php echo $item->id; ?>">
	<div class="row-fluid">
		<div class="span4">
			<!-- Information about the limited access -->
			<?php 
			$layout = new JLayoutFile('com_djcatalog2.getaccess.info', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
			echo $layout->render(array('item' => $item, 'user' => $user));
			?>
		</div>
		
		<?php if ($download_link) {?>
			<div class="span8">
				<a href="<?php echo $download_link?>" class="btn btn-primary"><?php echo JText::_('COM_DJCATALOG2_DOWNLOAD_FILE_BTN'); ?></a>
			</div>
		<?php } else {?>
			<div class="span8">
				<div class="row-fluid">
					<div class="span3">
					<!-- Buy now button -->
					<?php 
					$layout = new JLayoutFile('com_djcatalog2.getaccess.buynow', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
					echo $layout->render(array('item' => $item, 'user' => $user));
					?>
					</div>
					
					<?php if ($user->guest) {?>
						<div class="span3">
						<!-- Login button / form-->
						<?php 
						$layout = new JLayoutFile('com_djcatalog2.getaccess.login', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
						echo $layout->render(array('item' => $item, 'user' => $user, 'login_redirect' => $login_redirect));
						?>
						</div>
						
						<div class="span6">
						<!-- Enter token to get access -->
						<?php 
						$layout = new JLayoutFile('com_djcatalog2.getaccess.token', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
						echo $layout->render(array('item' => $item, 'user' => $user, 'login_redirect' => $login_redirect));
						?>
						</div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
	</div>
</div>