<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

class Djcatalog2HelperUser {
	
	protected static $users = array();
	protected static $usersData = array();
	protected static $usersCustomFields = array();
	protected static $fieldsCache = array();
	
	protected static $fieldTypes = array('text' => array('text', 'textarea', 'html', 'file'), 'int' => array('select', 'radio', 'checkbox', 'multiselect', 'multicolor', 'color', 'bool'), 'date' => array('calendar'));
	
	protected static $jsIncluded = false;
	
	protected static $coreFields = array(
		'user_id' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_checkout',
				'in_query',
				'in_register',
				'in_profile',
				'client_type',
				'target_fieldset'
			)
		),
		'customer_group_id' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_checkout',
				'in_query',
				'client_type',
				'target_fieldset'
			)
		),
		'client_type' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'client_type',
				// client type used to be required on checkout pages for some reason, but I don't think it's necessary
				//'in_checkout',
				//'in_query',
				'target_fieldset'
			)
		),
		'email' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_checkout',
				'in_query',
				'in_register',
				'in_profile',
				'client_type',
				'target_fieldset'
			)
		),
		'firstname' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_checkout',
				'in_query',
				'client_type',
				'in_delivery',
				'target_fieldset'
			)
		),
		'lastname' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_checkout',
				'in_query',
				'client_type',
				'in_delivery',
				'target_fieldset'
			)
		),
		'company' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_delivery'
			)
		),
		'position' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'address' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_delivery',
				'target_fieldset'
			)
		),
		'city' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_delivery',
				'target_fieldset'
			)
		),
		'postcode' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_delivery',
				'target_fieldset'
			)
		),
		'country_id' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'state_id' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'vat_id' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'phone' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'fax' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'www' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'image' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				''
			)
		),
		'want_invoice' => array(
			'area' => array('djcatalog2profile'),
			'lock' => array(
				'in_delivery', 'in_register', 'in_profile', 'in_query', 'target_fieldset'
			)
		),
		'gdpr_agreement' => array(
			'area' => array('djcatalog2statements'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'gdpr_policy' => array(
			'area' => array('djcatalog2statements'),
			'lock' => array(
				'target_fieldset'
			)
		),
		'tos' => array(
			'area' => array('djcatalog2statements'),
			'lock' => array(
				'target_fieldset'
			)
		)
	);
	
	public static function getUserData($id, $area = '*', $translateVals = false) {
		$allFields = static::getUserFields($area);
		
		if (!isset(static::$usersData[$id])) {
			$db = JFactory::getDbo();
			
			$query = $db->getQuery(true);
			$query->select('u.*, cu.email, c.country_name, c.country_3_code, c.country_2_code, s.name as state_name');
			$query->from('#__djc2_users AS u');
			$query->join('left', '#__users AS cu ON cu.id=u.user_id');
			$query->join('left', '#__djc2_countries as c on c.id = u.country_id');
			$query->join('left', '#__djc2_countries_states as s on s.id = u.state_id');
			$query->where('user_id = '.(int) $id);
			$db->setQuery($query);
			$user = $db->loadAssoc();
			
			static::$usersData[$id] = $user;
		}
		
		$user = static::$usersData[$id];
		if (empty($user)) {
			return false;
		}
		// This is not J! User's ID, but our internal identifier
		$extraFields = static::getUserExtraFieldsData($user['id']);
		
		$data = array(
			'djcatalog2profile' => array(),
			'djcatalog2statements' => array()
		);
		
		foreach($allFields as $field) {
			if ($field->is_core) {
				$data[$field->target_fieldset][$field->alias] = (isset($user[$field->alias])) ? $user[$field->alias] : null;
			} else {
				if ($translateVals && !empty($extraFields[$field->id]['field_value'])) {
					if (is_array($extraFields[$field->id]['field_value'])) {
						$vals = array();
						foreach($extraFields[$field->id]['field_value'] as $optId) {
							if (isset($field->optionlist[$optId])) {
								$vals[] = $field->optionlist[$optId]->value;
							}
						}
						$data[$field->target_fieldset][$field->alias] = implode(', ', $vals);
					} else {
						$data[$field->target_fieldset][$field->alias] = $extraFields[$field->id]['field_value'];
					}
				} else {
					$data[$field->target_fieldset][$field->alias] = (isset($extraFields[$field->id])) ? $extraFields[$field->id]['field_value'] : null;
				}
			}
		}
		
		return $data;
	}
	
	public static function getUserExtraFieldsData($id) {
		if (!isset(static::$usersCustomFields[$id])) {
			$db = JFactory::getDbo();
			
			$query = $db->getQuery(true);
			$query->select('f.*');
			$query->from('#__djc2_users_extra_fields AS f');
			$query->select('CASE '
				.'WHEN (f.type=\'text\' OR f.type=\'textarea\' OR f.type=\'html\'  OR f.type=\'file\') '
				.'THEN vt.value '
				.'WHEN (f.type=\'calendar\') '
				.'THEN vd.value '
				.'WHEN (f.type=\'checkbox\' OR f.type=\'select\' OR f.type=\'multiselect\' OR f.type=\'radio\' OR f.type=\'color\' OR f.type=\'multicolor\' OR f.type=\'bool\') '
				.'THEN GROUP_CONCAT(vi.value SEPARATOR \'|\')'
				.'ELSE "" END AS field_value');
			$query->join('LEFT','#__djc2_users_extra_fields_values_text AS vt ON f.id=vt.field_id AND vt.item_id='.(int)$id);
			$query->join('LEFT','#__djc2_users_extra_fields_values_int AS vi ON f.id=vi.field_id AND vi.item_id='.(int)$id);
			$query->join('LEFT','#__djc2_users_extra_fields_values_date AS vd ON f.id=vd.field_id AND vd.item_id='.(int)$id);
			$query->where('f.is_core = 0');
			$query->group('f.id');
			$query->order('f.ordering asc');
			$db->setQuery($query);
			
			$data = $db->loadAssocList('id');
			foreach($data as $key => $field) {
				if (in_array($field['type'], static::$fieldTypes['int']) && $field['type'] != 'bool') {
					if (!empty($data[$key]['field_value'])) {
						$data[$key]['field_value'] = explode('|', $data[$key]['field_value']);
					} else {
						$data[$key]['field_value'] = array();
					}
				}
			}
			
			/*if (count($fields)) {
			 $fieldIds = array_keys($fields);
			 $db->setQuery('SELECT * FROM #__djc2_users_extra_fields_options WHERE field_id IN ('.implode(',', $fieldIds).') ORDER BY field_id ASC, ordering ASC');
			 $optionList = $db->loadObjectList();
			 foreach($fields as $field_id => &$field) {
			 foreach ($optionList as $optionRow) {
			 if ($optionRow->field_id == $field_id) {
			 if (!isset($field['optionlist'])) {
			 $field['optionlist'] = array();
			 }
			 $field['optionlist'][] = $optionRow;
			 }
			 }
			 }
			 unset($field);
			 } */
			
			static::$usersCustomFields[$id] = $data;
		}
		
		return static::$usersCustomFields[$id];
	}
	
	public static function getUserProfile($id = null) {
		$app = JFactory::getApplication();
		if ($id == null) {
			$juser = JFactory::getUser();
			$salesman = $juser->authorise('djcatalog2.salesman', 'com_djcatalog2');
			
			$id = ($salesman) ? $app->getUserState('com_djcatalog2.checkout.user_id', JFactory::getUser()->id) : JFactory::getUser()->id;
		}
		if (isset(self::$users[$id])) {
			return self::$users[$id];
		}
		
		$model_path = str_replace('/', DIRECTORY_SEPARATOR, '/components/com_users/models/profile.php');
		$route_path = str_replace('/', DIRECTORY_SEPARATOR, '/components/com_users/helpers/route.php');
		require_once JPATH_ROOT.$model_path;
		require_once JPATH_ROOT.$route_path;
		
		$user_model = JModelLegacy::getInstance('Profile', 'UsersModel', array('ignore_request'=>true));
		$user_model->setState('user.id', $id);
		
		$userData = $user_model->getData();
		
		$dispatcher = JEventDispatcher::getInstance();
		JPluginHelper::importPlugin('user');
		
		// Trigger the data preparation event.
		$results = $dispatcher->trigger('onContentPrepareData', array('com_users.profile', $userData));
		
		$db = JFactory::getDbo();
		
		$data = new stdClass();
		if (!empty($userData->djcatalog2profile)) {
			$data = $userData->djcatalog2profile;
			$data = JArrayHelper::toObject($data);
		}
		
		if (!isset($data->user_id)) {
			$data->user_id = $userData->id;
		}
		
		if (!isset($data->email)) {
			$data->email = $userData->email;
		}
		
		// define customer group
		if (!isset($data->customer_group_id)) {
			$data->customer_group_id = 0;
		}
		
		if (!$data->customer_group_id) {
			$authGroups = JFactory::getUser($id)->getAuthorisedGroups();
			if (count($authGroups)) {
				$query = $db->getQuery(true);
				$query->select('id');
				$query->from('#__djc2_customer_groups');
				$query->where('(user_group IN ('.implode(',', $authGroups).') OR is_default=1)');
				$query->order('ordering DESC');
				$db->setQuery($query, 0, 1);
				$matchingGroup = $db->loadResult();
				if ($matchingGroup > 0) {
					$data->customer_group_id = (int)$matchingGroup;
				}
			}
		}
		
		if (!isset($data->vat_id)) {
			$data->vat_id = '';
		}
		
		// define client type
		$params = JComponentHelper::getParams('com_djcatalog2');
		if (!isset($data->client_type) || ($data->client_type != 'R' && $data->client_type != 'W')) {
			$data->client_type = $params->get('default_client_type', 'R');
		}
		$vat_client_type = $params->get('default_client_type', 'R');
		
		$postData = $app->input->get('jform', array(), 'array');
		$postOrderData = (array)$app->getUserState('com_djcatalog2.order.data', array());
		
		if (!empty($postData) && isset($postData['djcatalog2profile'])) {
			if (isset($postData['djcatalog2profile']['vat_id'])) {
				$data->vat_id = $postData['djcatalog2profile']['vat_id'];
			}
			if (isset($postData['djcatalog2profile']['country_id'])) {
				$data->country_id = $postData['djcatalog2profile']['country_id'];
			}
			if (isset($postData['djcatalog2profile']['state_id'])) {
				$data->state_id = $postData['djcatalog2profile']['state_id'];
			}
		} else if (isset($postOrderData['djcatalog2profile'])) {
			if (isset($postOrderData['djcatalog2profile']['vat_id'])) {
				$data->vat_id = $postOrderData['djcatalog2profile']['vat_id'];
			}
			if (isset($postOrderData['djcatalog2profile']['country_id'])) {
				$data->country_id = $postOrderData['djcatalog2profile']['country_id'];
			}
			if (isset($postOrderData['djcatalog2profile']['state_id'])) {
				$data->state_id = $postOrderData['djcatalog2profile']['state_id'];
			}
		}
		
		//echo '<pre>' . print_r($postOrderData, true) . '</pre>'; die();
		$country = $state = false;
		
		$lang_code = $app->getUserState('com_djcatalog2.country', '');
		if($lang_code) {
			$db->setQuery('select * from #__djc2_countries where country_2_code='. $db->quote($lang_code));
			$country = $db->loadObject();
			
			if($country) {
				$data->country_id = $country->id;
			}
		} else if (!empty($data->country_id)) {
			$db->setQuery('select * from #__djc2_countries where id='.(int)$data->country_id);
			$country = $db->loadObject();
		}
		
		if (empty($country)) {
			$db->setQuery('select * from #__djc2_countries where is_default=1');
			$country = $db->loadObject();
			if ($country) {
				$data->country_id = $country->id;
				$data->country_name = $country->country_name;
				$data->country_3_code = $country->country_3_code;
				$data->country_2_code = $country->country_2_code;
				$data->country_eu = $country->is_eu;
			} else {
				$data->country_id = 0;
				$data->country_name = '*';
				$data->country_3_code = '';
				$data->country_2_code = '';
				$data->country_eu = false;
			}
		} else {
			$data->country_name = $country->country_name;
			$data->country_3_code = $country->country_3_code;
			$data->country_2_code = $country->country_2_code;
			$data->country_eu = $country->is_eu;
		}
		
		if (!empty($data->state_id)) {
			if ($data->country_id > 0) {
				$db->setQuery('select * from #__djc2_countries_states where id='.(int)$data->state_id.' AND country_id='.(int)$data->country_id);
			} else {
				$db->setQuery('select * from #__djc2_countries_states where id='.(int)$data->state_id);
			}
			$state = $db->loadObject();
		}
		
		if (empty($state)) {
			$data->state_id = 0;
			$data->state_name = '*';
		} else {
			$data->state_id = $state->id;
			$data->state_name = $state->name;
		}
		
		if ($data->vat_id && $data->country_eu) {
			//$data->client_type = (Djcatalog2Helper::isViesValid($data->vat_id, $data->country_2_code)) ? 'W' : 'R';
			$vat_client_type = (Djcatalog2Helper::isViesValid($data->vat_id, $data->country_2_code)) ? 'W' : 'R';
		}
		
		// define tax rules
		$tax_query = $db->getQuery(true);
		$tax_query->select('vrul.id as rule_id, vrul.name, vrat.*');
		$tax_query->from('#__djc2_vat_rules AS vrul');
		$tax_query->join('inner', '#__djc2_vat_rules_xref AS vx ON vx.rule_id = vrul.id');
		$tax_query->join('inner', '#__djc2_vat_rates AS vrat ON vx.rate_id = vrat.id');
		
		$tax_where = array();
		
		if ((int)$data->country_id > 0) {
			if ((int)$data->state_id > 0) {
				$tax_where[] = '(vrat.country_id='.(int)$data->country_id.' OR vrat.country_id=0) AND (vrat.state_id='.$data->state_id.' OR vrat.state_id=0)';
			} else {
				$tax_where[] = '(vrat.country_id='.(int)$data->country_id.' OR vrat.country_id=0) AND vrat.state_id=0';
			}
			//$tax_where[] = 'vrat.country_id='.(int)$data->country_id;
		} else {
			if ($data->state_id > 0) {
				$tax_where[] = 'vrat.country_id=0 AND (vrat.state_id = '.$data->state_id.' OR vrat.state_id=0)';
			} else {
				$tax_where[] = 'vrat.country_id=0 AND vrat.state_id=0';
			}
		}
		//$tax_where[] = '(vrat.client_type='.$db->quote('A').' OR vrat.client_type='.$db->quote($data->client_type).')';
		$tax_where[] = '(vrat.client_type='.$db->quote('A').' OR vrat.client_type='.$db->quote($vat_client_type).')';
		
		$tax_query->where($tax_where);
		
		$tax_query->order('vrat.client_type ASC, vrat.country_id ASC, vrat.state_id ASC');
		$db->setQuery($tax_query);
		
		$rules = $db->loadObjectList();
		//$app->enqueueMessage('<pre>'.print_r($rules,true).((string)$tax_query).'</pre>');
		$data->tax_rules = array();
		foreach($rules as $rule) {
			if (!isset($data->tax_rules[$rule->rule_id])) {
				$data->tax_rules[$rule->rule_id] = 0;
			}
			$data->tax_rules[$rule->rule_id] = $rule->value;
		}
		
		$userData->djcatalog2profile = $data;
		
		self::$users[$id] = $userData;
		return self::$users[$id] ;
	}
	
	public static function saveUserProfile($userId, $data, $area) {
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$userData = static::getUserData($userId, $area, false);
		$fields = static::getUserFields($area);
		
		$coreObj = new stdClass();
		$extraData = array();
		
		$coreObj->id = 0;
		$coreObj->user_id = $userId;
		$coreObj->modified = JFactory::getDate()->toSql();
		
		if ($area != 'register') {
			$db->setQuery('select * from #__djc2_users WHERE user_id='.$userId);
			$row = $db->loadObject();
			if (!empty($row)) {
				$coreObj = $row;
			}
		}
		
		foreach($fields as $field) {
			$value = null;
			if ((!isset($data[$field->target_fieldset]) || !isset($data[$field->target_fieldset][$field->alias])) && $field->type != 'bool') {
				if (!empty($userData) && isset($userData[$field->target_fieldset]) && isset($userData[$field->target_fieldset][$field->alias])) {
					$value = $userData[$field->target_fieldset][$field->alias];
				}
			} else {
				$value = $data[$field->target_fieldset][$field->alias];
			}
			
			if ($field->is_core) {
				$colName = $field->alias;
				$coreObj->$colName = $value;
			} else {
				$extraData[$field->id] = $value;
			}
		}
		
		if ($coreObj->id > 0) {
			if (!$db->updateObject('#__djc2_users', $coreObj, 'id', true))
			{
				throw new Exception($db->getErrorMsg());
			}
		} else {
			if (!$db->insertObject('#__djc2_users', $coreObj, 'id'))
			{
				throw new Exception($db->getErrorMsg());
			}
		}
		static::saveUserExtraFields($userId, $coreObj, $fields, $extraData);
		
		return true;
	}
	
	protected static function saveUserExtraFields($userId, $table, $fields, $data) {
		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_djcatalog2/tables');
		
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		$task = $app->input->getCmd('task');
		
		$non_empty_fields = array();
		
		if (!empty($data)) {
			foreach ($data as $k=>$v) {
				if (!empty($v) || (is_string($v) && trim($v) != '')) {
					$non_empty_fields[] = (int)$k;
				}
			}
		}
		
		$non_empty_fields = array_unique($non_empty_fields);
		$non_empty_fields_ids = implode(',', $non_empty_fields);
		
		if (count($non_empty_fields) > 0) {
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__djc2_users_extra_fields_values_text');
			$query->where('item_id ='.$table->id.' and field_id not in ('.$non_empty_fields_ids.')');
			$db->setQuery($query);
			$db->execute();
			
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__djc2_users_extra_fields_values_int');
			$query->where('item_id ='.$table->id.' and field_id not in ('.$non_empty_fields_ids.')');
			$db->setQuery($query);
			$db->execute();
			
			
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__djc2_users_extra_fields_values_date');
			$query->where('item_id ='.$table->id.' and field_id not in ('.$non_empty_fields_ids.')');
			$db->setQuery($query);
			$db->execute();
		}
		
		
		if (empty($data)) {
			return true;
		}
		
		$query = $db->getQuery(true);
		$query->select('ef.*');
		$query->from('#__djc2_users_extra_fields as ef');
		if (trim($non_empty_fields_ids) != '') {
			$query->where('ef.id in ('.$non_empty_fields_ids.')');
		}
		$db->setQuery($query);
		
		$attribs = $db->loadObjectList();
		
		$itemId = $table->id;
		$rows = array();
		
		$text_types = static::$fieldTypes['text'];
		$int_types = static::$fieldTypes['int'];
		$date_types = static::$fieldTypes['date'];
		
		foreach ($attribs as $k=>$v) {
			$fv_table = null;
			$type_table_name = null;
			$table_type = null;
			if (in_array($v->type, $text_types)) {
				$fv_table = JTable::getInstance('UsersFieldValuesText', 'Djcatalog2Table', array());
				$type_table_name = '#__djc2_users_extra_fields_values_text';
				$table_type = 'text';
			} else if (in_array($v->type, $int_types)) {
				$fv_table = JTable::getInstance('UsersFieldValuesInt', 'Djcatalog2Table', array());
				$type_table_name = '#__djc2_users_extra_fields_values_int';
				$table_type = 'int';
			} else if (in_array($v->type, $date_types)) {
				$fv_table = JTable::getInstance('UsersFieldValuesDate', 'Djcatalog2Table', array());
				$type_table_name = '#__djc2_users_extra_fields_values_date';
				$table_type = 'date';
			} else {
				continue;
			}
			$fieldId = $v->id;
			if (array_key_exists($fieldId, $data) && isset($data[$fieldId])) {
				// add/alter data
				$value = null;
				$id = null;
				
				if (is_array($data[$fieldId])) {
					$db->setQuery('
								SELECT id
								FROM '.$type_table_name.'
								WHERE
									item_id='.(int)$itemId.'
									AND field_id='.$fieldId. ' order by id '
						);
					$values = $db->loadColumn();
					$count = (count($values) > count($data[$fieldId])) ? count($values) : count($data[$fieldId]);
					for ($i = 0; $i < $count; $i++) {
						if (isset($data[$fieldId][$i])) {
							$id = null;
							if (isset($values[$i])) {
								$id = $values[$i];
							}
							
							$rows[] = array(
								'id'=>$id,
								'item_id'=>$itemId,
								'field_id'=>$fieldId,
								'value' => $data[$fieldId][$i],
								'type' => $table_type
							);
						} else {
							$db->setQuery('
							DELETE
							FROM '.$type_table_name.'
							WHERE id='.(int)$values[$i]
								);
							$db->execute();
						}
					}
					
				} else {
					if ($v->type == 'html') {
						$data[$fieldId] = JComponentHelper::filterText($data[$fieldId]);
						$data[$fieldId] = preg_replace('/&(?![A-Za-z0-9#]{1,7};)/','&amp;',$data[$fieldId]);
					} else if ($v->type == 'file') {
						$fData = json_decode($data[$fieldId]);
						$tmp = [];
						foreach($fData as $file) {
							$upFile =  static::prepareUploadedFile($file);
							$tmp[] = $upFile;
						}
						$data[$fieldId] = json_encode($tmp);
					}
					
					if ($fv_table->load(array('item_id'=>$itemId,'field_id'=>$fieldId))) {
						$id = $fv_table->id;
					}
					$rows[] = array(
						'id'=>$id,
						'item_id'=>$itemId,
						'field_id'=>$fieldId,
						'value' => $data[$fieldId],
						'type' => $table_type
					);
				}
				
			} else if ($task != 'import'){
				// remove data
				$db->setQuery('
							DELETE
							FROM '.$type_table_name.'
							WHERE
								field_id='.(int)$fieldId.'
								AND item_id='.(int)$itemId
					);
				$db->execute();
			}
		}
		
		foreach ($rows as $key=>$row) {
			$fv_table = null;
			if (isset($row['type'])) {
				if ($row['type'] == 'text' || $row['type'] == 'int' || $row['type'] == 'date') {
					$fv_table = JTable::getInstance('UsersFieldValues'.ucfirst($row['type']), 'Djcatalog2Table', array());
					unset($row['type']);
				} else{
					continue;
				}
			} else {
				continue;
			}
			
			// Load the row if saving an existing record.
			if ($row['id'] > 0) {
				$fv_table->load($row['id'], true);
			}
			
			// Bind the data.
			if (!$fv_table->bind($row)) {
				return false;
			}
			// Check the data.
			if (!$fv_table->check()) {
				return false;
			}
			
			// Store the data.
			if (!$fv_table->store()) {
				return false;
			}
			
		}
		
		return true;
	}
	
	public static function prepareExtraFields($data, $area, $toJson = false) {
		$fields = static::getUserFields($area);
		
		$parsed = array();
		foreach($data as $set => $attrs) {
			$tmpSet = array();
			foreach($fields as $field) {
				if ($field->is_core == 1) continue;
				foreach($attrs as $field_alias => $attribute) {
					if ($field->alias != $field_alias) continue;
					//$tmpSet[$field->id][] = $attribute;
					$tmpSet[$field->id] = static::prepareExtraField($field, $attribute);
				}
			}
			if (count($tmpSet)) {
				$parsed[$set] = $tmpSet;
			}
		}
		
		return ($toJson) ? json_encode($parsed) : $parsed;
	}
	
	public static function prepareExtraField($field, $data) {
		$info = array('field' => $field->name, 'alias' => $field->alias, 'value' => $data, 'value_text' => $data);
		if (in_array($field->type, static::$fieldTypes['int'])) {
			if (is_array($data)) {
				$tmp = array();
				foreach($data as $opt) {
					if (!empty($field->optionlist[$opt])) {
						$tmp[] = $field->optionlist[$opt]->value;
					}
				}
				$info['value_text'] = implode(', ', $tmp);
			} else {
				$info['value_text'] = isset($field->optionlist[$data]) ? $field->optionlist[$data]->value : null;
			}
		}
		
		return $info;
	}
	
	public static function getCoreFields($keys_only = false) {
		return $keys_only ? array_keys(static::$coreFields) : static::$coreFields;
	}
	
	public static function getUserFields($area = '*') {
		if (!isset(static::$fieldsCache[$area])) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('f.*');
			$query->from('#__djc2_users_extra_fields AS f');
			
			switch($area) {
				case 'register': {
					$query->where('in_register > 0');
					break;
				}
				case 'profile': {
					$query->where('in_profile > 0');
					break;
				}
				case 'checkout': {
					$query->where('in_checkout > 0');
					break;
				}
				case 'query': {
					$query->where('in_query > 0');
					break;
				}
			}
			
			$query->order('f.ordering ASC');
			$db->setQuery($query);
			
			$fields = $db->loadObjectList('id');
			
			if (count($fields)) {
				$fieldIds = array_keys($fields);
				$db->setQuery('SELECT * FROM #__djc2_users_extra_fields_options WHERE field_id IN ('.implode(',', $fieldIds).') ORDER BY field_id ASC, ordering ASC');
				$optionList = $db->loadObjectList('id');
				
				foreach($fields as $field_id => $field) {
					foreach ($optionList as $optionRow) {
						if ($optionRow->field_id == $field_id) {
							if (empty($field->optionlist)) {
								$fields[$field_id]->optionlist = array();
							}
							$fields[$field_id]->optionlist[$optionRow->id] = $optionRow;
						}
					}
				}
			}
			
			static::$fieldsCache[$area] = $fields;
		}
		return static::$fieldsCache[$area];
	}
	
	protected static function getFormArea($formName) {
		$area = '*';
		if ($formName == 'com_admin.profile') {
			$area = 'profile';
		} else if ($formName == 'com_users.user' || $formName == 'com_users.profile') {
			$area = 'profile';
		} else if ($formName == 'com_users.registration') {
			$area = 'register';
		} else if ($formName == 'com_djcatalog2.checkout') {
			$area = 'checkout';
		}
		else if ($formName == 'com_djcatalog2.query') {
			$area = 'query';
		}
		
		return $area;
	}
	
	public static function getUserFormXML($formName, $data) {
		static::includeFormScripts();
		$area = static::getFormArea($formName);
		
		$fields = static::getUserFields($area);
		
		$content = JFile::read(JPATH_ROOT.'/components/com_djcatalog2/models/forms/userprofile.xml');
		$xml =  new SimpleXMLElement($content);
		
		$profileSet = $xml->xpath('/form/fields[@name="djcatalog2profile"]/fieldset')[0];
		$statementsSet = $xml->xpath('/form/fields[@name="djcatalog2statements"]/fieldset')[0];
		
		$tempSets = array();
		$tempSets['djcatalog2profile'] =  clone $profileSet;
		$tempSets['djcatalog2statements'] =  clone $statementsSet;
		
		unset($profileSet->field);
		unset($statementsSet->field);
		
		$hasClientType = false;
		foreach($fields as $field) {
			if ($field->alias == 'client_type') {
				$hasClientType = true;
				break;
			}
		}
		
		foreach($fields as $field) {
			$visibility = 1;
			if ($area != '*') {
				//$tmp = 'in_'.$area;
				$visibility = $field->{'in_'.$area};
			}
			if ($visibility == 0) continue;
			
			$append = null;
			if ($field->target_fieldset == 'djcatalog2profile') {
				$append = $profileSet->addChild('field');
			} else if ($field->target_fieldset == 'djcatalog2statements') {
				$append = $statementsSet->addChild('field');
			} else {
				continue;
			}
			
			if ($field->is_core) {
				foreach($tempSets[$field->target_fieldset] as $coreField) {
					if ((string)$coreField['name'] == $field->alias) {
						foreach($coreField->attributes() as $k=>$v) {
							if ($k == 'required' || $k == 'type') {
								continue;
							}
							$append->addAttribute($k, $v);
						}
						
						$type = $field->type;
						$typePos = strpos($type, ':');
						if ($typePos !== false) {
							$type = substr($type, (int)$typePos+1);
						}
						
						$append->addAttribute('type', $type);
						
						$children = (array)$coreField->xpath('option');
						
						if (!empty($children)) {
							foreach($children as $option) {
								$value = (string) $option['value'];
								$text  = trim((string) $option) != '' ? trim((string) $option) : $value;
								
								$opt = $append->addChild('option', $text);
								$opt->addAttribute('value', $value);
							}
						}
						if ($visibility == 2) {
							$append->addAttribute('required', 'true');
						}
						
						static::prepareField($append, $field);
						
						break;
					}
				}
			} else {
				$ftype = static::translateFieldType($field->type);
				$append->addAttribute('name', $field->alias);
				$append->addAttribute('label', $field->label);
				$append->addAttribute('type', $ftype);
				
				if ($visibility == 2) {
					$append->addAttribute('required', 'true');
				}
				
				$append->addAttribute('default', '');
				
				if (!empty($field->optionlist)) {
					if ($field->type == 'select') {
						$opt = $append->addChild('option', '--');
						$opt->addAttribute('value', '');
					}
					foreach($field->optionlist as $option) {
						$opt = $append->addChild('option', $option->value);
						$opt->addAttribute('value', $option->id);
					}
				}
				
				if ($ftype == 'djcplupload') {
					$append->addAttribute('download', 'true');
					$append->addAttribute('can_delete', 'true');
					$append->addAttribute('download_key', 'fullname');
					$append->addAttribute('caption', 'false');
					$append->addAttribute('multiple_files', 'false');
					$append->addAttribute('limit', '1');
					$append->addAttribute('download_url', JUri::root(false). '/index.php?option=com_djcatalog2&task=users.download_file');
				}
				
				static::prepareField($append, $field);
			}
			
			if ($field->client_type != 'A' && $hasClientType) {
				$showon = 'client_type:'.$field->client_type;
				$append->addAttribute('showon', $showon);
			}
		}
		
		if ($area != '*') {
			$method = 'onGetUserForm' . ucfirst($area);
			if (method_exists('Djcatalog2HelperUser', $method)) {
				static::$method($xml, $data, $fields);
			}
		}
		//echo $xml->asXml();die();
		return $xml->asXml();
	}
	
	protected static function onGetUserFormProfile(&$xml, &$data, $fields) {
		static::onGetUserFormRegister($xml, $data, $fields);
	}
	protected static function onGetUserFormRegister(&$xml, &$data, $fields) {
		$toRemove = ['djcatalog2delivery', 'djcatalog2message', 'djcatalog2orderdetails', 'djcatalog2captcha'];
		foreach($toRemove as $fieldset) {
			$fieldsetFields = $xml->xpath('/form/fields[@name="'.$fieldset.'"]');
			foreach($fieldsetFields as $element) {
				if ($element instanceof SimpleXMLElement) {
					$dom = dom_import_simplexml($element);
					$dom->parentNode->removeChild($dom);
				}
			}
		}
	}
	protected static function onGetUserFormCheckout(&$xml, &$data, $fields) {
		
		//$deliveryFields = $xml->xpath('/form/fields[@name="djcatalog2delivery"]/fieldset')[0];
		$deliveryFields = $xml->xpath('/form/fields[@name="djcatalog2delivery"]/fieldset/field');
		foreach($deliveryFields as $deliveryField) {
			$fieldName = (string)$deliveryField['name'];
			if ($field = static::findFieldByName($fieldName, $fields)) {
				$visibility = $field->in_checkout;
				if ($visibility == 2 && $field->client_type == 'A') {
					$deliveryField['required'] = 'true';
				} else if ($visibility == 1) {
					//$deliveryField['required'] = 'false';
					unset($deliveryField['required']);
				}
				static::prepareField($deliveryField, $field);
			} else if (isset(static::$coreFields[$fieldName])) {
				$dom = dom_import_simplexml($deliveryField);
				$dom->parentNode->removeChild($dom);
			}
		}
		
		$allFields = $xml->xpath('/form/fields/fieldset/field');
		foreach($allFields as $field) {
			if ((string)$field['type'] == 'djcplupload' || (string)$field['type'] == 'file') {
				$dom = dom_import_simplexml($field);
				$dom->parentNode->removeChild($dom);
			}
		}
	}
	protected static function onGetUserFormQuery(&$xml, &$data, $fields) {
		$allFields = $xml->xpath('/form/fields/fieldset/field');
		foreach($allFields as $field) {
			if ((string)$field['type'] == 'djcplupload' || (string)$field['type'] == 'file') {
				$dom = dom_import_simplexml($field);
				$dom->parentNode->removeChild($dom);
			}
		}
	}
	
	protected static function prepareField(&$xmlField, $field) {
		if (trim($field->label) != '') {
			$xmlField['label'] = $field->label;
		}
		if (trim($field->description) != '') {
			$xmlField['description'] = $field->description;
		}
		if (trim($field->placeholder) != '') {
			$xmlField['hint'] = $field->placeholder;
		}
		if (trim($field->attributes) != '') {
			$attributes = JUtility::parseAttributes($field->attributes);
			foreach($attributes as $attr => $val) {
				$xmlField[$attr] = $val;
			}
		}
	}
	
	protected static function findFieldByName($name, &$fields) {
		foreach ($fields as $field) {
			if ($field->alias === $name) {
				return $field;
			}
		}
		return false;
	}
	
	public static function prepareFormValidation(&$form, $data) {
		$area = static::getFormArea($form->getName());
		$fields = static::getUserFields($area);
		
		$hasClientType = !empty($data['djcatalog2profile']['client_type']);
		$clientType = $hasClientType ? $data['djcatalog2profile']['client_type'] : 'A';
		
		foreach($fields as $field) {
			//foreach($form->getXml()->xpath('/form/fields[@name="djcatalog2profile"]//field[@name="'.$field->alias.'"]') as $xmlField) {
			$visibility = 1;
			if ($area != '*') {
				$visibility = $field->{'in_'.$area};
			}
			if ($visibility == 0) {
				$form->removeField($field->alias, $field->target_fieldset);
				continue;
			}
			if ($hasClientType && $clientType != 'A' && $field->client_type != $clientType && $field->client_type != 'A') {
				$form->removeField($field->alias, $field->target_fieldset);
				continue;
				//$form->setFieldAttribute($field->alias, 'disabled', 'disabled', $field->target_fieldset);
				//$form->setFieldAttribute($field->alias, 'required', null, $field->target_fieldset);
			}
			//}
		}
	}
	
	public static function preprocessOrderForm($form, $data) {
		$user_data = false;
		if (is_object($data)) {
			$user_data = isset($data->additional_user_data) ? $data->additional_user_data : false;
		} else if (is_array($data)) {
			$user_data = isset($data['additional_user_data']) ? $data['additional_user_data'] : false;
		}
		
		$fields = static::getUserFields('checkout');
		if (!$user_data || empty($data)) {
			// dirty workaround in order to bypass validator
			foreach($fields as $field) {
				if ($field->is_core) continue;
				$type = $field->type == 'textarea' ? 'textarea' : 'text';
				$element = new SimpleXMLElement('<field filter="string" name="'.htmlspecialchars($field->alias).'" type="'.htmlspecialchars($type).'" label="'.htmlspecialchars($field->name).'" />');
				$form->setField($element, null, false, 'customer');
			}
		} else {
			foreach($user_data as $set => $values ) {
				foreach($values as $field) {
					$extraField = static::findFieldByName($field['alias'], $fields);
					if (!empty($extraField)) {
						$type = $extraField->type == 'textarea' ? 'textarea' : 'text';
						$element = new SimpleXMLElement('<field name="'.htmlspecialchars($extraField->alias).'" type="'.htmlspecialchars($type).'" label="'.htmlspecialchars($extraField->label).'" value="" />');
					} else {
						$element = new SimpleXMLElement('<field name="'.htmlspecialchars($field['alias']).'" class="readonly" readonly="readonly" type="'.htmlspecialchars($type).'" label="'.htmlspecialchars($field['field']).'" />');
					}
					$form->setField($element, null, false, 'customer');
				}
			}
		}
	}
	
	public static function preprocessQueryForm($form, $data) {
		$user_data = false;
		if (is_object($data)) {
			$user_data = isset($data->additional_user_data) ? $data->additional_user_data : false;
		} else if (is_array($data)) {
			$user_data = isset($data['additional_user_data']) ? $data['additional_user_data'] : false;
		}
		
		$fields = static::getUserFields('query');
		if (!$user_data || empty($data)) {
			// dirty workaround in order to bypass validator
			foreach($fields as $field) {
				if ($field->is_core) continue;
				$type = $field->type == 'textarea' ? 'textarea' : 'text';
				$element = new SimpleXMLElement('<field filter="string" name="'.$field->alias.'" type="'.$type.'" label="'.$field->name.'" />');
				$form->setField($element, null, false, 'customer');
			}
		} else {
			foreach($user_data as $set => $values ) {
				foreach($values as $field) {
					$extraField = static::findFieldByName($field['alias'], $fields);
					if (!empty($extraField)) {
						$type = $extraField->type == 'textarea' ? 'textarea' : 'text';
						$element = new SimpleXMLElement('<field name="'.$extraField->alias.'" type="'.$type.'" label="'.$extraField->label.'" value="" />');
					} else {
						$element = new SimpleXMLElement('<field name="'.$field['alias'].'" class="readonly" readonly="readonly" type="'.$type.'" label="'.$field['field'].'" />');
					}
					$form->setField($element, null, false, 'customer');
				}
			}
		}
	}
	
	protected static function translateFieldType($custom_type) {
		$typePos = strpos($custom_type, ':');
		if ($typePos !== false) {
			return substr($custom_type, (int)$typePos+1);
		}
		
		if ($custom_type == 'select') {
			return 'list';
		} else if ($custom_type == 'checkbox') {
			return 'checkboxes';
		} else if ($custom_type == 'bool') {
			return 'checkbox';
		} else if ($custom_type == 'file') {
			return 'djcplupload';
		} else if ($custom_type == 'html') {
			return 'editor';
		}
		return $custom_type;
	}
	
	protected static function prepareUploadedFile($file) {
		if ($file->file_id) return $file;
		
		require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/file.php');
		
		$source = JPath::clean(JPATH_ROOT . '/media/djcatalog2/tmp/'.$file->fullname);
		$destination = JPath::clean( JPATH_ROOT.'/media/djcatalog2/files/userfiles' );
		
		if (!JFolder::exists($destination)) {
			JFolder::create($destination, 0755);
		}
		
		$ext = JFile::getExt($file->fullname);
		$newName = $file->caption.'.' . $file->id . '.' . $ext;
		$newName = JString::strtolower(DJCatalog2FileHelper::createFileName($newName, $destination));
		$newPath = $destination . '/' . $newName;
		
		if (JFile::copy($source, $newPath)) {
			$file->file_id = md5($file->id.':'.$file->caption.':'.$file->fullname);
			$file->fullname = $newName;
			$file->url = 'media/djcatalog2/files/userfiles/'.$newName;
			$file->size = filesize($newPath);
			$file->path = 'media/djcatalog2/files/userfiles';
			$file->fullpath = $file->path.'/'.$file->fullname;
			
			$file->hash = md5($newName . ':' .$file->size);
			
			return $file;
		}
		
		return false;
	}
	
	public static function includeFormScripts() {
		$document = JFactory::getDocument();
		if ($document instanceof JDocumentHtml && static::$jsIncluded == false) {
			$js = '
				(function($){
					$(document).ready(function(){
						function toggleRequiredShowOns() {
							var elms = $("[data-custom-required]");
							$(elms).each(function(){
								var element = $(this);
								if (element.is(":visible")) {
									element.addClass("required").attr("required", "required").attr("aria-required", "true");
									element.attr("required", "required");
								} else {
									element.removeClass("required").removeAttr("required").removeAttr("aria-required");
									element.removeAttr("disabled");
								}
							});
						}
				
						var custShowOns = $("form").find("[data-showon]");
						$(custShowOns).each(function(){
							var wrapper = $(this);
							var required = wrapper.find(".required");
							required.attr("data-custom-required", "required");
						});
				
						toggleRequiredShowOns();
				
						var showOnFields = $("form").find("input,select,radio");
						$(showOnFields).change(function(){
							setTimeout(function(){toggleRequiredShowOns();}, 600);
						});
					});
				})(jQuery);
			';
			$document->addScriptDeclaration($js);
			
			static::$jsIncluded = true;
		}
	}
	
	public static function getUserOrders($user_id = null) {
		if (is_null($user_id)) {
			$user_id = JFactory::getUser()->id;
		}
		
		if (!(int)$user_id) return false;
		
		$params = JComponentHelper::getParams('com_djcatalog2');
		$invoiceStatuses = (array)$params->get('cart_status_invoice', array('C', 'P', 'F'));
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('o.*');
		$query->from('#__djc2_orders AS o');
		$query->where('o.user_id='. (int)$user_id);
		if (count($invoiceStatuses)) {
			$orStatuses = [];
			foreach ($invoiceStatuses as $status) {
				$orStatuses[] = 'o.status = ' . $db->quote($status);
			}
			$query->where('( '. implode(' OR ', $orStatuses) .' )');
		}
		$db->setQuery($query);
		$rows = $db->loadObjectList('id');
		
		$data = ['orders'=> [], 'items' => []];
		$data['orders'] = $rows;
		
		if (count($rows)) {
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__djc2_order_items');
			$query->where('order_id IN ('.implode(',' , array_keys($rows)).')');
			$db->setQuery($query);
			
			$order_items = $db->loadObjectList();
			$data['items'] = $order_items;
			
			foreach($data['items'] as &$order_item) {
				if (!isset($data['orders'][$order_item->order_id]->items)) {
					$data['orders'][$order_item->order_id]->items = array();
				}
				$data['orders'][$order_item->order_id]->items[] = $order_item;
			}
			unset($order_item);
		}
		
		return $data;
	}
	
	public static function getOrdersByToken($token) {
		if (trim($token) == '') {
			return false;
		}
		
		$params = JComponentHelper::getParams('com_djcatalog2');
		$invoiceStatuses = (array)$params->get('cart_status_invoice', array('C', 'P', 'F'));
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('o.*');
		$query->from('#__djc2_orders AS o');
		$query->where('o.token='. $db->quote($token));
		if (count($invoiceStatuses)) {
			$orStatuses = [];
			foreach ($invoiceStatuses as $status) {
				$orStatuses[] = 'o.status = ' . $db->quote($status);
			}
			$query->where('( '. implode(' OR ', $orStatuses) .' )');
		}
		$db->setQuery($query);
		$rows = $db->loadObjectList('id');
		
		$data = ['orders'=> [], 'items' => []];
		$data['orders'] = $rows;
		
		if (count($rows)) {
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__djc2_order_items');
			$query->where('order_id IN ('.implode(',' , array_keys($rows)).')');
			$db->setQuery($query);
			
			$order_items = $db->loadObjectList();
			$data['items'] = $order_items;
			
			foreach($data['items'] as &$order_item) {
				if (!isset($data['orders'][$order_item->order_id]->items)) {
					$data['orders'][$order_item->order_id]->items = array();
				}
				$data['orders'][$order_item->order_id]->items[] = $order_item;
			}
			unset($order_item);
		}
		
		return $data;
	}
}