<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined('_JEXEC') or die('Restricted access');


class DJCatalog2Subscription extends JObject {
    protected static $userCache = array();
	
	public function setSubscriptions($order) {
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		$query = $db->getQuery(true);
		$query->select('o.item_id, o.item_name, o.quantity, o.sku');
		$query->select('i.expiration, i.grant_usergroups, i.product_type, i.sku as item_sku');
		$query->from('#__djc2_order_items AS o');
		$query->join('inner', '#__djc2_items AS i ON i.id=o.item_id');
		$query->where('o.order_id = '.(int)$order->id);
		$query->where('i.product_type=' . $db->quote('subscription'));
		$db->setQuery($query);
		
		$items = $db->loadObjectList();
		
		// exit if no subscription products in order
		if(empty($items)) return true;
		
		if (!$order->user_id) {
			return false;
		}
		
		// get current user groups
		$db->setQuery('SELECT group_id FROM #__user_usergroup_map WHERE user_id='.$order->user_id);
		$groups = $db->loadColumn();
		
		$grant_groups = array();
		$nullDate	= $db->getNullDate();
		$nowDate	= JFactory::getDate()->toSql();
		
		$table = JTable::getInstance('Subscriptions', 'Djcatalog2Table');
        
        $subscriptions = array();
		
		// generate subscriptions to add to the database
		foreach($items as $item) {
			if ($item->product_type == 'subscription') {
				for($i=0; $i<$item->quantity; $i++) {
					// we need to reset the table for each item
					$table->reset();
					
					$additional_days = 0;
					
					$table->expire_date = $item->expiration ? JFactory::getDate('+'.($item->expiration + $additional_days).' days')->toSql() : $nullDate; // expire_date
					
					$table->id = 0;
					$table->user_id = $order->user_id;
					$table->item_id = $item->item_id;
					$table->item_name = $item->item_name;
					$table->start_date = $nowDate; // start_date
					$table->order_id = $order->id;
					$table->granted_usergroups = $item->grant_usergroups;
	                
	                $user = self::getUser($order->user_id);
					
	                $item_groups = json_decode($item->grant_usergroups);
	                JArrayHelper::toInteger($item_groups);
	                if (!empty($item_groups)) {
						$grant_groups[] = $item_groups;
	                }
	                
					// insert subscriptions to database
					if(!$table->store()) {
						$this->setError($table->getError());
						return false;
					}
					$tblProps = $table->getProperties(true);
					$subscriptions[] = JArrayHelper::toObject($tblProps, 'JObject');
				}
			}
		}
		
		// remove duplicated groups
		$grant_groups = array_unique($grant_groups);
		
		// we need to make sure we won't add groups the user is assigned already 
		foreach($grant_groups as $key => $group) {
			if(in_array($group, $groups)) unset($grant_groups[$key]);
		}
		
		// grant user groups
		if(count($grant_groups)) {
			
			$db->setQuery('INSERT INTO #__user_usergroup_map (user_id, group_id) VALUES ('.$order->user_id.', '.implode('),('.$order->user_id.',', $grant_groups).')');
			
			if (!$db->execute()) {
				$this->setError($db->getErrorMsg());
				return false;
			}
		}
		
		foreach($subscriptions as $subscription) {
			$app->triggerEvent('onDJC2SubscriptionActivation', array($subscription));
		}
		
        if (count($subscriptions)) {
            $this->_sendSubscriptionEmail($order, $subscriptions);
        }
		
		return true;
	}
	
	public static function notifyExpiring() {
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$threshold = (int)$params->get('subscription_expiry_threshold', 3);
		$db = JFactory::getDBO();
		
		$nowDate = $db->quote(JFactory::getDate()->toSql());
		
		if ($threshold > 0) {
			$currentDate = JFactory::getDate();
			$interval = new DateInterval('P'.$threshold.'D');
			$nextDate = $db->quote($currentDate->add($interval)->toSql());
			$backDate = $db->quote($currentDate->sub($interval)->toSql());
			
			$query = $db->getQuery(true);
			$query->select('s.user_id, s.granted_usergroups as usergroups');
			$query->from('#__djc2_subscriptions as s');
			$query->where('s.expiry_notified=0 AND s.status=1 AND s.expire_date >= '.$nowDate.' AND s.expire_date < '.$nextDate);
			$query->group('s.user_id, s.granted_usergroups');
			
			$db->setQuery($query);
			$expiring = $db->loadObjectList();
			
			$expiringUsers = array();
			foreach($expiring as $exp) {
				$expiringUsers[] = $exp->user_id;
			}
			
			if (count($expiring) && count($expiringUsers)) {
				$expiringUsers = array_unique($expiringUsers);
				
				$query = $db->getQuery(true);
				$query->select('s.user_id, s.granted_usergroups as usergroups');
				$query->from('#__djc2_subscriptions as s');
				$query->where('s.expiry_notified=0 AND s.status=1 AND s.expire_date >= '.$nextDate.' AND s.user_id IN ('.implode(',', $expiringUsers).')');
				$query->group('s.user_id, s.granted_usergroups');
				$db->setQuery($query);
				$expiringActive = $db->loadObjectList();
				
				if(count($expiringActive)) {
					foreach($expiring as $key => $exp) {
						foreach($expiringActive as $sub) {
							if($sub->user_id == $exp->user_id && $sub->usergroups == $exp->usergroups) {
								// there is active subscription related with the same set of usergroups as expired one
								// we can't remove usergroup assingment
								unset($expiring[$key]);
							}
						}
					}
				}
			}
			
			
			if (count($expiring)) {
				foreach($expiring as $sub) {
					$query = $db->getQuery(true);
					$query->select('s.*, u.name as user_name, u.email, u.username as userlogin');
					$query->from('#__djc2_subscriptions as s');
					$query->join('inner', '#__users as u ON u.id=s.user_id');
					//$query->where('s.user_id = '.$sub->user_id.' AND s.granted_usergroup='.$sub->usergroup);
					$query->where('s.user_id = '.$sub->user_id.' AND s.granted_usergroups='.$db->quote($sub->usergroups));
					$query->where('s.expiry_notified=0 AND s.status=1 AND s.expire_date < '.$nextDate);
					
					$db->setQuery($query);
					$notifications = $db->loadObjectList();
					
					$sub_ids = array();
					
					foreach($notifications as $subData) {
						$sub_ids[] = $subData->id;
						self::_sendExpirationEmail('expire_soon', $subData);
					}
					$db->setQuery('UPDATE #__djc2_subscriptions SET expiry_notified=1 WHERE id IN ('.implode(',', $sub_ids).')');
					if (!$db->execute()) {
						//$this->setError($db->getErrorMsg());
						return false;
					}
				}
			}
			
		}
		
		return true;
	}
	
	public static function checkExpirations() {
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$db = JFactory::getDBO();
		$nowDate = $db->quote(JFactory::getDate()->toSql());
		
		static::notifyExpiring();
		
		// get expired subscriptions grouped by user and granted usergroup
		$db->setQuery('SELECT id, user_id, granted_usergroups as usergroups FROM #__djc2_subscriptions WHERE status=1 AND expire_date <= '.$nowDate.' GROUP BY id, user_id, granted_usergroups');
		$expired = $db->loadObjectList();
		
		if (empty($expired)) {
			return;
		}
		
		// get active subscriptions grouped by user and granted usergroup
		$db->setQuery('SELECT user_id, granted_usergroups as usergroups FROM #__djc2_subscriptions WHERE status=1 AND expire_date > '.$nowDate.' GROUP BY user_id, granted_usergroups');
		$active = $db->loadObjectList();
		
		$sub_ids = array();
		foreach($expired as $key => $exp) {
			$unset = false;
			if (!isset($sub_ids[$exp->user_id])) {
				$sub_ids[$exp->user_id] = array();
			}
			
			if(count($active)) {
				foreach($active as $sub) {
					if($sub->user_id == $exp->user_id && $sub->usergroups == $exp->usergroups) {
						// there is active subscription related with the same usergroup as expired one
						// we can't remove usergroup assingment
						unset($expired[$key]);
						$unset = true;
					}
				}
			}
			
			if (!$unset) {
				$sub_ids[$exp->user_id][] = $exp->id;
			}
		}
		
		$where = array();
		foreach($expired as $exp) {
			$groups = ($exp->usergroups != '' && $exp->usergroups != '[]') ? json_decode($exp->usergroups) : false;
			if ($groups) {
				foreach($groups as $group) {
					$where[] = '(user_id='.$exp->user_id.' AND group_id='.(int)$group.')';
				}
			}
		}
		
		// remove user-group assigments
		$db->setQuery('DELETE from #__user_usergroup_map WHERE '.implode(' OR ', $where));
		if (!$db->execute()) {
			//$this->setError($db->getErrorMsg());
			return false;
		}
		
		// set status for expired subscriptions
		$db->setQuery('UPDATE #__djc2_subscriptions SET status=0 WHERE status=1 AND expire_date <= '.$nowDate);
		if (!$db->execute()) {
			//$this->setError($db->getErrorMsg());
			return false;
		}
		
		foreach ($expired as $sub) {
			$query = $db->getQuery(true);
			$query->select('s.*, u.name as user_name, u.email, u.username as user_login');
			$query->from('#__djc2_subscriptions as s');
			$query->join('inner', '#__users as u ON u.id=s.user_id');
			$query->where('s.user_id = '.$sub->user_id.' AND s.granted_usergroups='.$sub->usergroups);
			if (!empty($sub_ids[$sub->user_id])) {
				$query->where('s.id IN ('.implode(',', $sub_ids[$sub->user_id]).')');
			}
			
			$db->setQuery($query);
			$notifications = $db->loadObjectList();
			foreach($notifications as $subData) {
				$app->triggerEvent('onDJC2SubscriptionExpiry', array($sub));
				self::_sendExpirationEmail('expired', $subData);
			}
		}
		
		return true;
	}

    public static function getUser($user_id) {
        $user_id = (int)$user_id;
        
        if (!$user_id) {
            return false;
        }
        if (!isset(self::$userCache[$user_id])) {
            $db = JFactory::getDbo();
            $db->setQuery('select * from #__users where id='.$user_id);
            self::$userCache[$user_id] = $db->loadObject();
        }
        return self::$userCache[$user_id];
    }

    protected static function _sendExpirationEmail($type, $subscriptionData) {
    	require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/messenger.php');
    	
    	$types = array('expire_soon', 'expired');
    	$params = JComponentHelper::getParams('com_djcatalog2');
    	
    	if (!in_array($type, $types) || empty($subscriptionData)) {
    		return;
    	}
    	
    	$mailopts = [
    		'recipient_name' => $subscriptionData->user_name,
    		'subscription_item' => $subscriptionData->item_name,
    		'start_date' => JHtml::_('date', $subscriptionData->start_date, $params->get('date_format_date', 'd/m/Y')),
    		'expiration_date' => JHtml::_('date', $subscriptionData->expire_date, $params->get('date_format_date', 'd/m/Y'))
    	];
    	
    	$messenger = new DJCatalog2HelperMessenger();
    	$messenger->notify($subscriptionData->email, ['type' => 'subscription_' . $type], [], $mailopts );
    	
    	return true;
    }
    
    protected function _sendSubscriptionEmail($order, $subscriptions)
    {
    	require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/html.php';
    	require_once JPATH_ROOT.'/components/com_djcatalog2/helpers/djcatalog2.php';
    	require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/messenger.php');
    	
    	if (!count($subscriptions)) {
    		return;
    	}
    	
    	$user = self::getUser($order->user_id);
    	
    	if (empty($user)) {
    		return false;
    	}
    	
    	$data = array('user' => $user, 'subscriptions' => $subscriptions);
    	
    	$mailopts = [
    		'recipient_name' => $user->username,
    		'subscription_items' => DJCatalog2HtmlHelper::getThemeLayout($data, 'subscription_items', 'email/layouts'),
    	];
    	
    	$messenger = new DJCatalog2HelperMessenger();
    	$messenger->notify($user->email, ['type' => 'subscription_new'], [], $mailopts );
    	
    	return true;
    }
}