<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

class Djcatalog2HelperRating {
	/**
	 * 
	 * @param mixed $item object/$item's ID
	 * @return boolean
	 */
	public static function canVote($item) {
		$item_id = null;
		if (is_numeric($item)) {
			$item_id = $item;
		} else if (is_object($item)) {
			$item_id = $item->id;
		} else {
			return false;
		}
		
		$user = JFactory::getUser();
		$params = JComponentHelper::getParams('com_djcatalog2');
		$access_cfg = $params->get('access_product_rating', 'any');
		
		if ($access_cfg == 'any') return true;
		
		if ($user->guest) return false;
		
		if ($access_cfg == 'customer') {
			$invoiceStatuses = (array)$params->get('cart_status_invoice',  array('C', 'P', 'F'));
			
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('count(*)');
			$query->from('#__djc2_order_items AS oi');
			$query->join('inner', '#__djc2_orders AS o ON o.id = oi.order_id');
			//$query->join('left', '#__djc2_item_reviews AS ir ON ir.user_id = o.user_id AND ir.item_id = oi.item_id');
			$query->where('oi.item_id = '.(int)$item_id.' AND oi.item_type=' . $db->quote('item'));
			$query->where('o.user_id=' . (int)$user->id);
			
			if (count($invoiceStatuses)) {
				$wheres=[];
				foreach ($invoiceStatuses as $status) {
					$wheres[] = 'o.status = ' . $db->quote($status);
				}
				
				$query->where('( '.implode(' OR ', $wheres).' )');
			}
			
			$db->setQuery($query);
			$purchases = $db->loadResult();
			if ($purchases > 0) {
				$query = $db->getQuery(true);
				$query->select('count(*)')->from('#__djc2_item_reviews')->where('user_id= ' . (int)$user->id)->where('item_id=' . $item_id);
				$db->setQuery($query);
				$rated = $db->loadResult();
				if ($rated) return false;
			}
			
			return (bool)$purchases;
		}
		
		return false;
	}
}