<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

class DJCatalog2HelperQuantity {
	
	static $loaded = false;
	static $units = array();
	
	public static function getUnit($unit_id) {
		if (static::$loaded == false) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('*')->from('#__djc2_units')->order('is_default DESC, ordering ASC');
			$db->setQuery($query);
			
			static::$units = $db->loadObjectList('id');
			static::$loaded = true;
			
			if (count(static::$units) == 0) {
				static::$units = array(static::createGenericUnit());
			}
		}
		
		// first unit is default
		if ($unit_id == 0 || !isset(static::$units[$unit_id])) {
			foreach(static::$units as $k=>$v) {
				$unit_id = $k;
				break;
			}
		}
		
		/*if (!isset(static::$units[$unit_id])) {
			return false;
		}*/
		
		return static::$units[$unit_id];
	}
	
	protected static function createGenericUnit() {
		$unit = new stdClass();
		
		$unit->id = 0;
		$unit->name = (JText::_('COM_DJCATALOG2_UNIT_PC') != 'COM_DJCATALOG2_UNIT_PC') ? JText::_('COM_DJCATALOG2_UNIT_PC') : 'Piece';
		$unit->unit = 'pc';
		$unit->is_int = true;
		$unit->min_quantity = 1;
		$unit->max_quantity = 0;
		$unit->step = 1;
		$unit->show_box = 1;
		$unit->show_buttons = 1;
		$unit->show_unit = false;
		$unit->unit_type = 'other';
		
		return $unit;
	}
	
	public static function validateQuantity($quantity, $unit, $itemType = 'item') {
		if (!is_numeric($quantity)) {
			return false;
		}
		
		if (is_numeric($unit)){
			$unit = static::getUnit($unit);
		}
		

		$quantity = ($unit->is_int) ? intval($quantity) : floatval($quantity);
		$app = JFactory::getApplication();

        if (static::getPrec($quantity) < static::getPrec($unit->min_quantity) || $quantity <= 0.0000) {
            $app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_QUANITITY_BELOW_MIN', $unit->min_quantity), 'warning');
            return $unit->min_quantity > 0.0000 ? $unit->min_quantity : ($unit->step > 0.0000 ? $unit->step : 1);
        } else if (static::getPrec($quantity) > static::getPrec($unit->max_quantity) && $unit->max_quantity > 0.0000) {
            $app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_QUANITITY_ABOVE_MAX', $unit->max_quantity), 'warning');
            return $unit->max_quantity;
        }
		
		if (static::setPrec($unit->step) > 0) {
			$stepQty = static::getPrec(floatval($unit->min_quantity));
			$step = static::getPrec($unit->step);
			$quantity = static::getPrec($quantity);
			while ( $stepQty < $quantity ) {
				$stepQty += $step;
			}
			return $unit->is_int ? static::setPrec($stepQty) : number_format(static::setPrec($stepQty), 4);
		}
		
		return $quantity;
	}
	
	public static function renderInput($unit, $item, $options = array()) {
		$layout = new JLayoutFile('com_djcatalog2.quantity', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
		return $layout->render(array('unit' => $unit, 'item' => $item, 'options' => $options));
	}
	
	public static function formatAmount($quantity, $params) {
		$decSep = null;
		$thSep = null;
		
		switch($params->get('thousand_separator',0)) {
			case 0: $thSep=''; break;
			case 1: $thSep=' '; break;
			case 2: $thSep='\''; break;
			case 3: $thSep=','; break;
			case 4: $thSep='.'; break;
			default: $thSep=''; break;
		}
		
		switch($params->get('decimal_separator',0)) {
			case 0: $decSep=','; break;
			case 1: $decSep='.'; break;
			default: $decSep=','; break;
		}
		
		if ((float)((int)$quantity) != (float)$quantity) {
			
			// reducing number of zeroes after dec point
			$precision = 0;
			$multiplier = 10;
			$tmp = $quantity;
			while ((int)$tmp != $tmp && $precision <= 4) {
				$tmp = $quantity * $multiplier;
				$multiplier *= 10;
				$precision++;
			}
			
			return number_format($quantity, $precision, $decSep, $thSep);
		}
		
		return number_format($quantity, 0, $decSep, $thSep);
	}
	
	/**
	 * Convert Weigth Unit
	 *
	 * @author Valérie Isaksen
	 */
	static function convertWeigthUnit ($value, $from, $to) {
		if (is_numeric($from)) {
			$unit = static::getUnit($from);
			if (!empty($unit) && $unit->unit_type == 'weight') {
				$from = $unit->unit;
			}
		}
		
		if (is_numeric($to)) {
			$unit = static::getUnit($to);
			if (!empty($unit) && $unit->unit_type == 'weight') {
				$to = $unit->unit;
			}
		}
		
		$from = strtoupper($from);
		$to = strtoupper($to);
		$value = str_replace (',', '.', $value);
		if ($from === $to) {
			return $value;
		}
		
		$g = 0.0000;
		
		switch ($from) {
			case 'KG':
				$g = (float)(1000 * $value);
				break;
			case 'G':
				$g = (float)$value;
				break;
			case 'MG':
				$g = (float)($value / 1000);
				break;
			case 'LB':
				$g = (float)(453.59237 * $value);
				break;
			case 'OZ':
				$g = (float)(28.3495 * $value);
				break;
		}
		switch ($to) {
			case 'KG' :
				$value = (float)($g / 1000);
				break;
			case 'G' :
				$value = $g;
				break;
			case 'MG' :
				$value = (float)(1000 * $g);
				break;
			case 'LB' :
				$value = (float)($g / 453.59237);
				break;
			case 'OZ' :
				$value = (float)($g / 28.3495);
				break;
		}

		return (float)$value;
	}
	
	/**
	 * Convert Metric Unit
	 *
	 * @author Florian Voutzinos
	 */
	static function convertDimensionUnit ($value, $from, $to) {
		if (is_numeric($from)) {
			$unit = static::getUnit($from);
			if (!empty($unit) && $unit->unit_type == 'length') {
				$from = $unit->unit;
			}
		}
		
		if (is_numeric($to)) {
			$unit = static::getUnit($to);
			if (!empty($unit) && $unit->unit_type == 'length') {
				$to = $unit->unit;
			}
		}
		
		$from = strtoupper($from);
		$to = strtoupper($to);
		$value = (float)str_replace (',', '.', $value);
		if ($from === $to) {
			return $value;
		}
		
		$meter = 1 * $value;
		
		// transform $value in meters
		switch ($from) {
			case 'CM':
				$meter = (float)(0.01 * $value);
				break;
			case 'MM':
				$meter = (float)(0.001 * $value);
				break;
			case 'YD':
				$meter = (float)(1.0936 * $value);
				break;
			case 'FT':
				$meter = (float)(3.28083 * $value);
				break;
			case 'IN':
				$meter =(float) (39.37 * $value);
				break;
		}
		switch ($to) {
			case 'CM' :
				$value = (float)($meter * 0.01);
				break;
			case 'MM' :
				$value = (float)($meter * 0.001);
				break;
			case 'YD' :
				$value =(float) ($meter * 0.9144);
				break;
			case 'FT' :
				$value = (float)($meter * 0.3048);
				break;
			case 'IN' :
				$value = (float)($meter * 0.0254);
				break;
		}
		return (float)$value;
	}
	
	protected static function getPrec($number) {
		return round($number*10000);
	}
	
	protected static function setPrec($number) {
		return $number/10000;
	}
}
