<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

class DJCatalog2HelperInvoice {
	
	static $invoice_path = JPATH_ROOT . '/media/djcatalog2/export/invoices';
	
	public static function getNext(&$invoiceCounter, $date = false, $type='invoice') {
		$params = JComponentHelper::getParams('com_djcatalog2');
		$formatTpl = $params->get('cart_invoice_format', '{no}/{year}');
		
		if (!$date) {
			$date = JFactory::getDate();
		}
		
		$count = static::getCandidate($date, $type);
		
		$number = str_pad($count, 6, '0', STR_PAD_LEFT);
		$format = str_replace('{no}', $number, $formatTpl);
		$format = str_replace('{year}', $date->format('Y'), $format);
		$format = str_replace('{month}', $date->format('m'), $format);
		$format = str_replace('{day}', $date->format('d'), $format);
		
		$invoiceCounter = $count;
		
		return $format;
	}
	
	public static function getCandidate($date, $type = 'invoice') {
		$db = JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->select('counter')->from('#__djc2_inv_counters');
		$query->where('year = '.$db->quote($date->format('Y')));
		$query->where('doctype=' . $db->quote($type));
		$db->setQuery($query);
		
		$count = $db->loadResult();
		
		if (!is_numeric($count) && !$count) {
			$count = 0;
			$query = $db->getQuery(true);
			$query->insert('#__djc2_inv_counters');
			$query->columns(array('year', 'counter', 'doctype'));
			$query->values($db->quote($date->format('Y')).', 0, ' . $db->quote($type));
			$db->setQuery($query);
			$db->execute();
		}
		
		$count++;
		return $count;
	}
	
	public static function update($counter, $date, $type = 'invoice') {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->update('#__djc2_inv_counters');
		$query->set('counter='.($counter));
		$query->where('year='.$db->quote($date->format('Y')));
		$query->where('doctype=' . $db->quote($type));
		$db->setQuery($query);
		return $db->execute();
	}
	
	public static function updateYear($counter, $year, $type = 'invoice') {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->update('#__djc2_inv_counters');
		$query->set('counter='.($counter));
		$query->where('year='.$db->quote((int)$year));
		$query->where('doctype=' . $db->quote($type));
		$db->setQuery($query);
		return $db->execute();
	}
	
	public static function getPdfInvoice($order_id, $layout = 'invoice', $stream = false) {
		$libfile = JPATH_LIBRARIES . '/tcpdf/tcpdf.php';
		if (JFile::exists($libfile) == false) {
			return false;
		}
		require_once $libfile;
		
		$path = static::$invoice_path;
		
		if (!JFolder::exists($path)) {
			JFolder::create($path);
		}
		
		if (!is_writable($path)) {
			return false;
		}
		
		$model = JModelLegacy::getInstance('Order', 'DJCatalog2Model', array('ignore_request' => true));
		$order = $model->getItem($order_id);
		
		if (empty($order) || empty($order->id)) {
			return false;
		}
		
		$filename = $layout;
		if ($layout == 'invoice' && !empty($order->invoice_number)) {
			$filename .= '-' . $order->invoice_number;
		} else if ($layout == 'proforma' && !empty($order->proforma_number)) {
			$filename .= '-' . $order->proforma_number;
		} else {
			$filename .= '-' . $order->order_number;
		}
		
		$filename = JFile::makeSafe($filename) . '.pdf';
		
		error_reporting(0);
		@ini_set('display_errors', 0);
		
		$pdf = new TCPDF();
		
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->setFontSubsetting(true);
		
		$pdf->SetFont('freesans', '', 9, '', true);
		$pdf->SetPrintHeader(false);
		$pdf->SetPrintFooter(true);
		$pdf->SetFooterMargin('15px');
		
		$pdf->AddPage();
		$pdf->_intCurPage = 1;
		$pdf->_intFootNo = $order->invoice_number;
		
		$html = DJCatalog2HtmlHelper::getThemeLayout($order, $layout, 'pdf');
		
		$pdf->writeHTML($html, true, false, true, false, '');
		
		if ($stream) {
			$pdf->Output($filename, 'D');
			JFactory::getApplication()->close();
		} else {
			$pdf->Output($path.'/'.$filename, 'F');
			return JPath::clean($path.'/'.$filename);
		}
	}
	
	public static function getPdfQuery($query_id, $layout = 'invoice', $stream = false) {
		$libfile = JPATH_LIBRARIES . '/tcpdf/tcpdf.php';
		if (JFile::exists($libfile) == false) {
			return false;
		}
		require_once $libfile;
		
		$path = static::$invoice_path;
		
		if (!JFolder::exists($path)) {
			JFolder::create($path);
		}
		
		if (!is_writable($path)) {
			return false;
		}
		
		$model = JModelLegacy::getInstance('Query', 'DJCatalog2Model', array('ignore_request' => true));
		$query = $model->getItem($query_id);
		
		if (empty($query) || empty($query->id)) {
			return false;
		}
		
		$filename = $layout.'-'.$query_id;
		$filename = JFile::makeSafe($filename) . '.pdf';
		
		error_reporting(0);
		@ini_set('display_errors', 0);
		
		$pdf = new TCPDF();
		
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->setFontSubsetting(true);
		
		$pdf->SetFont('freesans', '', 9, '', true);
		$pdf->SetPrintHeader(false);
		$pdf->SetPrintFooter(true);
		$pdf->SetFooterMargin('15px');
		
		$pdf->AddPage();
		$pdf->_intCurPage = 1;
		$pdf->_intFootNo = $query->id;
		
		$html = DJCatalog2HtmlHelper::getThemeLayout($query, $layout, 'pdf');
		
		$pdf->writeHTML($html, true, false, true, false, '');
		
		if ($stream) {
			$pdf->Output($filename, 'D');
			JFactory::getApplication()->close();
		} else {
			$pdf->Output($path.'/'.$filename, 'F');
			return JPath::clean($path.'/'.$filename);
		}
	}
}