<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');

class Djcatalog2HelperDownload {
	
	public static function canDownload($fileId, $user) {
		$app		= JFactory::getApplication();
		$user		= JFactory::getUser();
		$db			= JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->select('i.id, i.created_by, f.access, i.product_type');
		$query->from('#__djc2_items AS i');
		$query->join('inner', '#__djc2_files AS f ON f.item_id = i.id');
		$query->where('f.id = '.(int)$fileId);
		
		$db->setQuery($query);
		$itemFile = $db->loadObject();
		$owner = $itemFile->created_by;
		$access = $itemFile->access;
		$groups	= $user->getAuthorisedViewLevels();
		
		$authorised = false;
		if (($user->id && $user->id == $owner && $user->id > 0) || $user->authorise('core.admin', 'com_djcatalog2')) {
			$authorised = true;
		} else if ($itemFile->product_type == 'virtual' || $itemFile->product_type == 'hybrid') {
			$token = $app->getUserStateFromRequest('com_djcatalog2.order.token', 'token', null, 'string');
			if ($user->guest == false || $token != '') {
				$query = $db->getQuery(true);
				$query->select('o.*');
				$query->from('#__djc2_orders AS o');
				$query->join('inner', '#__djc2_order_items AS oi ON oi.order_id=o.id');
				if ($user->guest) {
					$query->where('o.token='.$db->quote($token));
				}
				else {
					$query->where('o.user_id='.$user->id);
				}
				$query->where('oi.item_id = '.$itemFile->id);
				$query->order('o.id DESC');
				
				$db->setQuery($query);
				$fileOrders = $db->loadObjectList();
				
				foreach($fileOrders as $order) {
					if ($order->status == 'C' || $order->status == 'P' || $order->status == 'F') {
						$authorised = true;
						break;
					}
				}
				
				if (!$authorised && count($fileOrders) > 0) {
					$fileOrder = $fileOrders[0];
					throw new Exception(JText::_('COM_DJCATALOG2_VIRTUAL_PRODUCT_DOWNLOAD_NOT_AUTH'), 401);
					return false;
				}
			}
		} else {
			if ($user->authorise('djcatalog2.filedownload', 'com_djcatalog2')) {
				$authorised = (bool)(in_array($access, $groups));
			}
		}
		
		if ($authorised !== true) {
			if ($user->guest) {
				throw new Exception(JText::_('COM_DJCATALOG2_LOGIN_FIRST'), 303);
			} else {
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
			}
		}
		
		return $authorised;
	}
	
	public static function getOrderFiles($order) {
		$files = array();
		
		if (empty($order->items)) {
			return $files;
		}
		
		$db = JFactory::getDbo();
		
		$ids = array();
		foreach($order->items as $item) {
			if ($item->item_type != 'item' || !$item->item_id || $item->product_type == 'tangible') {
				continue;
			}
			$ids[] = $item->item_id;
		}
		
		if (empty($ids)) {
			return $files;
		}
		require_once JPATH_ROOT.'/administrator/components/com_djcatalog2/helpers/file.php';
		foreach($ids as $id) {
			$item_files = DJCatalog2FileHelper::getFiles('item', $id);
			$files = array_merge($files, $item_files);
		}
		
		/*
		 $query = $db->getQuery(true);
		 $query->select('f.*, i.name as item_name, i.alias AS alias, i.cat_id, c.alias as category_alias');
		 $query->from('#__djc2_files AS f');
		 $query->join('inner', '#__djc2_items AS i ON f.item_id = i.id');
		 $query->join('inner', '#__djc2_categories AS c ON i.cat_id = c.id');
		 $query->where('f.type = '.$db->quote('item').' AND f.item_id IN ('.implode(',', $ids).')');
		 $query->where('i.product_type = '.$db->quote('virtual'));
		 $db->setQuery($query);
		 
		 $files = $db->loadObjectList();
		 */
		return $files;
	}
}