<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die('Restricted access');

if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/lib/categories.php');
require_once(JPATH_ROOT.'/components/com_djcatalog2/helpers/user.php');

class Djcatalog2Helper {
	static $params = null;
	static $recentItems = array();
	static $languageLoaded = false;
	
	static $vendor = array();
	static $vendorUsers = array();
	
	public static function getParams($reload = false) {
		if (!self::$params || $reload == true) {
			$app		= JFactory::getApplication();
			
			// our params
			$params = new Registry();
			
			// component's global params
			$cparams = JComponentHelper::getParams( 'com_djcatalog2' );
			
			// current params - all
			$aparams = $app->getParams();
			
			// curent params - djc2 only
			$mparams = $app->getParams('com_djcatalog2');
			
			// first let's use all current params
			$params->merge($aparams);
			
			// then override them with djc2 global settings - in case some other extension share's the same parameter name
			$params->merge($cparams);
			
			if ($app->input->getCmd('option') == 'com_djcatalog2') {
				// finally, override settings with current params, but only related to djc2.
				$params->merge($mparams);
			}
			
			// ...and then, override with category specific params
			$option = $app->input->get('option');
			$view = $app->input->get('view');
			
			if ($option = 'com_djcatalog2' && ($view = 'item' || $view = 'items' || $view = 'archived')) {
				
				$user	= JFactory::getUser();
				$groups	= $user->getAuthorisedViewLevels();
				
				$categories = Djc2Categories::getInstance(array('state' => '1', 'access' => $groups));
				$category = $categories->get((int) $app->input->get('cid',0,'int'));
				if (!empty($category)) {
					$catpath = array_reverse($category->getPath());
					foreach($catpath as $k=>$v) {
						$parentCat = $categories->get((int)$v);
						if (!empty($parentCat) && !empty($category->params)) {
							$catparams = new Registry($parentCat->params);
							$params->merge($catparams);
						}
					}
				}
			}
			
			$listLayout = $app->input->get('l', $app->getUserState('com_djcatalog2.list_layout', null), 'cmd');
			if ($listLayout == 'items') {
				$app->setUserState('com_djcatalog2.list_layout', 'items');
				$params->set('list_layout', 'items');
			} else if ($listLayout == 'table') {
				$app->setUserState('com_djcatalog2.list_layout', 'table');
				$params->set('list_layout', 'table');
			}
			
			$catalogMode = $app->input->get('cm', null, 'int');
			$indexSearch = $app->input->get('ind', null, 'string');
			
			$globalSearch = urldecode($app->input->get( 'search','','string' ));
			$globalSearch = trim(JString::strtolower( $globalSearch ));
			if (substr($globalSearch,0,1) == '"' && substr($globalSearch, -1) == '"') {
				$globalSearch = substr($globalSearch,1,-1);
			}
			if (strlen($globalSearch) > 0 && (strlen($globalSearch)) < 3 || strlen($globalSearch) > 20) {
				$globalSearch = null;
			}
			if ($catalogMode === 0 || $globalSearch || $indexSearch) {
				$params->set('product_catalogue','0');
				// set 'filtering' variable in REQUEST
				// so we could hide for example sub-categories
				// when searching/filtering is performed
				$app->input->set('filtering', true);
			}
			
			self::$params = $params;
		}
		return self::$params;
	}
	
	public static function loadComponentLanguage() {
		if (!self::$languageLoaded /*&& JFactory::getApplication()->input->getCmd('option') != 'com_djcatalog2'*/) {
			
			$lang = JFactory::getLanguage();
			
			if ($lang->getTag() != 'en-GB') {
				$lang->load('com_djcatalog2', JPath::clean(JPATH_ADMINISTRATOR.'/components/com_djcatalog2'), 'en-GB', false, false);
				$lang->load('com_djcatalog2', JPATH_ADMINISTRATOR, 'en-GB', false, false);
				$lang->load('com_djcatalog2', JPath::clean(JPATH_ROOT.'/components/com_djcatalog2'), 'en-GB', false, false);
				$lang->load('com_djcatalog2', JPATH_ROOT, 'en-GB', false, false);
			}
			
			$lang->load('com_djcatalog2', JPath::clean(JPATH_ADMINISTRATOR.'/components/com_djcatalog2'), null, true, false);
			$lang->load('com_djcatalog2', JPATH_ADMINISTRATOR, null, true, false);
			$lang->load('com_djcatalog2', JPath::clean(JPATH_ROOT.'/components/com_djcatalog2'), null, true, false);
			$lang->load('com_djcatalog2', JPATH_ROOT, null, true, false);
			
			self::$languageLoaded = true;
		}
	}
	
	public static function getUser($id = null) {
		return Djcatalog2HelperUser::getUserProfile($id);
	}
	
	public static function getSecureToken($forceNew = false) {
		$app = JFactory::getApplication();
		$token = $app->getUserState('com_djcatalog2.secure_token', $app->input->cookie->get('djc2token', false));
		
		if ($token == false || $forceNew) {
			$token = static::createSecureToken();
		}
		
		$app->setUserState('com_djcatalog2.secure_token', $token);
		$app->input->cookie->set('djc2token', $token, (time() + (86400)), $app->get('cookie_path', '/'), $app->get('cookie_domain', ''));
		
		return $token;
	}
	
	public static function createSecureToken() {
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		$token = JApplicationHelper::getHash((int)$user->id . JUserHelper::genRandomPassword(8));
		
		return $token;
	}
	
	public static function isViesValid( $vatId, $countryCode )
	{
		$vatId = trim($vatId);
		$app = JFactory::getApplication();
		
		$codeAssoc = array(
			'AT' => 'AT',
			'BE' => 'BE',
			'BG' => 'BG',
			'HR' => 'HR',
			'CY' => 'CY',
			'CZ' => 'CZ',
			'DK' => 'DK',
			'EE' => 'EE',
			'FI' => 'FI',
			'FR' => 'FR',
			'DE' => 'DE',
			'GR' => 'EL',
			'HU' => 'HU',
			'IE' => 'IE',
			'IT' => 'IT',
			'LV' => 'LV',
			'LT' => 'LT',
			'LU' => 'LU',
			'MT' => 'MT',
			'NL' => 'NL',
			'PL' => 'PL',
			'PT' => 'PT',
			'RO' => 'RO',
			'SK' => 'SK',
			'SI' => 'SI',
			'ES' => 'ES',
			'SE' => 'SE',
			'GB' => 'GB'
		);
		
		$number = substr($vatId, 2);
		$country = $countryCode; //substr($vatId, 0, 2);
		if (isset($codeAssoc[$country])) {
			$country = $codeAssoc[$country];
		}
		
		$vatId = trim($country).$number;
		$hash = md5($countryCode.':'.$vatId);
		
		if ($app->getUserState('com_djcatalog2.vies_valid.'.$hash) == '-1') {
			return false;
		} else if ($app->getUserState('com_djcatalog2.vies_valid.'.$hash)) {
			return true;
		}
		
		$response = false;
		$soapOpts = array('connection_timeout' => 5);
		try {
			$client = new SoapClient("http://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl", $soapOpts);
			$response = $client->checkVat(array(
				'countryCode' => $country,
				'vatNumber' => $number
			));
		} catch(Exception $e) {
			sleep(2);
			try {
				$client = new SoapClient("http://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl", $soapOpts);
				$response = $client->checkVat(array(
					'countryCode' => $country,
					'vatNumber' => $number
				));
			} catch(Exception $e) {
				//$app->setUserState('com_djcatalog2.vies_valid.'.$vatId, '-1');
				$app->setUserState('com_djcatalog2.vies_valid.'.$hash, '-1');
				return false;
				//return $e->getMessage();
			}
		}
		if (empty($response)) {
			//$app->setUserState('com_djcatalog2.vies_valid.'.$vatId, null);
			$app->setUserState('com_djcatalog2.vies_valid.'.$hash, null);
			return null;
		}
		
		if (isset($response->valid)) {
			//$app->setUserState('com_djcatalog2.vies_valid.'.$vatId, (int)$response->valid);
			$app->setUserState('com_djcatalog2.vies_valid.'.$hash, (int)$response->valid);
			return (int)$response->valid;
		} else {
			//$app->setUserState('com_djcatalog2.vies_valid.'.$vatId, '-1');
			$app->setUserState('com_djcatalog2.vies_valid.'.$hash, '-1');
		}
		
		return false;
	}
	
	public static function getUserProfile($id = null) {
		$user = self::getUser($id);
		$data = array();
		
		if (!empty($user->djcatalog2profile)) {
			$data = $user->djcatalog2profile;
		}
		
		return $data;
	}
	
	public static function isDefaultLanguage() {
		$lang = JFactory::getLanguage();
		$default = JComponentHelper::getParams('com_languages')->get('site', $lang->getDefault());
		if (JString::strcmp($default, $lang->getTag()) === 0) {
			return true;
		}
		return false;
	}
	public static function getLangId(){
		$lang = JFactory::getLanguage();
		$db = JFactory::getDbo();
		$db->setQuery('select lang_id from #__languages where lang_code='.$db->quote($lang->getTag()));
		
		return $db->loadResult();
	}
	public static function isFalang() {
		return (bool)class_exists('plgSystemFalangdriver');
	}
	public static function getRecentItems() {
		if (empty(self::$recentItems)) {
			$app = JFactory::getApplication();
			$sessionItems = $app->getUserState('com_djcatalog2.items.recent', array());
			self::$recentItems = $sessionItems;
		}
		return self::$recentItems;
	}
	public static function pushRecentItem($id) {
		$app = JFactory::getApplication();
		$sessionItems = $app->getUserState('com_djcatalog2.items.recent', array());
		$sessionItems[] = (int)$id;
		self::$recentItems = array_values(array_unique($sessionItems));
		$app->setUserState('com_djcatalog2.items.recent', self::$recentItems);
		
		return true;
	}
	
	public static function getVendors($user_id = null) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('DISTINCT u.*, c.customer_id');
		$query->from('#__users AS u');
		$query->join('inner', '#__djc2_vendors AS v ON v.user_id=u.id');
		$query->join('left', '#__djc2_vendors_customers AS c ON c.vendor_id = v.id');
		if ($user_id) {
			$query->where('(c.customer_id IS NULL OR c.customer_id = '.(int)$user_id.')');
		} else {
			$query->where('c.customer_id IS NULL');
		}
		
		$db->setQuery($query);
		$vendors = $db->loadObjectList();
		
		if (empty($vendors)) {
			return array();
		}
		
		if (!$user_id) {
			return $vendors;
		}
		
		$general = array();
		$userAssigned = array();
		
		foreach($vendors as $vendor){
			if ($vendor->customer_id == $user_id) {
				$userAssigned[] = $vendor;
			} else {
				$general[] = $vendor;
			}
		}
		
		return (count($userAssigned) > 0) ? $userAssigned : $general;
	}
	
	public static function getVendor($user_id = null) {
		$user_id = ($user_id === null) ? (int)JFactory::getUser()->id : (int)$user_id;
		
		if (!isset(static::$vendor[$user_id])) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('u.*, v.id AS vendor_id');
			$query->from('#__users AS u');
			$query->join('inner', '#__djc2_vendors AS v ON v.user_id=u.id');
			$query->where('u.id='.$user_id);
			$db->setQuery($query);
			
			static::$vendor[$user_id] = $db->loadObject();
		}
		
		return static::$vendor[$user_id];
	}
	
	public static function getVendorUsers($user_id = null, $ids_only = false) {
		$vendor = static::getVendor($user_id);
		
		if (empty($vendor)) {
			return false;
		}
		
		if (!isset(static::$vendorUsers[$user_id])) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select('u.*');
			$query->from('#__users AS u');
			$query->join('inner', '#__djc2_vendors_customers AS vc ON vc.customer_id = u.id');
			$query->where('vc.vendor_id='.$vendor->vendor_id);
			$db->setQuery($query);
			
			static::$vendorUsers[$user_id] = $db->loadObjectList('id');
		}
		
		return $ids_only ? array_keys(static::$vendorUsers[$user_id]) : static::$vendorUsers[$user_id];
	}

    public static function isOnUserWishlist($user_id, $item_id) {
        $app = JFactory::getApplication();

        if(!$user_id) {
            $items = $app->getUserState('com_djcatalog2.wishlist', array());

            return (bool) in_array($item_id, $items);
        } else {
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);

            $query->select('Count(*)');
            $query->from($db->quoteName('#__djc2_wishes'));
            $query->where($db->quoteName('user_id') . ' = '. (int)$user_id . ' AND ' . $db->quoteName('item_id') . ' = ' . (int)$item_id);

            $db->setQuery($query);

            return (bool) $db->loadResult();
        }
    }

    public static function importTCPDF() {
        $libfile = JPATH_LIBRARIES . '/tcpdf/tcpdf.php';
        if (JFile::exists($libfile) == false) {
            return false;
        }

        require_once $libfile;
        return true;
    }
}