<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die;


abstract class DJCatalog2HelperAssociation
{
	/**
	 * Method to get the associations for a given item
	 *
	 * @param integer $id Id of the item (helloworld id or catid, depending on view)
	 * @param string $view Name of the view ('helloworld' or 'category')
	 *
	 * @return  array   Array of associations for the item
	 */
	public static function getAssociations($id = 0, $view = null)
	{
		$input = JFactory::getApplication()->input;
		$view = $view === null ? $input->get('view') : $view;
		$id = empty($id) ? $input->getInt('id') : $id;
		$pid = empty($id) ? $input->getInt('pid') : $id;
		$cid = $input->getInt('cid', 0);
		$pcid = $input->getInt('pcid', 0);
		
		if ($view === 'item') {
			if ($id) {
				$user	  = JFactory::getUser();
				$groups	= implode(',', $user->getAuthorisedViewLevels());
				$db		= JFactory::getDbo();
				
				$advClausuleItem = array();
				$advClausuleItem[] = 'c2.access IN (' . $groups . ')';
				$advClausuleItem[] = 'c2.language != ' . $db->quote(JFactory::getLanguage()->getTag());
				$advClausuleItem[] = 'c2.published = 1';
				
				$associationsItem = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_items', 'com_djcatalog2.item', $id, 'id', 'alias', '', $advClausuleItem);
				$associationsCategory = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_categories', 'com_djcatalog2.category', $cid, 'id', 'alias', '');
				
				$return = array();
				
				
				foreach ($associationsItem as $tag => $item) {
					$cid = ((isset($associationsCategory[$tag])) ? $associationsCategory[$tag]->id : 0);
					
					$link = DJCatalog2HelperRoute::getItemRoute($item->id, $cid);
					
					
					if ($item->language && $item->language !== '*' && JLanguageMultilang::isEnabled()) {
						$link .= '&lang=' . $item->language;
					}
					$return[$tag] = $link;
				}
				
				
				return $return;
			}
		} else if ($view === 'producer') {
			if ($pid) {
				$user	  = JFactory::getUser();
				$groups	= implode(',', $user->getAuthorisedViewLevels());
				$db		= JFactory::getDbo();
				
				$advClausuleItem = array();
				//$advClausuleItem[] = 'c2.access IN (' . $groups . ')';
				$advClausuleItem[] = 'c2.language != ' . $db->quote(JFactory::getLanguage()->getTag());
				$advClausuleItem[] = 'c2.published = 1';
				
				$associationsItem = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producers', 'com_djcatalog2.producer', $pid, 'id', 'alias', '', $advClausuleItem);
				$associationsCategory = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producer_categories', 'com_djcatalog2.producercategory', $pcid, 'id', 'alias', '');
				
				$return = array();
				
				
				foreach ($associationsItem as $tag => $item) {
					$cid = ((isset($associationsCategory[$tag])) ? $associationsCategory[$tag]->id : 0);
					
					$link = DJCatalog2HelperRoute::getProducerRoute($item->id);
					
					
					if ($item->language && $item->language !== '*' && JLanguageMultilang::isEnabled()) {
						$link .= '&lang=' . $item->language;
					}
					$return[$tag] = $link;
				}
				
				
				return $return;
			}
		}
		
		if ($view === 'items' || $view === 'categories') {
			if ($cid) {
				$associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_categories', 'com_djcatalog2.category', $cid, 'id', 'alias', '');
				
				$return = array();
				foreach ($associations as $tag => $item) {
					$link = DJCatalog2HelperRoute::getCategoryRoute($item->id);
					if ($item->language && $item->language !== '*' && JLanguageMultilang::isEnabled()) {
						$link .= '&lang=' . $item->language;
					}
					$return[$tag] = $link;
				}
				
				return $return;
			}
		} else if ($view === 'producers') {
			$associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producer_categories', 'com_djcatalog2.producercategory', $pcid, 'id', 'alias', '');
			
			$return = array();
			foreach ($associations as $tag => $item) {
				$link = DJCatalog2HelperRoute::getProducerCategoryRoute($item->id);
				if ($item->language && $item->language !== '*' && JLanguageMultilang::isEnabled()) {
					$link .= '&lang=' . $item->language;
				}
				$return[$tag] = $link;
			}
			
			return $return;
		}
		
		return array();
	}
}
