<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined ('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');
jimport('joomla.filesystem.file');

class DJCatalog2ControllerWish extends JControllerLegacy
{

    function __construct($config = array())
    {
        parent::__construct($config);
    }

    function add() {
        $app = JFactory::getApplication();
        $user = JFactory::getUser();
        $params = Djcatalog2Helper::getParams();

        if (!$params->get('wishlist_enabled')) {
            echo json_encode(array(
                'message' => JText::_('COM_DJCATALOG2_WISHLIST_NOT_ENABLED')
            ));
            exit();
        }

        if ($params->get('wishlist_require_login') && $user->guest) {
            echo json_encode(array(
                'message' => JText::_('COM_DJCATALOG2_WISHLIST_REQUIRED_LOGIN')
            ));
            exit();
        }

        $item_id = $app->input->get('item_id');


        $status = true;
        if ($user->guest) {
            $items = $app->getUserState('com_djcatalog2.wishlist', array());
            if (in_array($item_id, $items)) {
                $message = JText::_('COM_DJCATALOG2_WISHLIST_ITEM_EXIST');
                $status =  false;
            } else {
                $items[] = $item_id;
                $app->setUserState('com_djcatalog2.wishlist', $items);
                $message = JText::sprintf('COM_DJCATALOG2_ADD_TO_WISHLIST_SUCCESS', JRoute::_(DJCatalogHelperRoute::getWishlistRoute()));
            }
        } else {
            $model = $this->getModel('Wishes');
            if($model->addToUserWishlist($user->id, $item_id))
                $message = JText::sprintf('COM_DJCATALOG2_ADD_TO_WISHLIST_SUCCESS', JRoute::_(DJCatalogHelperRoute::getWishlistRoute()));
        }

        echo json_encode(array(
            'message' => $message,
            'status' => $status

        ));

        exit();
    }


    public function pdf() {
        $app = JFactory::getApplication();

        if(!DJCatalog2Helper::importTCPDF()) {
            $app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_WISHLIST_PDF_FAILED'), 'error');
            $this->setRedirect(DJCatalogHelperRoute::getWishlistRoute());
        }

        $path = JPATH_ROOT.'/media/djcatalog2/export/wishlists';
        if (!JFolder::exists($path)) {
            JFolder::create($path);
        }

        if (!is_writable($path)) {
            $app->enqueueMessage(JText::_('COM_DJCATALOG2_FOLDER_NOT_WRITABLE').' '.$path, 'error');
            $this->setRedirect(DJCatalogHelperRoute::getWishlistRoute());
        }

        $layout = 'wishlist';

        $model = $this->getModel('Wishes');
        $items = $model->getItems();

        $html = DJCatalog2HtmlHelper::getThemeLayout($items, $layout, 'pdf');
        
        $pdf = new TCPDF();
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('freesans', '', 9, '', true);
        $pdf->SetPrintHeader(false);
        $pdf->SetPrintFooter(true);
        $pdf->SetFooterMargin('15');
        $pdf->AddPage();
        $pdf->writeHTML($html, true, false, true, false, '');
        //$pdf->Output($filename, 'D');
        $pdf->Output('wishlist-'.date("Y-m-d_H-i-s").'.pdf', 'D');
        $app->close();


        /*$file_link = '<a href="/media/djcatalog2/export/wishlists/'.$filename.'">'.$filename.'</a>';
        $this->setRedirect( 'index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL').' '.$file_link );

        $this->setRedirect(DJCatalogHelperRoute::getWishlistRoute());*/
    }

    public function remove() {
        $app = JFactory::getApplication();
        $items_ids = $app->input->get('cid', array(), 'array');
        $user = JFactory::getUser();

        if($user->guest) {
            $items = $app->getUserState('com_djcatalog2.wishlist', array());
            foreach($items as $i => $item) {
                if(in_array($item, $items_ids))
                    unset($items[$i]);
            }
            $app->setUserState('com_djcatalog2.wishlist', $items);
        }else {
            $model = $this->getModel('Wishes');
            $model->remove($items_ids);
        }
        $app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_WISHLIST_REMOVED_SUCCESSFULL'), 'message');
        $this->setRedirect(DJCatalogHelperRoute::getWishlistRoute());
    }

    public function getWishList() {
        $app = JFactory::getApplication();
        $user = JFactory::getUser();

        if(!$user->id) {
            $items = $app->getUserState('com_djcatalog2.wishlist', array());

            echo json_encode($items);
        } else {
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);

            $query->select('item_id');
            $query->from($db->quoteName('#__djc2_wishes'));
            $query->where($db->quoteName('user_id') . ' = '. (int)$user->id);

            $db->setQuery($query);

            echo json_encode( $db->loadColumn());
        }

        exit();
    }
}