<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die( 'Restricted access' );
jimport('joomla.application.component.controlleradmin');


class Djcatalog2ControllerOrders extends JControllerAdmin
{

	public function downloadExport() {
		$app = JFactory::getApplication();
		$jinput = $app->input;
		
		$user = JFactory::getUser();
		if ($user->guest) {
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		$file = $jinput->get('file', null, 'base64');
		if(!strlen($file)) {
			throw new Exception(JText::_('COM_DJCATALOG2_FILE_NOT_FOUND'), 403);
		}


		$app = JFactory::getApplication();
		$user = JFactory::getUser();

		$file_path = Djcatalog2ExportHelper::getExportPath('order') . '/' . base64_decode(($file));

		if (strpos($file_path, 'U' . $user->id .'.csv') === false) {
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		if (empty($file) || !JFile::exists($file_path) || strpos($file_path, 'media') === false || strpos($file_path, 'djcatalog2') === false) {
			$this->setRedirect( 'index.php?option=com_djcatalog2', JText::sprintf('COM_DJCATALOG2_ERROR_FILE_MISSING', base64_decode($file)), 'error' );
			return false;
		}

		if (!DJCatalog2FileHelper::getFileByPath($file_path, null, 'text/csv')){
			//JError::raiseError(404);
			throw new Exception('', 404);
			return false;
		}
		$app->close();
		return true;

	}

	public function export() {
		$this->checkToken();

		$user = JFactory::getUser();
		if ($user->guest) {
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		$params = DJCatalog2Helper::getParams();
		if(!$params->get('export_orders_frontend')) {
			throw new Exception(JText::_('COM_DJCATALOG2_FRONTEND_ORDER_EXPORT_DISABLED'), 403);
		}

		$app = JFactory::getApplication();
		$jinput = $app->input;

		$cid = $jinput->get('cid', array(), 'array');
		$file = Djcatalog2ExportHelper::exportOrders($cid);

		if($file['success']) {
			$file_link = '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=orders.downloadExport&file=' . base64_encode($file['filename'])) . '">' . $file['filename'] . '</a></br>';
			$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2&view=orders'), JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);
		}
	}
	
	public function accesstoken() {
		$app = JFactory::getApplication();
		$id = $app->input->getInt('id');
		$token = $app->input->getCmd('token');
		$return = $app->input->getBase64('return');
		
		if (!$return) {
			$return = 'index.php';
		} else {
			$return = base64_decode($return);
		}

		$response = [
			'redirect' => false,
			'body' => '',
			'message' => '',
			'error' => false
		];
		
		$response['redirect'] = JRoute::_($return, false, JUri::getInstance()->isSsl() ? 1 : -1);
		
		$orders = Djcatalog2HelperUser::getOrdersByToken($token);
		
		$auth = false;
		if (!empty($orders['items'])) {
			foreach($orders['items'] as $purchasedItem) {
				$app->setUserState('com_djcatalog2.accesstoken.' . $purchasedItem->item_id, true);
				if ($purchasedItem->item_id != $id) continue;
				$auth = true;
			}
		}
		
		if (!$auth) {
			$response['error'] = JText::_('COM_DJCATALOG2_AUTH_ERROR_TOKEN_INVALID');
		} 
		
		if ($app->input->getInt('is_ajax')) {
			echo json_encode($response);
			$app->close();
		}
		
		if ($response['message']) {
			$app->enqueueMessage($response['message']);
		}
		if ($response['error']) {
			$app->enqueueMessage($response['error'], 'error');
		}
		
		$this->setRedirect($response['redirect']);
		return true;
		
	}
}