<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

class DJCatalog2ControllerItems extends JControllerLegacy
{
	
	public function getCombinations() {
		
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');
		$jinput = $app->input;
		
		$item_ids = $jinput->get('item_ids', array(), 'array');
		
		$model = $this->getModel('Item');
		
		
		$variantsMap = array();
		$model->getState();
		
		$priceOpts = array(
			'when_not_null' => $params->get('show_price') == 1,
			'display_always' => $params->get('show_price') == 2,
			'restricted_note' => $params->get('restricted_price_info', 1),
			'show_old' => $params->get('show_old_price', 1),
			'structured_data' => false
		);
		
		foreach ($item_ids as $item_id) {
			
			$model->setState('item.id', $item_id);
			$variants = $model->getCartVariants();
			$item = $model->getItem();
			
			$item->_combinations = $model->getCombinations($item->id);
			$params = DJCatalog2Helper::getParams();
			
			$handleStockNotifications = false;
			if ($params->get('stock_notifications', false) && (JFactory::getUser()->id > 0 || $params->get('stock_notifications_registered', false) == false)) {
				$handleStockNotifications = true;
			}
			
			$item_cursor = $item;
			foreach ($item->_combinations as &$combination) {
				$cursor = new stdClass();
				$cursor->id = $item->id;
				$cursor->price = ($combination->price == 0.0) ? $item->price : $combination->price;
				$cursor->final_price = (isset($combination->final_price) && $combination->final_price > 0.0) ? $combination->final_price : (($combination->price == 0.0) ? $item->final_price : $combination->price);
				$cursor->tax_rule_id = $item->tax_rule_id;
				$cursor->price_restrict = $item->price_restrict;
				$item_cursor = $cursor;
				
				$priceData = array('item' => $item_cursor, 'params' => $params, 'options' => $priceOpts);
				$layout = new JLayoutFile('com_djcatalog2.price', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
				$combination->price_html =  $layout->render($priceData);
				
				$combination->stock_notify_html = '';
				if ($handleStockNotifications && $combination->stock <= 0.0000) {
					$stockNotify = array('item' => $combination, 'item_type' => 'combination', 'params' => $params, 'return' => DJCatalog2HelperRoute::getItemRoute($item->slug, $item->catslug));
					$layout = new JLayoutFile('com_djcatalog2.stocknotify', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component'=> 'com_djcatalog2'));
					
					$combination->stock_notify_html = $layout->render($stockNotify);
				}
				
				//$combination->price_html = $this->loadTemplate('price');
			}
			unset($combination);
			
			if($variants) {
				$layout = new JLayoutFile('com_djcatalog2.item.combination', DJCatalog2ThemeHelper::getLayoutBasePath(), array('component' => 'com_djcatalog2'));
				$html =  $layout->render(array('item' => $item, 'variants' => $variants, 'params' => $params));
				$variantsMap[$item_id] = $html;
			}
			
		}
		echo json_encode(array(
			'status' => 1,
			'variants' => $variantsMap,
			'items' => $item_ids
		));
		$app->close();
	}
	
}
