<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

require_once(JPATH_COMPONENT_ADMINISTRATOR.'/lib/controllerform.php');

class Djcatalog2ControllerAddress extends DJCJControllerForm {
	function __construct($config = array())
	{
		$this->view_list = 'addresses';
		$this->view_item = 'address';
		
		parent::__construct($config);
		
		//$this->unregisterTask('save2copy');
		
	}
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
		$app = JFactory::getApplication();
		$tmpl   = $app->input->get('tmpl');
		
		// got rid of edit layout
		$layout = $app->input->get('layout');
		$append = '';
	
		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}
	
		if ($layout)
		{
			$append .= '&layout=' . $layout;
		}
	
		if ($recordId)
		{
			$append .= '&' . $urlVar . '=' . $recordId;
		}
	
		return $append;
	}
	
	protected function getRedirectToListAppend()
	{
		$app = JFactory::getApplication();
		$tmpl = JFactory::getApplication()->input->get('tmpl');
		
		$append = '';
	
		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}
		
		$needles = array(
			'addresses' => array(0)
		);
		
		if ($item = DJCatalogHelperRoute::_findItem($needles)) {
			$append .= '&Itemid='.$item;
		}
		
		return $append;
	}
	
	protected function allowEdit($data = array(), $key = 'id') {
		// Initialise variables.
		$recordId	= (int) isset($data[$key]) ? $data[$key] : 0;
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		//$asset		= 'com_djcatalog2.item.'.$recordId;

		// Check general edit permission first.
		if ($user->authorise('core.edit', $this->option)) {
			return true;
		}
		
		$ownerId	= (int) isset($data['user_id']) ? $data['user_id'] : 0;
		if (empty($ownerId) && $recordId) {
			// Need to do a lookup from the model.
			$record		= $this->getModel()->getItem($recordId);

			if (empty($record)) {
				return false;
			}

			$ownerId = $record->user_id;
		}

		if ($ownerId == $userId) {
			return true;
		}
		
		// Since there is no asset tracking, revert to the component permissions.
		return parent::allowEdit($data, $key);
	}
	
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		
		return $user->id ? true : false;
	}
	
	public function add() {
		$user = JFactory::getUser();
		
		if ((bool)$user->guest && !$this->allowAdd()) {
			$return_url = base64_encode(DJCatalogHelperRoute::getAddressesRoute().'&task=address.add');
			$this->setRedirect(JRoute::_('index.php?option=com_users&view=login&return='.$return_url, false), JText::_('COM_DJCATALOG2_PLEASE_LOGIN'));
			return true;
		}
		
		return parent::add();
	}
	
}
?>
