(function($){
	var DJC2ConfigurableWizard = function(opts, lang) {
		this.uri = opts.uri;
		this.viewUri = opts.viewUri,
		this.configuration = JSON.parse(opts.configuration);
		this.category_id = opts.category_id; 
		
		if (this.category_id > 0) {
			this.core_steps = 1;
		} else {
			this.core_steps = 2;
		}
		
		this.steps_at_once = opts.steps_at_once;
		this.lang = $.extend({}, this.lang, lang);
		
		this.wrapper = $(this.wrapper);
		
		if (this.configuration == null) {
			this.start();
		} else {
			this.restore();
		}
	};

	DJC2ConfigurableWizard.prototype = {
		constructor: DJC2ConfigurableWizard,
		wrapper: '#djc_cfg_wrap',
		steps: [],
		choice_path: [],
		product: {},
		dimensions: {},
		current_step: 0,
		step_count: 0,
		uri: null,
		viewUri: null,
		configuration: null,
		xhr: false,
		category_id: 0,
		steps_at_once: false,
		core_steps: 2,
		lang: {
				GO_BACK: 'Go back',
				CONFIRM: 'Confirm',
				SELECTED: 'Selected: ',
				SELECTED_PRODUCT: 'Product: ',
				SELECTED_CATEGORY: 'Category: ',
				PRODUCT_DIMENSIONS: 'Dimensions: ',
				CHECK: '&check;',
				ADD_TO_CART: 'Add to cart'
		},
		
		start: function() {
			if (this.category_id > 0) {
				//this.step_count++;
				this.doXhr('items', 'cid=' + this.category_id);
			} else {
				this.doXhr('categories');
			}
		},
		
		restore: function(){
			
		},
		
		prevStep: function(){
			if (this.current == 1) return;
			
			this.current -= 1;
		},
		
		nextStep: function(){
			if (this.current == this.step_count) return;
			
			this.current += 1;
		},
		
		editStep: function(step) {
			this.killAddToCart();
			
			var stepWrap = this.wrapper.find('div[data-step="'+step+'"]');
			if (stepWrap.length < 1) return;
			
			this.current_step = step;
			
			var allsteps = this.wrapper.find('div[data-step]');
			$.each(allsteps, function(i){
				if (i < step - 1) {
					$(this).find('.djc_cfg_back_btn').hide();
				} else {
					$(this).find('.djc_cfg_back_btn').show();
				}
			});
			
			stepWrap.removeClass('step-confirmed');
			stepWrap.addClass('step-edit');
			
			stepWrap.find('.step_confirmation').hide();
			stepWrap.find('.stepind_confirmed').hide();
			
			stepWrap.find('.stepind_active').show();
			stepWrap.find('.step_choice').show();
		},
		
		filterStep: function(step) {
			var $this = this;
			var stepWrap = this.wrapper.find('div[data-step="'+step+'"]');
			if (stepWrap.length < 1) return;
			
			var options = stepWrap.find('.djc_cfg_item');
			if (options.length < 1) return;
			
			if (this.choice_path.length == 0) return;
			
			$(options).each(function(){
				var opt = $(this);
				var deps = $(this).attr('data-dependancies');
				
				if (deps == '' || typeof deps == 'undefined') {
					opt.show();
					// TODO: all available
					return;
				}
				
				try {
					deps = JSON.parse(deps);
				} catch (e) {
					opt.hide();
					// TODO: none available
				}
				
				if (deps.length < 1) {
					opt.show();
				}
				
				var pass = true;
				var in_path = false;
				$.each(deps, function(i,e){
					if (!pass) return;
					
					$.each($this.choice_path, function(ii,ee){
						if (!pass) return;
						
						if (ee.field_id == e.id) {
							in_path = true;
							
							var floatMatch = parseFloat(e.match);
							var floatVal = parseFloat(ee.value);
							
							switch (e.operator) {
								case 'eq':{
									if (e.match_ids.length > 0) {
										if (e.match_ids.indexOf(ee.id) < 0) {
											pass = false;
										}
									}
									break;
								}
								case 'not':{
									if (e.match_ids.length > 0) {
										if (e.match_ids.indexOf(ee.id) >= 0) {
											pass = false;
										}
									}
									break;
								}
								case 'lt':{
									if (isNaN(floatMatch) == false && isNaN(floatVal) == false) {
										if ( !(floatVal < floatMatch) ) {
											pass = false;
										}
									} else {
										if ( !(ee.value < e.match) ) {
											pass = false;
										}
									}
									break;
								}
								case 'lte':{
									if (isNaN(floatMatch) == false && isNaN(floatVal) == false) {
										if ( !(floatVal <= floatMatch) ) {
											pass = false;
										}
									} else {
										if ( !(ee.value <= e.match) ) {
											pass = false;
										}
									}
									break;
								}
								case 'gt':{
									if (isNaN(floatMatch) == false && isNaN(floatVal) == false) {
										if ( !(floatVal > floatMatch) ) {
											pass = false;
										}
									} else {
										if ( !(ee.value > e.match) ) {
											pass = false;
										}
									}
									break;
								}
								case 'gte':{
									if (isNaN(floatMatch) == false && isNaN(floatVal) == false) {
										if ( !(floatVal >= floatMatch) ) {
											pass = false;
										}
									} else {
										if ( !(ee.value >= e.match) ) {
											pass = false;
										}
									}
									break;
								}
								case 'contains':{
									if (ee.value.indexOf(e.match) == -1) {
										pass = false;
									}
									break;
								}
							}
						}
					});
					
					if (!in_path) {
						//pass = false;
					}
				});
				
				if (!pass) {
					$(this).hide();
				} else {
					$(this).show();
				}
			});
			
		},
		
		confirmStep: function(step, html) {
			var stepWrap = this.wrapper.find('div[data-step="'+step+'"]');
			if (stepWrap.length < 1) return;
			
			stepWrap.addClass('step-confirmed');
			stepWrap.removeClass('step-edit');
			
			stepWrap.find('.step_choice').hide();
			stepWrap.find('.stepind_active').hide();
			
			if (typeof html != 'undefined' && html) {
				stepWrap.find('.step_confirmation').html(html);
			}
			
			stepWrap.find('.stepind_confirmed').show();
			stepWrap.find('.step_confirmation').show();
		},
		
		removeSteps: function(step){
			var $this = this;
			this.wrapper.find('div[data-step]').each(function(){
				var iter = parseInt($(this).attr('data-step'));
				if (iter >= step) {
					$this.removeStep(iter);
				}
			});
		},
		
		removeStep: function(step) {
			this.wrapper.find('div[data-step="'+step+'"]').remove();
			this.choice_path.pop();
			this.killAddToCart();
			this.recalculatePrice();
		},
		
		getStepWrap: function(step, type, html) {
			var $this = this;
			
			var stepHtml = '';
			//stepHtml += '<div class="alert alert-info">Step: ' + step + ', Type: ' + type + '</div>';
			stepHtml += '<div class="step_ind">';
			stepHtml += '<span class="stepind_active">' + step + '</span>';
			stepHtml += '<span class="stepind_confirmed">'+this.lang.CHECK+'</span>';
			stepHtml += '</div>';
			stepHtml += '<div class="step_cnt">';
			stepHtml += '<div class="step_choice">'+ html +'</div>';
			stepHtml += '<div class="step_confirmation"></div>';
			stepHtml += '</div>';
			
			var wrap = $('<div></div>', {
				'class': "djc_cfp_step djc_cfp_step_" + type,
				id: "djc_cfp_step-" + step,
				'data-step': step,
				html: stepHtml
			});
			
			if (step > 1) {
				var backBtn = $('<button />', {
					role: 'button',
					type: 'button',
					'class': 'btn djc_cfg_back_btn',
					html: this.lang.GO_BACK 
				});
				
				backBtn.click(function(){
					if ($this.current_step > step) return;
					
					if ($this.wrapper.find('div[data-step="'+step+'"]').first().hasClass('step-confirmed')) {
						$this.choice_path.pop();
						$this.recalculatePrice();
						$this.editStep(step);
					} else {
						$this.removeStep(step);
						$this.editStep(step-1);
					}
				});
				
				//wrap.find('.step_choice').append(backBtn);
				wrap.append(backBtn);
			}
			
			wrap.find('.step_confirmation, .step_ind').click(function(){
				var curStep = parseInt(wrap.attr('data-step'));
				
				$this.choice_path.pop();
				
				if ((curStep <= 2 && this.core_steps == 2) || (curStep == 1 && this.core_steps == 1)) {
					$this.product = {};
				}
				
				$this.removeSteps(curStep+1);
				$this.editStep(curStep);
			});
			
			return wrap;
		},
		
		doXhr: function(layout, extra_params) {
			var $this = this;
			
			if (this.xhr && this.xhr.readyState != 4) {
				this.xhr.abort();
			}
			
			this.xhr = $.ajax({
				url: this.viewUri,
				data: 'layout=' + layout + (typeof extra_params == 'undefined' ? '' : '&' + extra_params),
				success: function(data){
					if (layout == 'steps') {
						if (typeof data == 'undefined' || data == '' || data.trim() == '') {
							$this.completeAllSteps();
							return;
						}
						$this.cacheSteps(layout, data);
						
						var stepData = $($this.steps).get(0);
						$this.addStep(layout, $(stepData).html());
						$this.editStep($this.current_step);
						
					} else {
						//this.step_count++;
						$this.addStep(layout, data);
					}
				}
			});
		},
		
		addStep: function(layout, data) {
			var $this = this;
			
			if (typeof data == 'undefined') {
				return;
			}
			
			$this.current_step++;
			
			$this.wrapper.append($this.getStepWrap($this.current_step, layout, data));
			$this.editStep($this.current_step);
			
			var items = this.wrapper.find('div[data-step="'+this.current_step+'"] .djc_cfg_item');
			if (items.length < 1) return;
			
			//this.step_count++;
			this.addStepEvents(items);
		},
		
		cacheSteps: function(layout, data) {
			var $this = this;
			var temp = $('<div style="display: none"></div>');
			
			$(document.body).append(temp);
			temp.html(data);	
			
			this.steps = $(temp).find('.djc_cfg_step_outer');
			this.step_count += this.steps.length;
		},
		
		addStepEvents: function(items) {
			/*document.formvalidator = null;
			jQuery(function() {
				document.formvalidator = new JFormValidator();
			});*/
			
			var $this = this;
			
			items.click(function(){
				var type = $(this).attr('data-type');
				if (!type /*|| type == 'steps'*/) {
					return;
				} else if (type == 'categories') {
					return $this.clickCategory(this, $(this).attr('data-id'), $(this).attr('data-lbl'));
				}  else if (type == 'items') {
					return $this.clickItem(this, $(this).attr('data-id'), $(this).attr('data-lbl'), $(this).attr('data-price'));
				}  else if (type == 'steps') {
					//console.log(JSON.parse($(this).attr('data-dependancies')));
					return $this.clickStep(this, $(this).attr('data-id'), $(this).attr('data-field_id'), $(this).attr('data-lbl'), $(this).attr('data-value'));
				}  else if (type == 'dimensions') {
					return $this.clickDimensions(this);
				}
			});
		},
		
		clickCategory: function(element, id, label, value) {
			var html = this.lang.SELECTED_CATEGORY + '<strong>' + label + '</strong>';
			
			this.confirmStep(this.current_step, html);
			
			this.doXhr('items', 'cid=' + id);
			
			this.recalculatePrice();
		},
		
		clickItem: function(element, id, label, price) {
			var html = this.lang.SELECTED_PRODUCT + '<strong>' + label + '</strong>';
			
			this.confirmStep(this.current_step, html);
			var unit = $(element).attr('data-unit');
			if (typeof unit != 'undefined') {
				unit = JSON.parse(unit);
			}
			this.product = {
				id: id,
				name: label,
				price: price,
				unit: unit
			};
			
			this.doXhr('steps', 'id=' + id);
			
			this.recalculatePrice();
		},
		
		clickDimensions: function(element) {
			if (document.formvalidator.isValid(document.getElementById('djc_cfg_form')) == false) {
				return;
			}
			
			var $this = this;
			var label = '';
			var dims = [];
			var unit = $(element).attr('data-unit');
			
			var dimensions = [];
			
			$(element).parents('.djc_cfp_step').find('input[type="number"]').each(function(i, e){
				var val = parseInt($(e).val());
				var min = parseInt($(e).attr('min'));
				var max = parseInt($(e).attr('max'));
				if (!isNaN(min) && min > 0 && min > val) {
					val = min;
				} else if (!isNaN(max) && max > 0 && max < val){
					val = max;
				}
				$(e).val(val);
				var newDim = $(e).attr('data-lbl') + '=' + val + unit;
				dims.push(newDim);
				dimensions.push({
					name: $(e).attr('data-lbl'),
					id: $(e).attr('name'),
					value: val,
					unit: unit
				});
			});
			
			label = dims.join(', ');
			var html = this.lang.PRODUCT_DIMENSIONS + '<strong>' + label + '</strong>';
			
			this.confirmStep(this.current_step, html);
			this.choice_path.push({
				type: 'dimensions',
				id: null, 
				field_id: null, 
				label: this.lang.PRODUCT_DIMENSIONS, 
				value: dimensions,
				price: null,
				pricemod: null,
				sku: '',
				info: label,
				});
			
			var stepCnt = $this.current_step - $this.core_steps;
			var stepData = $($this.steps).get(stepCnt);

			if (typeof stepData != 'undefined' && stepData) {
				$this.addStep('steps', $(stepData).html());
				$this.filterStep($this.current_step);
				$this.editStep($this.current_step);
			} else {
				this.completeAllSteps();
			}
			
			this.recalculatePrice();
			
			return true;
		},
		
		clickStep: function(element, id, field_id, label, value) {
			var $this = this;
			
			var html;
			if (typeof value != 'undefined' && value) {
				html = this.lang.SELECTED + ' ' + label + ': <strong>' + value + '</strong>';
			} else {
				html = this.lang.SELECTED + ': <strong>' + label + '</strong>';
			}
			
			this.confirmStep(this.current_step, html);
			this.choice_path.push({
				type: 'step',
				id: id, 
				field_id: field_id, 
				label: label, 
				value: value,
				price: $(element).attr('data-price'),
				pricemod: $(element).attr('data-pricemod'),
				sku: $(element).attr('data-sku'),
				info: $(element).attr('data-info'),
				});
			
			var stepCnt = $this.current_step - $this.core_steps;
			var stepData = $($this.steps).get(stepCnt);

			if (typeof stepData != 'undefined' && stepData) {
				$this.addStep('steps', $(stepData).html());
				$this.filterStep($this.current_step);
				$this.editStep($this.current_step);
			} else {
				this.completeAllSteps();
			}
			
			this.recalculatePrice();
		},
		
		recalculatePrice: function() {
			var $this = this;
			var price = 0;
			
			if ($this.product && typeof $this.product.price != 'undefined' ) {
				price = parseFloat($this.product.price);
			}
			
			$.each(this.choice_path, function(){
				var addonPrice = parseFloat(this.price);
				if (isNaN(addonPrice) == false && addonPrice != 0.0) {
					var mod = 'add';
					if (this.pricemod) {
						mod = this.pricemod;
					}
					
					if (mod == 'multiply') {
						price = $this.fixRounding(price * addonPrice, 2);
					} else if (mod == 'add') {
						price = $this.fixRounding(price + addonPrice, 2);
					}
				}
			});
			
			var retObj = {price: price};
			$(document).trigger('djc2config:recalculate', [this, price, retObj]);
			//price = price.toFixed(2);
			price = retObj.price.toFixed(2);
			
			this.displayPriceHtml(price);
		}, 
		
		completeAllSteps: function() {
			var $this = this;
			
			var submitWrap = $(this.wrapper).parent().find('.djc_cfg_wrap_submit');
			if (submitWrap.length == 0) {
				submitWrap = $('<div class="djc_cfg_wrap_submit"></div>');
				$(this.wrapper).parent().append(submitWrap);
			} else {
				submitWrap = submitWrap.first();
			}
			$(submitWrap).html('');
			
			var html = '';
			
			html += '<input type="hidden" name="item_id" value="'+this.product.id+'" />';
			$.each(this.choice_path, function(){
				//console.log(this);
				if (this.type == 'dimensions') {
					if (this.value.length > 0) {
						for (var i = 0; i < this.value.length; i++) {
							html += '<input type="hidden" name="dimension['+this.value[i].id+']" value="'+this.value[i].value+'" />';
						}
					}
				} else {
					html += '<input type="hidden" name="config_field['+this.field_id+']" value="'+this.id+'" />';
				}
			});
			
			if (typeof this.product.unit != 'undefined') {
				var u = this.product.unit;
				var min_qty = u.is_int == '1' ? parseInt(u.min_quantity) : parseFloat(u.min_quantity);
				var ustep = u.is_int == '1' ? parseInt(u.step) : parseFloat(u.step);
				//console.log(u);
	
				//html += '<input type="hidden" name="quantity" value="'+u.min_quantity+'" />';
				html += '<input class="input-small input" type="number" name="quantity" value="'+min_qty+'" min="'+min_qty+'" step="'+ustep+'" />';
			} else {
				html += '<input type="hidden" name="quantity" value="1" />';
			}
			html += '<button type="submit" class="btn btn-primary submit">'+this.lang.ADD_TO_CART+'</button>';
			
			$(submitWrap).html(html);
			
			$(submitWrap).find('input[name="quantity"]').change(function(evt){
				var retObj = {price: 0};
				$(document).trigger('djc2config:recalculate', [$this, price, retObj]);
				
				if (!isNaN(retObj.price)) {
					var price = retObj.price.toFixed(2);
					$this.displayPriceHtml(price);
				}
			});
		},
		
		killAddToCart: function() {
			var submitWrap = $(this.wrapper).parent().find('.djc_cfg_wrap_submit');
			if (submitWrap.length > 0) {
				submitWrap.html('');
			}
		},
		
		fixRounding: function(value, precision) {
		    var power = Math.pow(10, precision || 0);
		    return Math.round(value * power) / power;
		},
		
		displayPriceHtml: function(price) {
			var priceWrap = $(this.wrapper).find('.djc_cfg_wrap_price');
			if (priceWrap.length == 0) {
				priceWrap = $('<div class="djc_cfg_wrap_price alert alert-message"></div>');
				$(this.wrapper).prepend(priceWrap);
			} else {
				priceWrap = priceWrap.first();
			}
			
			$(priceWrap).html('Price: ' + price);
		}
	};
	
	window.DJC2ConfigurableWizard = DJC2ConfigurableWizard;
	
})(jQuery);


